Option Explicit 

'*********************************************************************************
'Esse script serve para validar arquivos xml contra um dado schema.
'Para utilizá-lo, execute wscript validador.vbs <nome do arquivo xml> <nome do arquivo xsd>
'---------------------------------------------------------------------------------
'Autor: Fabiano Andrade Lima
'Data:  04/2016
'*********************************************************************************

Dim file, schema

VerificaParametros

Valida file, schema

Sub VerificaParametros
	if WScript.Arguments.length <> 2 then
		WScript.Echo "Para executar esse script, informe o nome do arquivo xml, e o nome do arquivo que contém o schema."
		WScript.Quit(0)
	Else
		file = WScript.Arguments(0)
		schema = WScript.Arguments(1)
	end If
End Sub

'***********************************************************************************
'Adaptado do post disponível em
'http://stackoverflow.com/questions/11708492/msxml-vba-validating-xml-against-xsd-the-namespace-provided-differs-from-t
'***********************************************************************************
Sub Valida(file, schema)
    Dim xmlDoc : set xmlDoc = CreateObject("MSXML2.DOMDocument.6.0")
	Dim xmlSchema : set xmlSchema = CreateObject("MSXML2.DOMDocument.6.0")
    Dim objSchemaCache : set objSchemaCache = CreateObject("Msxml2.XMLSchemaCache.6.0")
    Dim objErr

	'Carregando o schema...........
    With xmlSchema
        .async = False
        .validateOnParse = False
        .resolveExternals = False
        .load schema
    End With
	
    objSchemaCache.Add "http://www.ouvidorias.gov.br", xmlSchema

	'Carregando o arquivo xml...............
	set xmlDoc = CreateObject("MSXML2.DOMDocument.6.0")
    'Set xmlDoc = LoadXmlFile(file)
    With xmlDoc
        .async = False
        .validateOnParse = False
        .resolveExternals = False
        .load file
    End With
	
	'Checando por erros no carregamento...........
	If xmlDoc.parseError.errorCode <> 0 Then
		Dim myErr : Set myErr = xmlDoc.parseError
        WScript.echo "Erro no xml"
		WScript.echo "Codigo: " & myErr.errorCode
		WScript.echo "Razao: " & myErr.reason
		WScript.echo "Linha: " & myErr.line
		WScript.echo "Posicao: " & myErr.linepos
		WScript.echo "Texto: " & myErr.srcText
		WScript.Quit(1)
	End If
		
	'Validando de acordo com o esquema....................
	Set xmlDoc.Schemas = objSchemaCache

    Set objErr = xmlDoc.Validate()
    If objErr.errorCode = 0 Then
        WScript.echo "Nao foram detectados erros no xml"
    Else
        WScript.echo "Erro no xml"
		WScript.echo "Codigo: " & objErr.errorCode
		WScript.echo "Razao: " & objErr.reason
		WScript.echo "Linha: " & objErr.line
		WScript.echo "Posicao: " & objErr.linepos
		WScript.echo "Texto: " & objErr.srcText
    End If
End Sub

