###### UF de Origem e Destino ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa função tem como argumentos: direcao, produto e grupo. 
# direcao = (origem, destino)
# produto = (tora, acabado)
# grupo = (geral, grupo1, grupo2, grupo3)


# Pacotes usados
library(data.table)
library(dplyr)
library(tidyr)
library(ggplot2)
library(scales)
library(forcats) #para a função fct_reorder()
library(grid)
library(gridExtra)

#  Lê sisdof_tora
sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                     colClasses = c("character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_tora$V1 <- NULL

# Lê sisdof_produto
sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                        colClasses = c("character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_produto$V1 <- NULL

# Abre planilha com nomes de municipios do IBGE que contem UF, Coordenadas e Codigo IBGE. Abrir apenas as colunas 4 (UF) e 5 (Estado)
municipios.ibge.uf <- fread("Municipios_Brasileiros_UF_Codigo.csv")[,4:5] # obtida em https://github.com/kelvins/Municipios-Brasileiros


#### Funcao para gerar os graficos ####
uf <- function (direcao, grupo) {
    # direcao = (origem, destino). Origem, implica tora. Destino, implica produto acabado.
    # grupo = (geral, grupo1, grupo2, grupo3)
    
    # geral = todas as espécies 
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    # Função para passar apenas a primeira letra de uma palavra para maiúscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Títulos do gráfico
    titulo.grupo <- capFirst(grupo)
    
    # Dimensoes do grafico
    #largura <- 10.3
    texto <- 21.87
    bola <- 25.5
    
    if (direcao == "origem") {
        
        # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.1.Toras", 
                                     "1.1.5.UF.Origem")),
               dir.create(file.path("Figuras", 
                                    "1.1.Toras", 
                                    "1.1.5.UF.Origem"),
                          recursive = TRUE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.1.Toras", 
                        "1.1.5.UF.Origem"))
        
        
        # sisdof =  sisdof_tora. Origem, implica tora
        sisdof <- sisdof_tora
        
        # Legendas dos gráficos a serem gerados
        direcao <- "UF.Origem"
        g.titulo <- "UFs Produtoras de Madeira"  # Titulo do grafico
        g.sub.titulo <- "Volume relativo produzido de 2012 a 2017 (%)"
        
        # Cores do Grafico: Tons azuis 
        cor_segmento <- "lightskyblue"                # cor da linha   
        cor_ponto <- "navy"                   # cor do ponto
        
    } else if (direcao == "destino") {
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.2.Produto.Acabado", 
                                     "1.2.5.UF.Destino")),
               dir.create(file.path("Figuras", 
                                    "1.2.Produto.Acabado", 
                                    "1.2.5.UF.Destino"),
                          recursive = TRUE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.2.Produto.Acabado", 
                        "1.2.5.UF.Destino"))
        
        # sisdof = sisdof_produto. Destino, implica produto acabado.
        sisdof <- sisdof_produto
        sisdof <- sisdof[sisdof$Pais.Destino == "BRASIL"]
        
        # Legendas dos gráficos a serem gerados
        direcao <- "UF.Destino"
        g.titulo <- "UFs Consumidoras de Produtos Madeireiros"  # Titulo do grafico
        g.sub.titulo <- "Volume relativo consumido de 2012 a 2017 (%)"
        
        # Cores do Grafico: Tons vermelhos 
        cor_segmento <- "salmon"                    # cor da linha   
        cor_ponto <- "firebrick4"                   # cor do ponto
        
    } 
    
    if ( grupo == "geral") {
        
        y <- sisdof
        g.sub.titulo.grupo <- "Todas as espécies"
    
    } else if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espécies contidas no grupo 1
        y <- sisdof[sisdof$Grupo == "Grupo.1"]                            # subset com as espécies do grupo 1
        g.sub.titulo.grupo <- "25 Espécies mais movimentadas"
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espécies contidas no grupo 2
        y <- sisdof[!is.na(sisdof$Portaria.443)]                         # subset com as espécies da portaria 443 e que nao estao nos grupos 1 ou 3
        g.sub.titulo.grupo <- "Espécies ameaçadas de extinção"
                         
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espécies contidas no grupo 3
        y <- sisdof[!is.na(sisdof$Cites)]                                 # subset com as espécies da portaria 443 e que nao estao nos grupos 1 ou 3
        g.sub.titulo.grupo <- "Espécies CITES"
                         
        
    }
    
    ## Faz o gráfico dos grupos
    
    # Cria subset, excluindo as movimentações para o exterior, mantendo apenas aquelas com 
    # valores "Brasil" para a coluna Pais.Destino 
    agregado <- y[y$Pais.Destino == "BRASIL"]
    
    # Agrega de acordo com Aa UF de origem/destino
    agregado <- y[, .(sum(Volume.Total)),
                  by = .(y[[direcao]])]
    
    # Cria a coluna volume percentual
    agregado$Volume.Percentual <- agregado$V1/sum(agregado$V1)*100 
    
    # Renomeia as colunas V1 e V2  
    colnames(agregado) <- c(direcao, "Volume.Total", "Volume.Percentual")
    
    # Para o grafico entender que é pra ordenar pelo Volume.Total
    agregado[[direcao]] <- factor(agregado[[direcao]], 
                                              levels = unique(agregado[[direcao]])[order(agregado$Volume.Percentual, 
                                                                                                     decreasing = TRUE)])
    
    # Ordena de forma crescente em relação ao Volume.Total
    agregado <- agregado[order(agregado$Volume.Percentual, decreasing = TRUE),]
        
    # Seleciona no máximo 10 Estados
    
    if (length(unique(agregado[[direcao]])) >= 10) {
        
        agregado <- agregado[1:10,]
        
        }   else {
        
        agregado <- agregado[1:length(unique(agregado[[direcao]])),]
        
        }   
    
    # modifica os nomes dos estados, substituindo a sigla pelo nome completo
    x <- match(agregado[[direcao]], 
               municipios.ibge.uf$UF)   # procura os nomes das especies de sisdof1 que estão presentes em nomes.diferentes$Especie.Sisflora. O resultado é o objeto x no qual irão aparecer as posições em nomes.diferentes$Especie.Sisflora que possuem nomes de especies de sisdof1$Especie 
    x <- x[!is.na(x)]                               # esse comando elimina de x os NAs. Dessa forma, x contém as posições em nomes.diferentes$Especie.Sisflora das especies de sisdof1$Especies com nomes escritos de forma errada e que devem ser substituido pelos nomes contidos em nomes.diferentes$Especie.Resolvida
    
    agregado[[direcao]] <-  municipios.ibge.uf$Estado[x]  # 
    
    # Largura do grafico de acordo com o tamanho do titulo ou subtitulo. 
    # Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
    
    largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                          valor = c(1.11*nchar(g.titulo), 
                                    nchar(g.sub.titulo.grupo),
                                    nchar(g.sub.titulo)))
    
    largura <- max(largura$valor, na.rm = TRUE)
    
    # Altura do grafico
    altura <- 1.6 + (0.8*length(agregado[[direcao]]))
    
    if (length(agregado[[direcao]]) != 0) {
    
    # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
    agregado <- mutate(agregado,  nova.direcao = fct_reorder(agregado[[direcao]],
                                                             agregado$Volume.Percentual))
    
    # Gera o grafico percentual
    gplot <- ggplot(agregado, aes(agregado$nova.direcao, 
                                      agregado$Volume.Percentual)) +
        geom_segment(aes(x = agregado$nova.direcao, 
                         y = 0, 
                         xend = agregado$nova.direcao, 
                         yend = agregado$Volume.Percentual),
                     position = position_dodge(width = 0.8),
                     color = cor_segmento,
                     size = bola/3) +
        geom_point(size = bola,
                   color = cor_ponto,
                   position = position_dodge(width = 0.8))+
        scale_y_continuous(limits=c(0, 1.1*max(agregado$Volume.Percentual)), oob=rescale_none)+
        geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                     big.mark = ".", 
                                     decimal.mark = ",")),
                  color = "white", 
                  size = 0.3*texto,
                  fontface = "bold")+
        theme(plot.title = element_text(lineheight = 0.1, 
                                        face = "bold",
                                        hjust = 0.5,
                                        size = 1.3*texto),
              plot.subtitle = element_text(lineheight = 0.4, 
                                           face = "bold",
                                           hjust = 0.5,
                                           size = 1.17*texto),
              axis.title.y = element_blank(),
              axis.text.y = element_text(size = 1.1*texto,
                                         color = cor_ponto,
                                         face = "bold",
                                         hjust = 0),
              axis.title.x = element_blank(),
              axis.text.x = element_blank(),
              axis.ticks.x = element_blank(),
              axis.ticks.y = element_blank(),
              panel.background = element_blank(),
              panel.grid.major = element_blank(), 
              panel.grid.minor = element_blank())+
        coord_flip() 
    
    # Abre para gravacao em PDF
    pdf(paste0("#", 
               titulo.grupo,
               "_", 
               direcao, 
               ".pdf"), 
        width = largura/3.8, 
        height = altura)
    
    grid.arrange(
        gplot,
        nrow = 1,
        top = textGrob(paste0(g.titulo,
                              "\n",
                              g.sub.titulo.grupo,
                              "\n",
                              g.sub.titulo),
                       gp = gpar(fontface = 2, 
                                 fontsize = 26,
                                 lineheight = 0.8)))
    
        
# Fecha o PDF
    dev.off()
    
    }
    
## Faz os gráficos para cada uma das espécies da lista dos grupos 1, 2 ou 3.
    
    if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Agrega de acordo com o municipio de origem e UF.Origem
            especie <- especie[, .(sum(Volume.Total)),
                        by = .(especie[[direcao]])]
            
            # Cria a coluna volume percentual
            especie$Volume.Percentual <- especie$V1/sum(especie$V1)*100 
            
            # Renomeia as colunas V1 e V2  
            colnames(especie) <- c(direcao, "Volume.Total", "Volume.Percentual")
            
            # Para o grafico entender que é pra ordenar pelo Volume.Total
            especie[[direcao]] <- factor(especie[[direcao]], 
                                         levels = unique(especie[[direcao]])[order(especie$Volume.Percentual, 
                                                                                   decreasing = TRUE)])
            
            # Ordena de forma crescente em relação a data
            especie <- especie[order(especie$Volume.Percentual, decreasing = TRUE),]
        
            # Seleciona no máximo 10 Estados
            
            if (length(unique(especie[[direcao]])) >= 10) {
                
                especie <- especie[1:10,]
                
                }   else {
                
                especie <- especie[1:length(unique(especie[[direcao]])),]
                
                }   
            
            # modifica os nomes dos estados, substituindo a sigla pelo nome completo
            x <- match(especie[[direcao]], 
                       municipios.ibge.uf$UF)   # procura os nomes das especies de sisdof1 que estão presentes em nomes.diferentes$Especie.Sisflora. O resultado é o objeto x no qual irão aparecer as posições em nomes.diferentes$Especie.Sisflora que possuem nomes de especies de sisdof1$Especie 
            x <- x[!is.na(x)]                               # esse comando elimina de x os NAs. Dessa forma, x contém as posições em nomes.diferentes$Especie.Sisflora das especies de sisdof1$Especies com nomes escritos de forma errada e que devem ser substituido pelos nomes contidos em nomes.diferentes$Especie.Resolvida
            
            especie[[direcao]] <-  municipios.ibge.uf$Estado[x]  # 
            
            # Largura do grafico.
            largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                                  valor = c(1.11*nchar(g.titulo), 
                                            nchar(lista_especies[i]),
                                            nchar(g.sub.titulo)))
            largura <- max(largura$valor, na.rm = TRUE)
            
            # Altura do grafico
            altura <- 1.6 + (0.8*length(especie[[direcao]]))
            
            if (length(especie[[direcao]]) != 0) {
            
            # Ordena as barras de forma decrescente quando o grafico fica deitado.
            especie <- mutate(especie,  nova.direcao = fct_reorder(especie[[direcao]],
                                                                   especie$Volume.Percentual))
            
            # Gera grafico
            gplot <- ggplot(especie, 
                            aes(especie$nova.direcao,
                                especie$Volume.Percentual))+
                geom_segment(aes(x = especie$nova.direcao, 
                                 y = 0, 
                                 xend = especie$nova.direcao, 
                                 yend = especie$Volume.Percentual),
                             position = position_dodge(width = 0.8),
                             color = cor_segmento,
                             size = bola/3) +
                geom_point(size = bola,
                           color = cor_ponto,
                           position = position_dodge(width = 0.8))+
                scale_y_continuous(limits=c(0, 1.1*max(especie$Volume.Percentual)), oob=rescale_none)+
                geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                             big.mark = ".", 
                                             decimal.mark = ",")),
                          color = "white", 
                          size = 0.3*texto,
                          fontface = "bold")+
                theme(plot.title = element_text(lineheight = 0.1, 
                                                face = "bold",
                                                hjust = 0.5,
                                                size = 1.3*texto),
                      plot.subtitle = element_text(lineheight = 0.4, 
                                                   face = "bold",
                                                   hjust = 0.5,
                                                   size = 1.17*texto),
                      axis.title.y = element_blank(),
                      axis.text.y = element_text(size = 1.1*texto,
                                                 color = cor_ponto,
                                                 face = "bold",
                                                 hjust = 0),
                      axis.title.x = element_blank(),
                      axis.text.x = element_blank(),
                      axis.ticks.x = element_blank(),
                      axis.ticks.y = element_blank(),
                      panel.background = element_blank(),
                      panel.grid.major = element_blank(), 
                      panel.grid.minor = element_blank())+
                coord_flip() 
                
        # Abre para gravacao em PDF
        pdf(paste0(titulo.grupo,"_", 
                   lista_especies[i],
                   "_",
                   direcao,
                   ".pdf"), 
            width = largura/3.8, 
            height = altura)
        
        grid.arrange(
            gplot,
            nrow = 1,
            top = textGrob(paste0(g.titulo,
                                  "\n",
                                  lista_especies[i],
                                  "\n",
                                  g.sub.titulo),
                           gp = gpar(fontface = 2, 
                                     fontsize = 26,
                                     lineheight = 0.8)))
    
       # Fecha o PDF
        dev.off()
        
        }
        
        }
        
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
}

uf("origem", "geral")
uf("origem", "grupo1")
uf("origem", "grupo2")
uf("origem", "grupo3")

uf("destino", "geral")
uf("destino", "grupo1")
uf("destino", "grupo2")
uf("destino", "grupo3")
    
   
    