###### Volume Anual  ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa função tem como argumentos: produto e grupo. 
# produto = (tora, acabado)
# grupo = (geral, grupo1, grupo2, grupo3)


# Carrega pacotes a serem utilizados
    library(data.table)
    library(dplyr)
    library(tidyr)
    library(ggplot2)
    #library(scater) # para a funcao multiplot

    #  Lê sisdof_tora
    sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                         colClasses = c("character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "character", "character",
                                        "character", "numeric", "numeric"))
    
    # Deleta coluna V1 criada pelo comando fread.
    sisdof_tora$V1 <- NULL
    
    # Lê sisdof_produto
    sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                            colClasses = c("character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "character", "character",
                                           "character", "numeric", "numeric"))
    
    # Deleta coluna V1 criada pelo comando fread.
    sisdof_produto$V1 <- NULL
    
vol_anual <- function (produto, grupo) {
    # produto = (tora, acabado)
    
    # grupo = (geral, grupo1, grupo2, grupo3)
    # geral = todas as espécies
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Espécies ameaçadas de extinção)
    # grupo3 = cites
    
    # Função para passar apenas a primeira letra de uma palavra para maiúscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Títulos do gráfico
    titulo <- capFirst(grupo)
    
    if (produto == "tora") {
        
        # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.1.Toras", 
                                     "1.1.1.Volume.Anual")),
               dir.create(file.path("Figuras",
                                    "1.1.Toras",
                                    "1.1.1.Volume.Anual"),
                          recursive = TRUE,
                          showWarnings = FALSE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.1.Toras", 
                        "1.1.1.Volume.Anual"))
        
        # sisdof =  sisdof_tora
        sisdof <- sisdof_tora
        
        # Nome no eixo y dos gráficos a serem gerados
        nome <- "Produção Madeireira Anual - "
        
        } else if (produto == "acabado") {
            
            # Muda diretório de trabalho para o de Toras. Cria o diretorio se ja nao existir.
            
            ifelse(!dir.exists(file.path("Figuras", 
                                         "1.2.Produto.Acabado", 
                                         "1.2.1.Volume.Anual")),
                   dir.create(file.path("Figuras", 
                                        "1.2.Produto.Acabado", 
                                        "1.2.1.Volume.Anual"),
                              recursive = TRUE,
                              showWarnings = FALSE),
                   FALSE)
            
            setwd(file.path("Figuras", 
                            "1.2.Produto.Acabado", 
                            "1.2.1.Volume.Anual"))
            
            # sisdof = sisdof_produto
            sisdof <- sisdof_produto
        
            # Nome no eixo y dos gráficos a serem gerados
            nome <- "Consumo Anual de Madeiras - "
            
            } 
    
    if (grupo == "grupo1") {
            
            lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espécies contidas no grupo 1
           
            } else if (grupo == "grupo2") {
                
                lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espécies contidas no grupo 2
                
                } else if (grupo == "grupo3") {
                    
                    lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espécies contidas no grupo 3
                    
                }
    
    y <- sisdof
    
    # Elimina o mês, mantendo apenas o ano
    y$Emissao <- as.numeric(sub("^[0-9]+-", "", y$Emissao))
    
    y <- y[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                  by = .(Especie, 
                         Emissao,
                         Portaria.443,
                         Cites)]
    
    # Renomeia as colunas V1 e V2  
    y <- dplyr::rename(y,
                              "Volume.Total" = "V1",
                              "Preco.Total" = "V2")
    
    nomes.443 <- unique(y$Especie[!is.na(y$Portaria.443)])
    
    nomes.cites <- unique(y$Especie[!is.na(y$Cites)])
    
    ## Cria o subset geral
    geral <- y
    
    # Cria a coluna Categoria para agrupar os graficos
    geral$Categoria <- "Todas as espécies"
    
    # Agrega
    geral <- geral[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                       by = .(Emissao,
                              Categoria)]
    
    # Renomeia as colunas V1 e V2  
    geral <- dplyr::rename(geral,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
    ## Cria o subset Espécies ameaçadas de extinção
    agregado443 <- y[!is.na(y$Portaria.443)]
    
    # Cria a coluna Categoria
    agregado443$Categoria <- "Espécies ameaçadas de extinção"
    
    # Agrega
    agregado443 <- agregado443[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregado443 <- dplyr::rename(agregado443,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Cria o subset "Espécies CITES"
    agregadocites <- y[!is.na(y$Cites)]
    
    # Cria a coluna Categoria
    agregadocites$Categoria <- "Espécies CITES"
    
    # Agrega
    agregadocites <- agregadocites[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregadocites <- dplyr::rename(agregadocites,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Faz o gráfico das especies
    
    #if (grupo == "geral") {
        
        #lista_especies <- "Geral"
    
        especie <- rbind(geral, agregado443, agregadocites)
        
        especie$Categoria <- factor(especie$Categoria, 
                                    levels = c("Todas as espécies",
                                               "Espécies ameaçadas de extinção",
                                               "Espécies CITES"))
        
        # Ordena de forma crescente em relação a data
        especie <- especie[order(especie$Emissao),]
        
        # Cria tabela com informações gerais
        dados <- data.table("Especie" = as.character(unique(especie$Categoria)),
                            "Vol.2012" = round(especie$Volume.Total[especie$Emissao == "2012" & 
                                                                  especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Vol.2013" = round(especie$Volume.Total[especie$Emissao == "2013" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Vol.2014" = round(especie$Volume.Total[especie$Emissao == "2014" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Vol.2015" = round(especie$Volume.Total[especie$Emissao == "2015" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Vol.2016" = round(especie$Volume.Total[especie$Emissao == "2016" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2),
                            "Vol.2017" = round(especie$Volume.Total[especie$Emissao == "2017" & 
                                                                        especie$Categoria == as.character(unique(especie$Categoria))],2))
        
        # Cria a coluna Volume.Relativo, em funcao do volume de 2012
        # especie$Volume.Relativo <- especie$Volume.Total/especie$Volume.Total[especie$Emissao == "2012"]
        
        if (grupo == "geral") {
            
            lista_especies <- "Geral"
        
        gplot <- ggplot(especie, aes(x = Emissao, 
                                     y = Volume.Total/1000,
                                     colour = factor(Categoria)))+          # colore as retas conforme as diferentes Categorias (Todas as espécies, Espécies ameaçadas de extinção ou Espécies CITES)
            facet_wrap(~ Categoria, nrow = 2, scales = "free_y")+           # faz em uma única figura, dois ou mais gráficos de acordo com a Categoria. Ex: Todas as espécies, Espécies ameaçadas de extinção e Cite.
            geom_vline(data = data.frame(xint=2014,
                                         Categoria = "Espécies ameaçadas de extinção"),
                       aes(xintercept=xint),
                       linetype="F1")+
            geom_point() +                                                  # adiciona os pontos no gráfico
            geom_smooth(method = "loess")+                                  # adiciona uma reta curva conforme os pontos do gráficos.
            #geom_label(data = especie,                                      # adiciona uma caixa de texto com os valores de y do gráfico
            #           aes(label = format(round(Volume.Total/1000, 2),
            #                              big.mark = ".", 
            #                              decimal.mark = ",")),             # indica que o texto da caixa de texto serao os valores do Volume.Total/1000, mostrando apenas duas casas decimais. O separador de milhar e "." e o separador de decimal e ",".
            #           vjust = "inward",                                    # alinhamento vertical da caixa de texto
            #           hjust = "inward",                                    # alinhamento horizontal da caixa de texto
            #           size = 4,                                            # tamanho do texto da caixa de texto 
            #           label.size = 0.1)+                                   # tamanho da borda da caixa de texto 
            geom_label_repel(data = especie,                                 # usando geom_label_repel ao inves de geom_label evita sobreposicao das caixas de texto com os valores do volume
                             aes(label = format(round(Volume.Total/1000, 2),
                                                big.mark = ".",
                                                decimal.mark = ",")),
                             segment.size  = 0.2,
                             segment.color = "grey50",
                             box.padding = unit(0.35, "lines"),
                             size = 4) +
            theme(strip.text.x = element_text(size = 14),                   # tamanho do titulo de cada um dos graficos do facet_wrap
                  axis.title.x = element_text(size = 14),                   # tamanho dos titulo do eixo x ("Ano")
                  axis.text.x = element_text(size = 12),                    # tamanho dos valores do eixo x (2012, 2013...)
                  axis.title.y = element_text(size = 14),                   # tamanho do titulo do eixo y
                  axis.text.y = element_blank(),                            # elimina o texto dos valores do eixo y (volume movimentado). Esses valores estarao na caixa de texto
                  axis.ticks.y = element_blank(),                           # elimina os marcos (ticks) do eixo y
                  legend.position = "none",
                  plot.title = element_text(lineheight=.8,                  # formata o titulo do grafico
                                            face="bold",
                                            hjust=0.5,
                                            size = 18),
                  panel.grid.minor = element_blank())+                      # elimina os grids menores
            ylab("Volume movimentado (x 1.000 m^3)")+                       # título do eixo y
                        
            xlab("Ano") +                                                   # título do eixo x
            ggtitle(paste0(nome,
                           "2012 a 2017",
                           "\n",
                           "Grupos de Espécies"))+                          # titulo do grafico
            scale_color_brewer(palette = "Dark2")+                           # usa a paleta de cores "Dark2" do pacote RColorBrewer
            scale_fill_manual("white")
            
        
        # Abre para gravacao em PDF
        pdf(paste0(lista_especies,
                   "_Volume Anual.pdf"), 
            width = 8,
            height = 6.5)
        
        print(gplot)
        
        # Fecha o PDF
        dev.off()
        
        } 
        
        if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Renomeia a coluna Especie para Categoria
            especie <- dplyr::rename(especie,
                                     "Categoria" = "Especie")
            
            # Deleta as colunas Portaria.443 e Cites de especie
            especie <- especie[, -(Portaria.443:Cites)]
            
            # Fusiona especie e geral
            especie <- rbind(especie, geral)
            
            if (grupo == "grupo1") {
                
                especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies"))
               
                 if (lista_especies[i] %in% nomes.443) {
                     
                     especie <- rbind(especie, agregado443)
                     
                     especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies ameaçadas de extinção"))
                     
                     } 
                
                if (lista_especies[i] %in% nomes.cites) {
                    
                    especie <- rbind(especie, agregadocites)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies CITES"))
                    
                    if (lista_especies[i] %in% nomes.443) {
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                    levels = c(lista_especies[i],
                                                               "Todas as espécies",
                                                               "Espécies ameaçadas de extinção",
                                                               "Espécies CITES"))
                        
                    } 
                    
                    
                }
                
                } else if (grupo == "grupo2") {
                    
                    especie <- rbind(especie, agregado443)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies ameaçadas de extinção"))
                    
                    if (lista_especies[i] %in% nomes.cites) {
                        
                        especie <- rbind(especie, agregadocites)
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies ameaçadas de extinção",
                                                           "Espécies CITES"))
                }
                
                } else if (grupo == "grupo3") {
                    
                    especie <- rbind(especie, agregadocites)
                    
                    especie$Categoria <- factor(especie$Categoria, 
                                            levels = c(lista_especies[i],
                                                       "Todas as espécies",
                                                       "Espécies CITES"))
                    
                    if (lista_especies[i] %in% nomes.443) {
                        
                        especie <- rbind(especie, agregado443)
                        
                        especie$Categoria <- factor(especie$Categoria, 
                                                levels = c(lista_especies[i],
                                                           "Todas as espécies",
                                                           "Espécies CITES",
                                                           "Espécies ameaçadas de extinção"))
                        
                    }
                    
                    }
           
                
            # Ordena de forma crescente em relação a data
            especie <- especie[order(especie$Emissao),]
            
            # Cria a coluna Volume.Relativo, em funcao do volume de 2012
            # especie$Volume.Relativo <- especie$Volume.Total/especie$Volume.Total[especie$Emissao == "2012"]
            
          
            # Gera o grafico
            
            gplot <- ggplot(especie, aes(x = Emissao,
                                         y = Volume.Total/1000,
                                         colour = factor(Categoria))) +
                facet_wrap(~ Categoria, 
                           nrow = 2, 
                           scales = "free_y")+
                geom_point() +
                #geom_line() +
                geom_smooth(method = "loess")+
                #geom_label(data = especie, 
                #         aes(label = format(round(Volume.Total/1000, 2),
                #                            big.mark = ".", 
                #                            decimal.mark = ",")),
                #         vjust = "inward",
                #         hjust = "inward",
                #         size = 4,
                #         label.size = 0.1)+
                geom_label_repel(data = especie,                                 # usando geom_label_repel ao inves de geom_label evita sobreposicao das caixas de texto com os valores do volume
                                 aes(label = format(round(Volume.Total/1000, 2),
                                                    big.mark = ".",
                                                    decimal.mark = ",")),
                                 segment.size  = 0.2,
                                 segment.color = "grey50",
                                 box.padding = unit(0.35, "lines"),
                                 size = 4) +
                ylab("Volume movimentado (x 1.000 m^3)")+
                xlab("Ano") +
                ggtitle(paste0(nome,
                               "2012 a 2017",
                               "\n",
                              lista_especies[i]))+
                theme(strip.text.x = element_text(size = 14),
                      axis.title.x = element_text(size = 14),
                      axis.text.x = element_text(size = 12),
                      axis.title.y = element_text(size = 14),
                      axis.text.y = element_blank(),
                      axis.ticks.y = element_blank(),
                      legend.position = "none")+
                theme(plot.title = element_text(lineheight=.8, 
                                                face="bold",
                                                hjust=0.5,
                                                size = 18))+
                theme(panel.grid.minor = element_blank())+
                scale_color_brewer(palette = "Dark2")+
                scale_fill_manual("white")
                
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo,"_" ,
                       lista_especies[i],
                       "_Volume Anual.pdf"), 
                width = 8, 
                height = 6.5)
            
            print(gplot)
            
            # Fecha o PDF
            dev.off()
            
            # Faz tabela com dados
            dados.esp <- data.table()
            for (j in 2012:2017) {
                
                if (length(especie$Volume.Total[especie$Emissao == j &
                                                especie$Categoria == lista_especies[i]]) != 0) {
                
                    dados.esp1 <- data.table("Especie" = lista_especies[i],
                                            "Ano" = round(especie$Volume.Total[especie$Emissao == j &
                                                                                       especie$Categoria == lista_especies[i]], 2))
                    
                    colnames(dados.esp1) <- c("Especie", paste0("Vol.", as.character(j)))
                    
                } else {
                    
                    dados.esp1 <- data.table("Especie" = lista_especies[i],
                                            "Ano" = NA)
                    colnames(dados.esp1) <- c("Especie", paste0("Vol.", as.character(j)))
                    
                }
                
                if (j == 2012) {
                    
                    dados.esp <- dados.esp1
                    
                } else {
                    
                    dados.esp <- cbind(dados.esp, dados.esp1[,2])
                }
                
                } 
            
            dados <- rbind(dados, dados.esp)
            
            
            }

        }
    

if (grupo == "grupo2") {
    
    # Faz a variaao percentual em relacao ao ano de 2012
    dados$Var.2013 <- round((dados$Vol.2013-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2014 <- round((dados$Vol.2014-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2015 <- round((dados$Vol.2015-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2016 <- round((dados$Vol.2016-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2017 <- round((dados$Vol.2017-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2015.14 <- round((dados$Vol.2015-dados$Vol.2014)/dados$Vol.2014*100, 2)
    
} else {
    
    # Faz a variaao percentual em relacao ao ano de 2012
    dados$Var.2013 <- round((dados$Vol.2013-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2014 <- round((dados$Vol.2014-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2015 <- round((dados$Vol.2015-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2016 <- round((dados$Vol.2016-dados$Vol.2012)/dados$Vol.2012*100, 2)
    dados$Var.2017 <- round((dados$Vol.2017-dados$Vol.2012)/dados$Vol.2012*100, 2)
    
}
        
        
# Grava a planilha com os dados
    write.csv(dados, paste0("#", titulo, "_Volume Anual.csv"))
    
# Sobe para o diretorio raiz do script    
  setwd("..")
  setwd("..")
  setwd("..")

}

vol_anual("tora", "geral")
vol_anual("tora", "grupo1")
vol_anual("tora", "grupo2")
vol_anual("tora", "grupo3")

vol_anual("acabado", "geral")
vol_anual("acabado", "grupo1")
vol_anual("acabado", "grupo2")
vol_anual("acabado", "grupo3")

    
    
    

   
    
    