###### Geral Volume Mensal  ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa função tem como argumentos: produto e grupo. 
# produto = (tora, acabado)
# grupo = (geral, grupo1, grupo2, grupo3)

# Pacotes usados
    library(data.table)
    library(dplyr)
    library(tidyr)
    library(ggplot2)
    library(scales)
    library(easyGgplot2)
    library(gridExtra)
    library(grid)
    library(RColorBrewer)
    #library(scater) # para a funcao multiplot que agrega mais de um grafico em uma figura

#  Lê sisdof_tora
sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                     colClasses = c("character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_tora$V1 <- NULL

# Lê sisdof_produto
sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                        colClasses = c("character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_produto$V1 <- NULL
    
vol_mensal <- function (produto, grupo) {
    
    # produto = (tora, acabado)
    
    # grupo = (geral, grupo1, grupo2, grupo3)
    # geral = Todas as espécies
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Ameaçadas de extinção)
    # grupo3 = cites
    
    # Função para passar apenas a primeira letra de uma palavra para maiúscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Títulos do gráfico
    titulo <- capFirst(grupo)
        
    if (produto == "tora") {
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.1.Toras", 
                                     "1.1.3.Volume.Mensal")),
               dir.create(file.path("Figuras", 
                                    "1.1.Toras", 
                                    "1.1.3.Volume.Mensal"),
                          recursive = TRUE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.1.Toras", 
                        "1.1.3.Volume.Mensal"))
        
        # sisdof =  sisdof_tora
        sisdof <- sisdof_tora
        
        # Nome no eixo y dos gráficos a serem gerados
        nome <- "toras e toretes movimentados"
        
    } else if (produto == "acabado") {
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.2.Produto.Acabado", 
                                     "1.2.3.Volume.Mensal")),
               dir.create(file.path("Figuras", 
                                    "1.2.Produto.Acabado", 
                                    "1.2.3.Volume.Mensal"),
                          recursive = TRUE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.2.Produto.Acabado", 
                        "1.2.3.Volume.Mensal"))
        
        # sisdof = sisdof_produto
        sisdof <- sisdof_produto
        
        # Nome no eixo y dos gráficos a serem gerados
        nome <- "produtos madeireiros acabados movimentados"
        
    } 
    
    if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espécies contidas no grupo 1
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espécies contidas no grupo 2
        
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof[sisdof$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espécies contidas no grupo 3
        
    }
    
    y <- sisdof
    
    y <- y[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
           by = .(Especie, 
                  Emissao,
                  Portaria.443,
                  Cites)]
    
    # Renomeia as colunas V1 e V2  
    y <- dplyr::rename(y,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
    # Cria a coluna Ano
    y$Ano <- as.factor(sub("^[0-9]+-", "", y$Emissao))
    
    y$Categoria <- factor("Todas as espécies")
    
    # Ordena de forma crescente em relação a data
    y <- y[order(y$Emissao),]
    
    # Elimina o ano da coluna emissao, mantendo apenas o ano
    y$Mes <- sub("-20[0-9]{2}$", "", y$Emissao)
    
    # Converte a classe da coluna "Emissão" para Data. Para que o R converta um caracer em data, ele precisa ter o dia, mes e ano. Dessa forma utilizei a função paste0 para inseri um 01 no início para todos os valores de data vindos do DOF.
    y$Mes <- as.Date(paste0("01","-", y$Mes, "-2000"),"%d-%m-%Y")
    
    # Converte a classe da coluna "Emissão" para POSIXct
    y$Mes <- as.POSIXct(y$Mes)
    
    nomes.443 <- unique(y$Especie[!is.na(y$Portaria.443)])
    
    nomes.cites <- unique(y$Especie[!is.na(y$Cites)])
    
    # Agrega
    geral <- y[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                   by = .(Emissao,
                          Ano,
                          Mes,
                          Categoria)]
    
    # Renomeia as colunas V1 e V2  
    geral <- dplyr::rename(geral,
                           "Volume.Total" = "V1",
                           "Preco.Total" = "V2")
    
    ## Cria o subset Ameaçadas de extinção
    agregado443 <- y[!is.na(y$Portaria.443)]
    
    # Agrega
    agregado443 <- agregado443[, .(sum(Volume.Total), 
                                   sum(Preco.Total, na.rm = TRUE)),
                               by = .(Emissao,
                                      Ano,
                                      Mes,
                                      Categoria)]
    # Renomeia as colunas V1 e V2  
    agregado443 <- dplyr::rename(agregado443,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    # Cria a coluna Categoria
    agregado443$Categoria <- "Ameaçadas de extinção"
    
    ## Cria o subset Cites
    agregadocites <- y[!is.na(y$Cites)]
    
    # Agrega
    agregadocites <- agregadocites[, .(sum(Volume.Total), 
                                       sum(Preco.Total, na.rm = TRUE)),
                                   by = .(Emissao,
                                          Ano,
                                          Mes,
                                          Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregadocites <- dplyr::rename(agregadocites,
                                   "Volume.Total" = "V1",
                                   "Preco.Total" = "V2")
    
    # Cria a coluna Categoria
    agregadocites$Categoria <- "Espécies CITES"
    
    
    if (grupo == "geral") {
      
    lista_especies <- "Geral"
    
    especie <- rbind(geral, agregado443, agregadocites)
    
    especie$Categoria <- factor(especie$Categoria, 
                                levels = c("Todas as espécies",
                                           "Ameaçadas de extinção",
                                           "Espécies CITES"))
    
    # Ordena de forma crescente em relação a data
    especie <- especie[order(especie$Emissao),]
    
    # subset 1 = 2012 a 2014
    especie1 <- especie[especie$Ano == "2012" |
                            especie$Ano == "2013" |
                            especie$Ano == "2014"]
    
    # subset 2 = 2015 a 2017
    especie2 <- especie[especie$Ano == "2015" |
                            especie$Ano == "2016" |
                            especie$Ano == "2017"]
    
    # Faz o gráfico do subset 1
    plot1 <- ggplot(especie1, aes(x = Mes, 
                                 y = Volume.Total/1000,
                        colour = factor(Ano))) +            # colore conforme o Ano.
        facet_wrap(Categoria ~ Ano,                         # faz em uma única figura, dois ou mais gráficos de acordo com as diferentes combinaoes de Categoria e Ano. Ex: Geral, Ameaçadas de extinção e Cite.
                   ncol = 3,
                   scales = "free_y")+                      # usa escala livre para y. Dessa forma e possivel observar numa mesma figura graficos com escalas diferentes.
        geom_point() +                                      # adiciona os pontos no gráfico
        #geom_line() +                                      # adiciona uma linha reta ligando cada um dos pontos do gráfico
        geom_smooth(method = "loess")+                      # adiciona uma reta curva conforme os pontos do gráficos.
        scale_x_datetime(date_labels = "%b") +              # Transforma o eixo x em mes.
        scale_y_continuous(labels = 
                               function(x) 
                                   format(x,
                                          big.mark = ".",
                                          decimal.mark = ",",
                                          scientific = FALSE))+  # Coloca ponto como separador de milhar e virgula como separador de decimal no eixo y do grafico
        theme(plot.title = element_blank(),                 # elimina o titulo do grafico
              axis.title.x = element_blank(),               # elimina o titulo do eixo x
              axis.text.x = element_blank(),                # elimina os valores de x 
              axis.title.y = element_blank(),               # elimina o titulo do eixo y
              legend.position = "none",                     # elimina a legenda
              strip.text = element_text(size = 20),         # tamanho do titulo de cada um dos graficos do facet_wrap
              axis.text.y = element_text(size = 22))+       # tamaho dos valores de y
        theme(panel.grid.minor = element_blank())+                      # elimina os grids menores
        scale_colour_manual(values = brewer.pal(n = 8,
                                                name = "Dark2")[1:3])   # colore 2012, 2013 e 2014 com as três primeiras cores do tema Dark2 do pacore RColorBreweer                    # usa a paleta de cores "Dark2" do pacote RColorBrewer
       
    # Faz o gráfico do subset 2
    plot2 <- ggplot(especie2, aes(x = Mes, 
                                  y = Volume.Total/1000,
                                  colour = factor(Ano))) +            # colore conforme o Ano.
        facet_wrap(Categoria ~ Ano,                         # faz em uma única figura, dois ou mais gráficos de acordo com as diferentes combinaoes de Categoria e Ano. Ex: Geral, Ameaçadas de extinção e Cite.
                   ncol = 3,
                   scales = "free_y")+                      # usa escala livre para y. Dessa forma e possivel observar numa mesma figura graficos com escalas diferentes.
        geom_point() +                                      # adiciona os pontos no gráfico
        #geom_line() +                                      # adiciona uma linha reta ligando cada um dos pontos do gráfico
        geom_smooth(method = "loess")+                      # adiciona uma reta curva conforme os pontos do gráficos.
        ggtitle("\n2015 a 2017")+
        scale_x_datetime(date_labels = "%b") +              # Transforma o eixo x em mes.
        scale_y_continuous(labels = 
                               function(x) 
                                   format(x,
                                          big.mark = ".",
                                          decimal.mark = ",",
                                          scientific = FALSE))+  # Coloca ponto como separador de milhar e virgula como separador de decimal no eixo y do grafico
        theme(plot.title = element_text(size = 30,
                                        hjust = 0.5,
                                        face = "bold"),     # tamnho do titulo do grafico
              axis.title.x = element_blank(),               # elimina o titulo do eixo x
              axis.title.y = element_blank(),               # elimina o titulo do eixo y
              legend.position = "none",                     # elimina a legenda
              strip.text = element_text(size = 20),         # tamanho do titulo de cada um dos graficos do facet_wrap
              axis.text.x = element_text(angle = 75,        # muda o angulo dos valores de x (meses) de forma que fiquem inclinados
                                         vjust = 1,         # alinhamento vertical dos valores de x
                                         hjust=1,           # alinhamento horizontal dos valores x
                                         size = 22),        # tamanho dos valores de x 
              axis.text.y = element_text(size = 22))+       # tamaho dos valores de y
    theme(panel.grid.minor = element_blank())+                            # elimina os grids menores
    scale_colour_manual(values = brewer.pal(n = 8,name = "Dark2")[4:6])   # colore 2015, 2016 e 2017 com as cores 4 a 6 do tema Dark2 do pacore RColorBreweer 
    
    # Abre para gravacao em PDF
    pdf(paste0(lista_especies, 
               "_Volume Anual.pdf"), 
        width = 14, 
        height = 20)
        
    # Multiplos graficos na mesma pagina
    grid.arrange(
        plot1,
        plot2,
        nrow = 2,
        top = textGrob(paste0("Volume Mensal - ",
                              sub(" movimentados", "", capFirst(nome)),
                              " - ",
                              "2012 a 2014"),
                       gp = gpar(fontface = 2, fontsize = 30)),
        bottom = textGrob("Mês",
                          gp = gpar(fontface = 2, fontsize = 30)),
                         # hjust = 10,
                         #x = 1),
        left = textGrob("Volume movimentado (x 1000 m^3)",
                       gp = gpar(fontface = 2, fontsize = 30),
                       rot = 90))
    
   
    # Fecha o PDF
    dev.off()
    
    ## Faz os gráficos para cada uma das espécies da lista dos grupos 1, 2 ou 3.
      
    } else if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
            
      for (i in 1:length(lista_especies)) {
        especie <- y[y$Especie == lista_especies[i]]
        
        # Poe o nome da especie na coluna Categoria
        especie$Categoria <- lista_especies[i]
        
       # Agrega
        especie <- especie[, .(sum(Volume.Total), 
                                           sum(Preco.Total, na.rm = TRUE)),
                                       by = .(Emissao,
                                              Ano,
                                              Mes,
                                              Categoria)]
        
        # Renomeia as colunas V1 e V2  
        especie <- dplyr::rename(especie,
                                       "Volume.Total" = "V1",
                                       "Preco.Total" = "V2")
        
        
        # Fusiona especie e geral
        especie <- rbind(especie, geral)
        
        if (grupo == "grupo1") {
          
          especie$Categoria <- factor(especie$Categoria, 
                                      levels = c(lista_especies[i],
                                                 "Todas as espécies"))
          
          if (lista_especies[i] %in% nomes.443) {
            
            especie <- rbind(especie, agregado443)
            
            especie$Categoria <- factor(especie$Categoria, 
                                        levels = c(lista_especies[i],
                                                   "Todas as espécies",
                                                   "Ameaçadas de extinção"))
            
          } 
          
          if (lista_especies[i] %in% nomes.cites) {
            
            specie <- rbind(especie, agregadocites)
            
            especie$Categoria <- factor(especie$Categoria, 
                                        levels = c(lista_especies[i],
                                                   "Todas as espécies",
                                                   "Espécies CITES"))
            
            if (lista_especies[i] %in% nomes.443) {
              
              especie$Categoria <- factor(especie$Categoria, 
                                          levels = c(lista_especies[i],
                                                     "Todas as espécies",
                                                     "Ameaçadas de extinção",
                                                     "Espécies CITES"))
              
            } 
            
            
          }
          
        } else if (grupo == "grupo2") {
          
          especie <- rbind(especie, agregado443)
          
          especie$Categoria <- factor(especie$Categoria, 
                                      levels = c(lista_especies[i],
                                                 "Todas as espécies",
                                                 "Ameaçadas de extinção"))
          
          if (lista_especies[i] %in% nomes.cites) {
            
            especie <- rbind(especie, agregadocites)
            
            especie$Categoria <- factor(especie$Categoria, 
                                        levels = c(lista_especies[i],
                                                   "Todas as espécies",
                                                   "Ameaçadas de extinção",
                                                   "Espécies CITES"))
          }
          
        } else if (grupo == "grupo3") {
          
          especie <- rbind(especie, agregadocites)
          
          especie$Categoria <- factor(especie$Categoria, 
                                      levels = c(lista_especies[i],
                                                 "Todas as espécies",
                                                 "Espécies CITES"))
          
          if (lista_especies[i] %in% nomes.443) {
            
            especie <- rbind(especie, agregado443)
            
            especie$Categoria <- factor(especie$Categoria, 
                                        levels = c(lista_especies[i],
                                                   "Todas as espécies",
                                                   "Espécies CITES",
                                                   "Ameaçadas de extinção"))
            
          }
          
        }
        
        
        # Ordena de forma crescente em relação a data
        especie <- especie[order(especie$Emissao),]
        
        # subset 1 = 2012 a 2014
        especie1 <- especie[especie$Ano == "2012" |
                                especie$Ano == "2013" |
                                especie$Ano == "2014"]
        
        # subset 2 = 2015 a 2017
        especie2 <- especie[especie$Ano == "2015" |
                                especie$Ano == "2016" |
                                especie$Ano == "2017"]
                
        # Gera o grafico do subset 1
        plot1 <- ggplot(especie1, aes(x = Mes, 
                                     y = Volume.Total/1000,
                                     colour = factor(Ano))) +
            facet_wrap(Categoria ~ Ano,                         # faz em uma única figura, dois ou mais gráficos de acordo com as diferentes combinaoes de Categoria e Ano. Ex: Geral, Ameaçadas de extinção e Cite.
                       ncol = 3,
                       scales = "free_y")+                      # usa escala livre para y. Dessa forma e possivel observar numa mesma figura graficos com escalas diferentes.
            geom_point() +                                      # adiciona os pontos no gráfico
            #geom_line() +                                      # adiciona uma linha reta ligando cada um dos pontos do gráfico
            geom_smooth(method = "loess")+                      # adiciona uma reta curva conforme os pontos do gráficos.
            scale_x_datetime(date_labels = "%b") +              # Transforma o eixo x em mes.
            scale_y_continuous(labels = 
                                   function(x) 
                                       format(x,
                                              big.mark = ".",
                                              decimal.mark = ",",
                                              scientific = FALSE))+  # Coloca ponto como separador de milhar e virgula como separador de decimal no eixo y do grafico
            theme(plot.title = element_blank(),                 # elimina o titulo do grafico
                  axis.title.x = element_blank(),               # elimina o titulo do eixo x
                  axis.text.x = element_blank(),                # elimina os valores de x 
                  axis.title.y = element_blank(),               # elimina o titulo do eixo y
                  legend.position = "none",                     # elimina a legenda
                  strip.text = element_text(size = 20),         # tamanho do titulo de cada um dos graficos do facet_wrap
                  axis.text.y = element_text(size = 22))+       # tamaho dos valores de y
            theme(panel.grid.minor = element_blank())+                            # elimina os grids menores
            scale_colour_manual(values = brewer.pal(n = 8,name = "Dark2")[1:3])   # colore 2012, 2013 e 2014 com as três primeiras cores do tema Dark2 do pacore RColorBreweer 
        
        # Gera o grafico do subset 2
        plot2 <- ggplot(especie2, aes(x = Mes, 
                                      y = Volume.Total/1000,
                                      colour = factor(Ano))) +
            facet_wrap(Categoria ~ Ano,                         # faz em uma única figura, dois ou mais gráficos de acordo com as diferentes combinaoes de Categoria e Ano. Ex: Geral, Ameaçadas de extinção e Cite.
                       ncol = 3,
                       scales = "free_y")+                      # usa escala livre para y. Dessa forma e possivel observar numa mesma figura graficos com escalas diferentes.
            geom_point() +                                      # adiciona os pontos no gráfico
            #geom_line() +                                      # adiciona uma linha reta ligando cada um dos pontos do gráfico
            geom_smooth(method = "loess")+                      # adiciona uma reta curva conforme os pontos do gráficos.
            ggtitle("\n2015 a 2017")+
            scale_x_datetime(date_labels = "%b") +              # Transforma o eixo x em mes.
            scale_y_continuous(labels = 
                                   function(x) 
                                       format(x,
                                              big.mark = ".",
                                              decimal.mark = ",",
                                              scientific = FALSE))+  # Coloca ponto como separador de milhar e virgula como separador de decimal no eixo y do grafico
            theme(plot.title = element_text(size = 30,
                                            hjust = 0.5,
                                            face = "bold"),     # tamnho do titulo do grafico
                  axis.title.x = element_blank(),               # elimina o titulo do eixo x
                  axis.title.y = element_blank(),               # elimina o titulo do eixo y
                  legend.position = "none",                     # elimina a legenda
                  strip.text = element_text(size = 20),         # tamanho do titulo de cada um dos graficos do facet_wrap
                  axis.text.x = element_text(angle = 75,        # muda o angulo dos valores de x (meses) de forma que fiquem inclinados
                                             vjust = 1,         # alinhamento vertical dos valores de x
                                             hjust=1,           # alinhamento horizontal dos valores x
                                             size = 22),        # tamanho dos valores de x 
                  axis.text.y = element_text(size = 22))+       # tamaho dos valores de y
            theme(panel.grid.minor = element_blank())+                            # elimina os grids menores
            scale_colour_manual(values = brewer.pal(n = 8,name = "Dark2")[4:6])   # colore 2015, 2016 e 2017 com as cores 4 a 6 do tema Dark2 do pacore RColorBreweer 
        
        # Abre para gravacao em PDF
        pdf(paste(titulo, lista_especies[i],
                  "Toras_Volume_Mensal.pdf", 
                  sep = "_"), 
            width = 14, 
            height = 20)
        
        # Multiplos graficos na mesma pagina
        grid.arrange(
            plot1,
            plot2,
            nrow = 2,
            top = textGrob(paste0("Volume Mensal - ",
                                  sub(" movimentados", "", capFirst(nome)),
                                  " - ",
                                  "2012 a 2014"),
                           gp = gpar(fontface = 2, fontsize = 30)),
            bottom = textGrob("Mês",
                              gp = gpar(fontface = 2, fontsize = 30)),
            # hjust = 10,
            #x = 1),
            left = textGrob("Volume movimentado (x 1000 m^3)",
                            gp = gpar(fontface = 2, fontsize = 30),
                            rot = 90))
        
        # Fecha o PDF
        dev.off()
        
      }
        
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
}


vol_mensal("tora", "geral")
vol_mensal("tora", "grupo1")
vol_mensal("tora", "grupo2")
vol_mensal("tora", "grupo3")

vol_mensal("acabado", "geral")
vol_mensal("acabado", "grupo1")
vol_mensal("acabado", "grupo2")
vol_mensal("acabado", "grupo3")
    
    