## R verso 3.3.0 de 64 bits
## dados0.Rdata:arquivo com os dados dos municpios ordenados que faro parte do sorteio
## amostra.Rdata:arquivo com a quantidade de municpios sorteados por UF
## Os arquivos dados0.Rdata e amostra.Rdata devem ser colocados no mesmo diretrio
## Os municpios selecionados no sorteio sero colocados no mesmo diretrio que os arquivos dados0.Rdata e amostra.Rdata

atalho<-choose.dir(caption = "Selecione o diretrio onde esto os arquivos dados0.Rdata e amostra.Rdata")

load(paste0(atalho,"\\dados0.Rdata"))
load(paste0(atalho,"\\amostra.Rdata"))


N<-nrow(dados0)
semente<-79027068                          ## semente obtida do concurso 05080 da loteria federal do dia 01/06/2016
set.seed(semente, kind="Mersenne-Twister") ## funo para fixao de valores iniciais apartir da semente
a0<-runif(N)                               ## gerar um vetor de valores com distribuio uniforme (0,1) algoritmo "Marsenne-Twister"
a<-cbind(a0,dados0)                        ## atribuir os valores aos municpios
a2<-a[order(a[,1]),]                       ## ordenar segundo os valores aleatrios gerados

###Loop para retirar os menores valores segundo o tamanho da amostra dentro de cada estado

resu<-NULL                                
for (j in 1:nrow(amostra)) {
lito<-a2[a2$UF %in% amostra[j,"UF"],]
lito2<-lito[1:amostra[j,"n_mun"],]
resu<-rbind(resu,lito2)
lito<-NULL
lito2<-NULL
}

## gravar o resultado na pasta final
write.csv2(resu,file=paste0(atalho,"\\resultado_sem",semente,".csv")) 



