% -----------------------------------------------------------------------------
%            Centro de Desenvolvimento da Tecnologia Nuclear
%      Programa de Pós Graduação em Ciências e Tecnologia das Radiações, Minerais e Materiais
%             
%   Modelo de trabalho acadêmico em conformidade com as normas da ABNT
%   (Tese de Doutorado, Dissertação de Mestrado ou Projeto de Qualificação)
%
%    
%    Modelo de Referência CNEN/CDTN
%          
% -----------------------------------------------------------------------------

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{CDTN}[2023/03/06 v1]

% Repassa os parâmetros ao abntex2
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{abntex2}}

\PassOptionsToClass{%
% Opções da classe memoir
    12pt,                     % Tamanho da fonte
    openright,                % Capítulos começam sempre em páginas ímpares (insere página vazia caso necessário)
    a4paper,                  % Tamanho do papel
    sumario=tradicional,      % Seleciona o sumário tradicional
% Opções do pacote babel
    brazil, 
        % Idioma do documento
}{abntex2}

\ProcessOptions\relax
\LoadClass{abntex2}

\RequirePackage[brazilian, hyperpageref]{backref}       % Produzir índice nas referências
\RequirePackage{makeidx}                                % Produzir índice remissivo de palavras
\RequirePackage{chngcntr}

% -----------------------------------------------------------------------------
% Configurações gerais
% -----------------------------------------------------------------------------

% Retira o espaço extra desnecessário nas frases
\frenchspacing

% Configurações do pacote backref usado sem a opção hyperpageref de backref
\renewcommand{\backrefpagesname}{Citado na(s) p\'agina(s):~}

% Texto padrão antes do número das páginas
\renewcommand{\backref}{}

% Define as listas de item compactas (sem espaçamento entre os itens)
\setlist{noitemsep, topsep=0pt, parsep=0pt, partopsep=0pt}

% Define os textos da citação
\renewcommand*{\backrefalt}[4]{%
    %\ifcase #1
        %Nenhuma cita\c{c}\~ao no texto.
    %\or
       % Citado na p\'agina #2.
    %\else
       % Citado #1 vezes nas p\'aginas #2.
   % \fi
}

% Define a numeração das equações de forma sequencial
\counterwithout{equation}{chapter}

% -----------------------------------------------------------------------------
% Cabecalho padrao e rodapé padrão para páginas do texto (subustitui abntheadings)
% -----------------------------------------------------------------------------

\makepagestyle{abntheadings_CDTN}
% Configuração com cabeçalho:
\makeevenhead{abntheadings_CDTN}{}{}{\ABNTEXfontereduzida\thepage}
\makeoddhead{abntheadings_CDTN}{}{}{\ABNTEXfontereduzida\thepage}
%\makeheadrule{abntheadings_CDTN}{\textwidth}{\normalrulethickness}

%Configuração com rodapé:
%\makefootrule{abntheadings_CDTN}{\textwidth}{\normalrulethickness}{\footruleskip}
%\makeevenfoot{abntheadings_CDTN}{\ABNTEXfontereduzida\thepage}{}{}
%\makeoddfoot{abntheadings_CDTN}{}{}{\ABNTEXfontereduzida\thepage}

% Cabecalho do inicio do capitulo
\makepagestyle{abntchapfirst_CDTN}
%\makefootrule{abntchapfirst_CDTN}{\textwidth}{\normalrulethickness}{\footruleskip}
\makeevenhead{abntchapfirst_CDTN}{}{}{\ABNTEXfontereduzida\thepage}
\makeoddhead{abntchapfirst_CDTN}{}{}{\ABNTEXfontereduzida\thepage}

% -----------------------------------------------------------------------------
% Comandos de dados
% -----------------------------------------------------------------------------
% Comandos de dados - Programa
\providecommand{\imprimirinstituto}{}
\newcommand{\instituto}[1]{\renewcommand{\imprimirinstituto}{#1}}

% Comandos de dados - Programa
\providecommand{\imprimirprograma}{}
\newcommand{\programa}[1]{\renewcommand{\imprimirprograma}{#1}}

% Comandos de dados - Subtítulo do trabalho
\providecommand{\imprimirsubtitulo}{}
\newcommand{\subtitulo}[1]{\renewcommand{\imprimirsubtitulo}{#1}}

% Comandos de dados - Instituição do orientador
\providecommand{\imprimirinstOrientador}{}
%\newcommand{\instOrientador}[1]{\renewcommand{\imprimirinstOrientador}{#1}}

% Comandos de dados - Instituição do coorientador
\providecommand{\imprimirinstCoorientador}{}
%\newcommand{\instCoorientador}[1]{\renewcommand{\imprimirinstCoorientador}{#1}}

% Comandos de dados - Tipo de trabalho acadêmico (tese, dissertação ou projeto de qualificação)
\providecommand{\imprimirprojeto}{}
\newcommand{\projeto}[1]{\renewcommand{\imprimirprojeto}{#1}}

% Comandos de dados - Título acadêmico a ser alcançado (Doutor ou Mestre)
\providecommand{\imprimirtituloAcademico}{}
\newcommand{\tituloAcademico}[1]{\renewcommand{\imprimirtituloAcademico}{#1}}

% Comandos de dados - Área de concentração do Programa
%\newcommand{\imprimirareaconcentracaoRotulo}{\'Area de concentra\c{c}\~ao: }
\providecommand{\imprimirareaconcentracao}{}
\newcommand{\areaconcentracao}[1]{\renewcommand{\imprimirareaconcentracao}{#1}}

% Comandos de dados - Linha de pesquisa do Programa
\newcommand{\imprimirlinhapesquisaRotulo}{Linha de pesquisa: }
\providecommand{\imprimirlinhapesquisa}{}
\newcommand{\linhapesquisa}[1]{\renewcommand{\imprimirlinhapesquisa}{#1}}

% Comandos de dados - Texto da folha de aprovação
\providecommand{\imprimirtextopadraofolhadeaprovacao}{}
\newcommand{\textopadraofolhadeaprovacao}[1]{\renewcommand{\imprimirtextopadraofolhadeaprovacao}{#1}}

% Comandos de dados - Logomarca da instituição
\providecommand{\imprimirlogoinstituicao}{}
\newcommand{\logoinstituicao}[2]{\renewcommand{\imprimirlogoinstituicao}{\includegraphics[width={#1}\textwidth]{#2}}}

% -----------------------------------------------------------------------------
% Estilo de elementos
% -----------------------------------------------------------------------------

% Elementos pré-textuais
\renewcommand{\pretextual}{%
    \pagestyle{abntheadings_CDTN}
    \aliaspagestyle{chapter}{abntchapfirst_CDTN}
  \aliaspagestyle{chapter}{plain}
        \aliaspagestyle{cleared}{empty}
    \aliaspagestyle{part}{empty}
    \pagenumbering{gobble} 
    
    
}

% Configura layout para elementos textuais
\renewcommand{\textual}{%
    \pagenumbering{arabic} % Numeração das páginas em algarismos arábicos, inciando em 1
    \setcounter{page}{14}
    \mathindent 0.4 cm
      \pagestyle{abntheadings_CDTN}
    \aliaspagestyle{chapter}{abntchapfirst_CDTN}
    \nouppercaseheads
    \bookmarksetup{startatroot}
}


% Configura layout para elementos pós-textuais
\renewcommand{\postextual}{%
    \chapterstyle{abntex2}
      \pagestyle{abntheadings_CDTN}
    \aliaspagestyle{chapter}{abntchapfirst_CDTN}
    \mathindent 0.4 cm
    \phantompart
}
% -----------------------------------------------------------------------------
% Objetos flutuantes
% -----------------------------------------------------------------------------

% Comando que trata a fonte nos objetos flutuantes
\renewcommand{\fonte}[1]{%
    \begin{onehalfspacing}\par\end{onehalfspacingg}
    \centering\small{Fonte: #1}
}

% Comando que trata as notas nos objetos flutuantes
\renewcommand{\nota}[1]{%
    \begin{onehalfspacing}\par\end{onehalfspacing}
    \begin{tabular}{l p{.85\textwidth}}%
        Nota: & #1
    \end{tabular}
}

% -----------------------------------------------------------------------------
% Parágrafos
% -----------------------------------------------------------------------------

% Tamanho do recuo do parágrafo
\setlength{\parindent}{1.25cm}
%\setlength{\parindent}{0cm}
%\setlength{\mathindent}{}
% Espaçamento entre um parágrafo e outro
\setlength{\parskip}{0.3cm}

% -----------------------------------------------------------------------------
% Fontes
% -----------------------------------------------------------------------------

% Redefinição de fontes
\renewcommand{\ABNTEXchapterfont}{\normalfont\bfseries}
\renewcommand{\ABNTEXchapterfontsize}{\normalsize}

\renewcommand{\ABNTEXpartfont}{\normalfont}
\renewcommand{\ABNTEXpartfontsize}{\ABNTEXchapterfontsize}

\renewcommand{\ABNTEXsectionfont}{\normalfont\bfseries}
\renewcommand{\ABNTEXsectionfontsize}{\normalsize}

\renewcommand{\ABNTEXsubsectionfont}{\normalfont}
\renewcommand{\ABNTEXsubsectionfontsize}{\normalsize}

\renewcommand{\ABNTEXsubsubsectionfont}{\normalfont}
\renewcommand{\ABNTEXsubsubsectionfontsize}{\normalsize}

\renewcommand{\ABNTEXsubsubsubsectionfont}{\normalfont}
\renewcommand{\ABNTEXsubsubsubsectionfontsize}{\normalsize}

% -----------------------------------------------------------------------------
% Sumário
% -----------------------------------------------------------------------------

% Travessão no sumário para apêndices e anexos
\renewcommand{\cftchapteraftersnum}{\hfill\textendash\hfill}

% Insere espaço entre os itens do sumário de diferentes capítulos
\setlength{\cftbeforechapterskip}{1.0em \@plus\p@}

% -----------------------------------------------------------------------------
% Listas
% -----------------------------------------------------------------------------
% Define os títulos das listas
\addto\captionsbrazil{%
% Ajusta nomes padrões do babel
    \renewcommand{\listadesiglasname}{Lista de Abreviaturas e Siglas}
       \renewcommand{\listadesimbolosname}{Lista de S\'{i}mbolos}
    \renewcommand{\listfigurename}{Lista de Figuras}
    \renewcommand{\listtablename}{Lista de Tabelas}
    \renewcommand{\indexname}{\'{I}ndice Remissivo}
% Ajusta nomes usados com a macro \autoref
    \renewcommand{\pageautorefname}{p\'agina}
    \renewcommand{\sectionautorefname}{Se\c{c}\~ao}
    \renewcommand{\subsectionautorefname}{Subse\c{c}\~ao}
    \renewcommand{\subsubsectionautorefname}{Subsubse\c{c}\~ao}
    \renewcommand{\paragraphautorefname}{Subse\c{c}\~ao}
}

% Cria a lista de quadros
\newcommand{\listofquadrosname}{Lista de Quadros}
\newcommand{\quadroname}{Quadro}
\newfloat[chapter]{quadro}{loq}{\quadroname}
\newlistof{listofquadros}{loq}{\listofquadrosname}
\newlistentry{quadro}{loq}{0}
\counterwithout{quadro}{chapter}
\renewcommand{\cftquadroname}{\quadroname\space}
\renewcommand*{\cftquadroaftersnum}{\hfill--\hfill}

% -----------------------------------------------------------------------------
% Capa
% -----------------------------------------------------------------------------
\makeatletter
\renewcommand{\imprimircapa}{%
    \begin{capa}
        \begin{center}
            \imprimirlogoinstituicao{} \\
             \imprimirinstituto{} \\
            \normalfont\scshape{\imprimirinstituicao} \\
            \normalfont\scshape{\imprimirprograma} \\
        \end{center}

        \vspace*{2.9cm}

        \begin{center}
            \large\imprimirprojeto \\
        \end{center}
        
        \vspace*{-0.75cm}

        \begin{center}    
            \parbox{12cm}{\centering
            \ABNTEXchapterfont\large\scshape\imprimirtitulo
            \abntex@ifnotempty{\imprimirsubtitulo}{%
                {\ABNTEXchapterfont\large\scshape: }{\ABNTEXchapterfont\large\scshape\imprimirsubtitulo}
            }
            }
        \end{center}

        \vspace*{1pt}

        \begin{center}
            \large\normalfont\scshape\textbf\imprimirautor
        \end{center}

        \vspace*{\fill}


        \begin{center}
            \normalfont\scshape{\imprimirlocal}\\
            \normalfont\scshape{\imprimirdata}
        \end{center}

    \end{capa}
}
\makeatother

% -----------------------------------------------------------------------------
% Folha de rosto
% -----------------------------------------------------------------------------
\makeatletter
\renewcommand{\folhaderostocontent}{%

    \begin{center}
        {\large\normalfont\scshape\textbf\imprimirautor}
    \end{center}

    \vspace*{5cm}

    \begin{center}
        \ABNTEXchapterfont\large\scshape\imprimirtitulo
        \abntex@ifnotempty{\imprimirsubtitulo}{%
            {\ABNTEXchapterfont\large\scshape: }{\ABNTEXchapterfont\large\scshape\imprimirsubtitulo}
        }
    \end{center}

    \vspace*{4cm}

    \abntex@ifnotempty{\imprimirpreambulo}
    {%
       % \onehalfspacing
        \begin{tabular}{p{.347\textwidth}p{.11\textwidth}p{.4\textwidth}}
            & \multicolumn{2}{p{.53\textwidth}}{\small\hyphenpenalty=10000{\imprimirpreambulo}} \\ & & \\
            \abntex@ifnotempty{\imprimirareaconcentracao}{%
                & \multicolumn{2}{p{.53\textwidth}}{\small\hyphenpenalty=10000{\imprimirareaconcentracaoRotulo\imprimirareaconcentracao}} \\ & & \\
            }
                        \abntex@ifnotempty{\imprimirlinhapesquisa}{%
                & \multicolumn{2}{p{.53\textwidth}}{\small\hyphenpenalty=10000{\imprimirlinhapesquisaRotulo\imprimirlinhapesquisa}} \\ & & \\
            }
            \abntex@ifnotempty{\imprimirorientador}{%
                & \small\imprimirorientadorRotulo & \imprimirorientador \\
               % & & \small\imprimirinstOrientador \\ & & \\
            }
            \abntex@ifnotempty{\imprimircoorientador}{%
                & \small\imprimircoorientadorRotulo & \imprimircoorientador \\
               & & \small\imprimirinstCoorientador
            }
        \end{tabular}
    }

    \vspace*{\fill}

    \begin{center}
        %\normalfont\scshape{\imprimirinstituicao}\\
        %\normalfont\scshape{\imprimirprograma}\\
        \normalfont\scshape{\imprimirlocal}\\
        \normalfont\scshape{\imprimirdata}
    \end{center}
    \PRIVATEclearpageifneeded
}
\makeatother


% -----------------------------------------------------------------------------
% Folha de aprovação
% -----------------------------------------------------------------------------
\makeatletter
\newcommand{\imprimirfolhadeaprovacao}{%
    \begin{folhadeaprovacao}
        \vspace*{\fill}

        \begin{tabular}{p{.45\textwidth}p{.45\textwidth}}
            & \imprimirtextopadraofolhadeaprovacao \\
        \end{tabular}

        \vspace*{\fill}
    \end{folhadeaprovacao}
    \PRIVATEclearpageifneeded
}
\makeatother

% -----------------------------------------------------------------------------
% Dedicatória
% -----------------------------------------------------------------------------
\renewenvironment{dedicatoria}[1][]{%
    \ifthenelse{\equal{#1}{}}{%
        \PRIVATEbookmarkthis{\dedicatorianame}
    }{\pretextualchapter{#1}}

    \vspace*{\fill}

    \begin{flushright}
        \begin{minipage}{.5\textwidth}
            \begin{onehalfspacing}
                \setlength\parindent{0pt}
                \setlength\parskip{12pt}
}{%
            \end{onehalfspacing}
        \end{minipage}
    \end{flushright}
    \PRIVATEclearpageifneeded
}


% -----------------------------------------------------------------------------
% Epígrafe
% -----------------------------------------------------------------------------
\renewenvironment{epigrafe}[1][]{%
    \ifthenelse{\equal{#1}{}}{%
        \PRIVATEbookmarkthis{\epigraphname}
    }{\pretextualchapter{#1}}

    \vspace*{\fill}

    \begin{flushright}
        \begin{minipage}{.5\textwidth}
           % \begin{onehalfspacing}
                \setlength\parindent{0pt}
                \setlength\parskip{12pt}
}{%
            %\end{onehalfspacing}
        \end{minipage}
    \end{flushright}
    \PRIVATEclearpageifneeded
}
