/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sib.cliente.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegQuery {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String PERSONAL_FOLDER_CMD = "reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v Personal";
    private static final String CPU_SPEED_CMD = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ~MHz";
    private static final String CPU_NAME_CMD = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString";
    private static final String PATH_PTA_CMD = "reg query \"HKLM\\SOFTWARE\\ANS\\PTA\"";

    public static String getCurrentUserPersonalFolderPath() {
        try {
            Process process = Runtime.getRuntime().exec(PERSONAL_FOLDER_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCPUSpeed() {
        try {
            Process process = Runtime.getRuntime().exec(CPU_SPEED_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return null;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.toString(Integer.parseInt(temp.substring("0x".length()), 16) + 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCPUName() {
        try {
            Process process = Runtime.getRuntime().exec(CPU_NAME_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPathPTAreg() {
        try {
            Process process = Runtime.getRuntime().exec(PATH_PTA_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPathPTA() throws IOException {
        String path = RegQuery.getPathPTAreg();
        if (path != null) {
            File file = new File(RegQuery.getPathPTAreg());
            System.out.println(file.getName());
            return file.getParent();
        }
        return "";
    }

    public static void main(String[] s) {
        System.out.println("Personal directory : " + RegQuery.getCurrentUserPersonalFolderPath());
        System.out.println("CPU Name  : " + RegQuery.getCPUName());
        System.out.println("CPU Speed : " + RegQuery.getCPUSpeed() + " Mhz");
        try {
            System.out.println("PTA PATH  : " + RegQuery.getPathPTA() + " ");
        }
        catch (IOException ex) {
            Logger.getLogger(RegQuery.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

