/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sib.cliente.ui.componentes;

import br.gov.ans.sib.cliente.ui.eventos.ArquivoListener;
import br.gov.ans.sib.cliente.ui.eventos.EventoArquivo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class SeletorArquivoSIB
extends JPanel
implements ActionListener {
    private File selecionado;
    private List<ArquivoListener> ouvintes = new ArrayList<ArquivoListener>();
    private Preferences preferencias = Preferences.userNodeForPackage(SeletorArquivoSIB.class);
    public static final String DIRETORIO_ARQUIVOS = "DIRETORIO_ARQUIVOS";
    private JTextField pathArquivo;
    private JButton selecionaArquivo;

    public SeletorArquivoSIB() {
        this.initComponents();
    }

    private void initComponents() {
        this.pathArquivo = new JTextField();
        this.selecionaArquivo = new JButton();
        this.selecionaArquivo.addActionListener(this);
        this.setBackground(new Color(255, 255, 255));
        this.pathArquivo.setBackground(new Color(255, 255, 255));
        this.pathArquivo.setEditable(false);
        this.selecionaArquivo.setBackground(new Color(255, 255, 255));
        this.selecionaArquivo.setIcon(new ImageIcon(this.getClass().getResource("/br/gov/ans/sib/cliente/ui/acoes/img/Folder2.gif")));
        this.selecionaArquivo.setToolTipText("Selecionar arquivo");
        this.selecionaArquivo.setBorder(null);
        this.selecionaArquivo.setPreferredSize(new Dimension(17, 20));
        this.selecionaArquivo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeletorArquivoSIB.this.selecionaArquivoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pathArquivo, -1, 208, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selecionaArquivo, -2, 29, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathArquivo, -2, -1, -2).addComponent(this.selecionaArquivo, -1, 20, Short.MAX_VALUE));
    }

    private void selecionaArquivoActionPerformed(ActionEvent evt) {
    }

    public void actionPerformed(ActionEvent e) {
        File diretorioCorrente = new File(this.preferencias.get(DIRETORIO_ARQUIVOS, "."));
        JFileChooser jf = new JFileChooser(diretorioCorrente);
        jf.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".SBX") || f.getName().endsWith(".sbx") || f.isDirectory();
            }

            public String getDescription() {
                return "Arquivos XML para o SIB (*.sbx)";
            }
        });
        int resp = jf.showOpenDialog(null);
        if (resp == 0) {
            this.setArquivoSelecionado(jf.getSelectedFile());
            this.pathArquivo.setText(jf.getSelectedFile().getAbsolutePath());
            this.fireSelecaoDeArquivoEvent(new EventoArquivo(jf.getSelectedFile(), this));
            this.preferencias.put(DIRETORIO_ARQUIVOS, jf.getSelectedFile().getParentFile().getAbsolutePath());
        } else {
            this.setArquivoSelecionado(null);
            this.fireSelecaoDeArquivoEvent(new EventoArquivo(null, this));
        }
    }

    public File getArquivoSelecionado() {
        return this.selecionado;
    }

    public void setArquivoSelecionado(File selecionado) {
        if (selecionado == null && this.selecionado != null) {
            this.pathArquivo.setText("");
        }
        this.selecionado = selecionado;
    }

    public static void main(String[] a) {
        JFrame test = new JFrame();
        test.setDefaultCloseOperation(3);
        SeletorArquivoSIB seletor = new SeletorArquivoSIB();
        test.add(seletor);
        test.pack();
        test.setVisible(true);
    }

    public void fireSelecaoDeArquivoEvent(EventoArquivo evento) {
        for (ArquivoListener ouvinte : this.ouvintes) {
            ouvinte.arquivoSelecionado(evento);
        }
    }

    public void fireValidacaoDeArquivoEvent(EventoArquivo evento) {
        for (ArquivoListener ouvinte : this.ouvintes) {
            ouvinte.arquivoValidado(evento);
        }
    }

    public void addArquivoListener(ArquivoListener ouvinte) {
        this.ouvintes.add(ouvinte);
    }

    public void removeArquivoListener(ArquivoListener ouvinte) {
        this.ouvintes.remove(ouvinte);
    }

    public JTextField getPath() {
        return this.pathArquivo;
    }
}

