/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sib.cliente.ui.acoes;

import br.gov.ans.sib.cliente.ui.acoes.ConcurrentAction;
import br.gov.ans.sib.cliente.ui.componentes.SeletorArquivoSIB;
import br.gov.ans.sib.cliente.ui.eventos.EventoArquivo;
import br.gov.ans.sib.cliente.ui.util.component.GlassPane;
import br.gov.ans.sibxml.dominio.common.SituacaoProcessamentoArquivoRecebido;
import br.gov.ans.sibxml.util.AppletFileHandler;
import br.gov.ans.sibxml.validador.xml.ValidadorXML;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;

public class ProcessarValidacao
extends ConcurrentAction {
    private GlassPane glassPane;
    private SeletorArquivoSIB seletorArquivo;
    private JFormattedTextField operadora;
    private ValidadorXML validador;
    private static final Logger logger = Logger.getLogger(ProcessarValidacao.class.getName());

    public ProcessarValidacao(GlassPane glassPane, ValidadorXML validador) {
        super("");
        this.putValue("ShortDescription", "Validar arquivo");
        this.glassPane = glassPane;
        this.validador = validador;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.seletorArquivo.getArquivoSelecionado() == null) {
            JOptionPane.showMessageDialog(null, "N\u00e3o h\u00e1 arquivo selecionado", "Erro", 0);
            return;
        }
        if (this.operadora == null || this.operadora.getText().replaceAll("-", "").trim().equals("")) {
            JOptionPane.showMessageDialog(null, "Informe c\u00f3digo da operadora", "Erro", 0);
            return;
        }
        this.glassPane.setVisible(true);
        this.glassPane.start();
        super.actionPerformed(e);
    }

    public void run() {
        this.processamento(this.validador);
        this.glassPane.stop();
        this.glassPane.setVisible(false);
    }

    private void processamento(ValidadorXML validador) throws HeadlessException {
        if (!this.validaNomeArquivo(this.seletorArquivo.getArquivoSelecionado())) {
            JOptionPane.showMessageDialog(null, "O Nome do arquivo n\u00e3o \u00e9 valido", "Erro", 0);
            return;
        }
        validador.reset();
        long registros = 0L;
        this.exibirRegistrosProcessados(registros);
        File arquivo = this.seletorArquivo.getArquivoSelecionado();
        String path = arquivo.getAbsolutePath();
        String numeroRegistroANS = this.operadora.getText().replaceAll("-", "");
        SituacaoProcessamentoArquivoRecebido resultado = null;
        try {
            resultado = validador.validaArquivoXml(path, numeroRegistroANS);
            registros = validador.getQtdRegistros();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o. Consulte Log da Aplica\u00e7\u00e3o em " + System.getProperty("user.home") + "\\sib.log", "Erro", 0);
            logger.log(Level.SEVERE, "ERRO FATAL:{0}", ex.getMessage());
            this.eventoValidacao(arquivo);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_VERSAO_PADRAO_INCORRETA == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - Erro no Cabe\u00e7alho ", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_REGISTRO_ANS_ORIGEM_NAO_INFORMADO == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - Registro ANS n\u00e3o informado ", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_REGISTRO_ANS_INCOERENTE == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - Registro ANS incorreto ", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_REGISTRO_ANS_OPERADORA_INATIVA == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - Registro ANS inativo ", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_CNPJ_ANS_NAO_INFORMADO == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - CNPJ n\u00e3o informado ", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_CNPJ_ANS_INCORRETO == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - CNPJ inv\u00e1lido", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_EPILOGO_HASH_INVALIDO == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - HASH do Arquivo inv\u00e1lido", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_QUANTIDADE_REGISTROS_ACIMA_PERMITIDA == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - Quantidade de registro acima do permitido", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.ERRO_VALIDACAO_XSD == resultado) {
            JOptionPane.showMessageDialog(null, "Falha durante a valida\u00e7\u00e3o - Arquivo n\u00e3o esta no formato valido ", "Erro", 0);
            return;
        }
        if (SituacaoProcessamentoArquivoRecebido.AGUARDANDO_PROCESSAMENTO == resultado) {
            JOptionPane.showMessageDialog(null, "Arquivo validado com sucesso!", "Aviso", 1);
            this.exibirRegistrosProcessados(registros);
            this.eventoValidacao(arquivo);
        }
    }

    private void exibirRegistrosProcessados(long registros) {
        if (registros > 0L) {
            JOptionPane.showMessageDialog(null, String.format("Registros encontrados: %d", registros), "Aviso", 0);
        }
    }

    private void eventoValidacao(File arquivo) {
        this.seletorArquivo.fireValidacaoDeArquivoEvent(new EventoArquivo(arquivo, this));
    }

    public void setSeletorArquivo(SeletorArquivoSIB seletorArquivo) {
        this.seletorArquivo = seletorArquivo;
    }

    public void setOperadoraComponent(JFormattedTextField operadora) {
        this.operadora = operadora;
    }

    private boolean validaNomeArquivo(File arquivoRecebido) {
        String nmArquivo = arquivoRecebido.getName();
        if (nmArquivo.length() != 24) {
            return false;
        }
        if (nmArquivo.split("\\.").length != 2) {
            return false;
        }
        String nomeArquivo = nmArquivo.split("\\.")[0];
        String extensaoArquivo = nmArquivo.split("\\.")[1];
        if (extensaoArquivo == null || !extensaoArquivo.toUpperCase().equals("SBX")) {
            return false;
        }
        if (!Pattern.compile("[0-9]{20}").matcher(nomeArquivo).matches()) {
            return false;
        }
        return nomeArquivo.substring(0, 6).equals(this.operadora.getText().replaceAll("-", ""));
    }

    static {
        try {
            logger.setUseParentHandlers(true);
            logger.setLevel(Level.ALL);
            logger.addHandler(new AppletFileHandler());
        }
        catch (Exception ex) {
            logger.addHandler(new ConsoleHandler());
        }
    }
}

