/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.framework.xml.hash;

import br.gov.ans.framework.xml.hash.XMLHashException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLHash {
    public static String getContentHashMD5(File fileXML) throws XMLHashException {
        String[] tags = new String[]{};
        return XMLHash.getContentHashMD5(fileXML, tags, "ISO-8859-1");
    }

    public static String getContentHashMD5(File fileXML, String[] tagsExcluidas) throws XMLHashException {
        return XMLHash.getContentHashMD5(fileXML, tagsExcluidas, "ISO-8859-1");
    }

    public static String getContentHashMD5(File fileXML, String[] tagsExcluidas, String encode) throws XMLHashException {
        try {
            return XMLHash.gerarHash(XMLHash.readNodesPullParse(fileXML, tagsExcluidas, encode));
        }
        catch (Exception e) {
            throw new XMLHashException(e);
        }
    }

    private static String gerarHash(byte[] bytes) throws Exception {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.reset();
        m.update(bytes);
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hashtext = bigInt.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext.toUpperCase();
    }

    private static byte[] readNodesPullParse(File file, String[] tagsExcluidas, String encode) throws XmlPullParserException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XmlPullParser mParser = factory.newPullParser();
        FileInputStream inputStream = new FileInputStream(file);
        if (mParser != null) {
            mParser.setInput((InputStream)inputStream, encode);
        }
        boolean add = true;
        boolean done = false;
        do {
            int event;
            if ((event = mParser.nextToken()) == 2) {
                if (Arrays.binarySearch(tagsExcluidas, mParser.getName()) > -1) {
                    add = false;
                }
                if (!add) continue;
                for (int i = 0; i < mParser.getAttributeCount(); ++i) {
                    stringBuilder.append(mParser.getAttributeValue(i));
                }
            } else {
                if (event == 4) {
                    if (!add || mParser.getText().trim().equals("")) continue;
                    stringBuilder.append(mParser.getText());
                    continue;
                }
                if (event == 3) {
                    if (Arrays.binarySearch(tagsExcluidas, mParser.getName()) <= -1) continue;
                    add = true;
                    continue;
                }
                if (event != 1) continue;
                done = true;
            }
        } while (!done);
        ((InputStream)inputStream).close();
        return stringBuilder.toString().getBytes(encode);
    }
}

