/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.sax2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Driver
implements Locator,
XMLReader,
Attributes {
    protected static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String APACHE_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    protected static final String APACHE_DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    protected ContentHandler contentHandler;
    protected ErrorHandler errorHandler;
    protected String systemId;
    protected XmlPullParser pp;

    private /* synthetic */ void finit$() {
        this.contentHandler = new DefaultHandler();
        this.errorHandler = new DefaultHandler();
    }

    public Driver() throws XmlPullParserException {
        this.finit$();
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(true);
        this.pp = xmlPullParserFactory.newPullParser();
    }

    public Driver(XmlPullParser xmlPullParser) throws XmlPullParserException {
        this.finit$();
        this.pp = xmlPullParser;
    }

    public int getLength() {
        return this.pp.getAttributeCount();
    }

    public String getURI(int n) {
        return this.pp.getAttributeNamespace(n);
    }

    public String getLocalName(int n) {
        return this.pp.getAttributeName(n);
    }

    public String getQName(int n) {
        String string = this.pp.getAttributePrefix(n);
        if (string != null) {
            return string + ':' + this.pp.getAttributeName(n);
        }
        return this.pp.getAttributeName(n);
    }

    public String getType(int n) {
        return this.pp.getAttributeType(n);
    }

    public String getValue(int n) {
        return this.pp.getAttributeValue(n);
    }

    public int getIndex(String string, String string2) {
        for (int i = 0; i < this.pp.getAttributeCount(); ++i) {
            if (!this.pp.getAttributeNamespace(i).equals(string) || !this.pp.getAttributeName(i).equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.pp.getAttributeCount(); ++i) {
            if (!this.pp.getAttributeName(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        for (int i = 0; i < this.pp.getAttributeCount(); ++i) {
            if (!this.pp.getAttributeNamespace(i).equals(string) || !this.pp.getAttributeName(i).equals(string2)) continue;
            return this.pp.getAttributeType(i);
        }
        return null;
    }

    public String getType(String string) {
        for (int i = 0; i < this.pp.getAttributeCount(); ++i) {
            if (!this.pp.getAttributeName(i).equals(string)) continue;
            return this.pp.getAttributeType(i);
        }
        return null;
    }

    public String getValue(String string, String string2) {
        return this.pp.getAttributeValue(string, string2);
    }

    public String getValue(String string) {
        return this.pp.getAttributeValue(null, string);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    public int getColumnNumber() {
        return this.pp.getColumnNumber();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            return this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        }
        if (NAMESPACE_PREFIXES_FEATURE.equals(string)) {
            return this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes");
        }
        if (VALIDATION_FEATURE.equals(string)) {
            return this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
        }
        return this.pp.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (NAMESPACES_FEATURE.equals(string)) {
                this.pp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", bl);
            } else if (NAMESPACE_PREFIXES_FEATURE.equals(string)) {
                if (this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes") != bl) {
                    this.pp.setFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", bl);
                }
            } else if (VALIDATION_FEATURE.equals(string)) {
                this.pp.setFeature("http://xmlpull.org/v1/doc/features.html#validation", bl);
            } else {
                this.pp.setFeature(string, bl);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new SAXNotSupportedException("problem with setting feature " + string + ": " + xmlPullParserException);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        return this.pp.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            throw new SAXNotSupportedException("not supported setting property " + string);
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            throw new SAXNotSupportedException("not supported setting property " + string);
        }
        try {
            this.pp.setProperty(string, object);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new SAXNotSupportedException("not supported set property " + string + ": " + xmlPullParserException);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        Object object;
        Object object2;
        block12: {
            this.systemId = inputSource.getSystemId();
            this.contentHandler.setDocumentLocator(this);
            Reader reader = inputSource.getCharacterStream();
            try {
                if (reader == null) {
                    object2 = inputSource.getByteStream();
                    object = inputSource.getEncoding();
                    if (object2 == null) {
                        this.systemId = inputSource.getSystemId();
                        if (this.systemId == null) {
                            SAXParseException sAXParseException = new SAXParseException("null source systemId", this);
                            this.errorHandler.fatalError(sAXParseException);
                            return;
                        }
                        try {
                            URL uRL = new URL(this.systemId);
                            object2 = uRL.openStream();
                        }
                        catch (MalformedURLException malformedURLException) {
                            try {
                                object2 = new FileInputStream(this.systemId);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                SAXParseException sAXParseException = new SAXParseException("could not open file with systemId " + this.systemId, this, fileNotFoundException);
                                this.errorHandler.fatalError(sAXParseException);
                                return;
                            }
                        }
                    }
                    this.pp.setInput((InputStream)object2, (String)object);
                    break block12;
                }
                this.pp.setInput(reader);
            }
            catch (XmlPullParserException xmlPullParserException) {
                SAXParseException sAXParseException = new SAXParseException("parsing initialization error: " + xmlPullParserException, this, xmlPullParserException);
                this.errorHandler.fatalError(sAXParseException);
                return;
            }
        }
        try {
            this.contentHandler.startDocument();
            this.pp.next();
            if (this.pp.getEventType() != 2) {
                object2 = new SAXParseException("expected start tag not" + this.pp.getPositionDescription(), this);
                this.errorHandler.fatalError((SAXParseException)object2);
                return;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            object = new SAXParseException("parsing initialization error: " + xmlPullParserException, this, xmlPullParserException);
            this.errorHandler.fatalError((SAXParseException)object);
            return;
        }
        this.parseSubTree(this.pp);
        this.contentHandler.endDocument();
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseSubTree(XmlPullParser xmlPullParser) throws SAXException, IOException {
        this.pp = xmlPullParser;
        boolean bl = xmlPullParser.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        try {
            if (xmlPullParser.getEventType() != 2) {
                throw new SAXException("start tag must be read before skiping subtree" + xmlPullParser.getPositionDescription());
            }
            int[] nArray = new int[2];
            StringBuffer stringBuffer = new StringBuffer(16);
            String string = null;
            String string2 = null;
            int n = xmlPullParser.getDepth() - 1;
            int n2 = 2;
            while (true) {
                switch (n2) {
                    case 2: {
                        int n3;
                        int n4;
                        int n5;
                        if (bl) {
                            int n6 = xmlPullParser.getDepth() - 1;
                            n5 = n > n6 ? xmlPullParser.getNamespaceCount(n6) : 0;
                            n4 = xmlPullParser.getNamespaceCount(n6 + 1);
                            for (n3 = n5; n3 < n4; ++n3) {
                                this.contentHandler.startPrefixMapping(xmlPullParser.getNamespacePrefix(n3), xmlPullParser.getNamespaceUri(n3));
                            }
                            string2 = xmlPullParser.getName();
                            string = xmlPullParser.getPrefix();
                            if (string != null) {
                                stringBuffer.setLength(0);
                                stringBuffer.append(string);
                                stringBuffer.append(':');
                                stringBuffer.append(string2);
                            }
                            this.startElement(xmlPullParser.getNamespace(), string2, string != null ? string2 : stringBuffer.toString());
                            break;
                        }
                        this.startElement(xmlPullParser.getNamespace(), xmlPullParser.getName(), xmlPullParser.getName());
                        break;
                    }
                    case 4: {
                        char[] cArray = xmlPullParser.getTextCharacters(nArray);
                        this.contentHandler.characters(cArray, nArray[0], nArray[1]);
                        break;
                    }
                    case 3: {
                        int n3;
                        int n4;
                        int n5;
                        if (bl) {
                            string2 = xmlPullParser.getName();
                            string = xmlPullParser.getPrefix();
                            if (string != null) {
                                stringBuffer.setLength(0);
                                stringBuffer.append(string);
                                stringBuffer.append(':');
                                stringBuffer.append(string2);
                            }
                            this.contentHandler.endElement(xmlPullParser.getNamespace(), string2, string != null ? string2 : stringBuffer.toString());
                            n5 = xmlPullParser.getDepth();
                            n4 = n > n5 ? xmlPullParser.getNamespaceCount(xmlPullParser.getDepth()) : 0;
                            n3 = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth() - 1);
                            for (int i = n3 - 1; i >= n4; --i) {
                                this.contentHandler.endPrefixMapping(xmlPullParser.getNamespacePrefix(i));
                            }
                            break;
                        } else {
                            this.contentHandler.endElement(xmlPullParser.getNamespace(), xmlPullParser.getName(), xmlPullParser.getName());
                            break;
                        }
                    }
                    case 1: {
                        return;
                    }
                }
                n2 = xmlPullParser.next();
                if (xmlPullParser.getDepth() <= n) return;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            SAXParseException sAXParseException = new SAXParseException("parsing error: " + xmlPullParserException, this, xmlPullParserException);
            xmlPullParserException.printStackTrace();
            this.errorHandler.fatalError(sAXParseException);
        }
    }

    protected void startElement(String string, String string2, String string3) throws SAXException {
        this.contentHandler.startElement(string, string2, string3, this);
    }
}

