/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sibxml.validador.xml;

import br.gov.ans.sibxml.dominio.xml.CancelamentoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.InclusaoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.MovimentoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.MudancaContratualBeneficiario;
import br.gov.ans.sibxml.dominio.xml.NaoEnvioBeneficiarios;
import br.gov.ans.sibxml.dominio.xml.ReativacaoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.RetificacaoBeneficiario;
import br.gov.ans.sibxml.util.AppletFileHandler;
import br.gov.ans.sibxml.validador.xml.ValidadorXMLImpl;
import br.gov.ans.sibxml.validador.xml.XMLParser;
import br.gov.ans.sibxml.validador.xml.entrada.Cabecalho;
import br.gov.ans.sibxml.validador.xml.entrada.Epilogo;
import br.gov.ans.sibxml.validador.xml.entrada.Falha;
import br.gov.ans.sibxml.validador.xml.entrada.MensagemSIB;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class XStreamXMLParser
implements XMLParser {
    private static final Logger logger = Logger.getLogger(ValidadorXMLImpl.class.getName());

    public Boolean validarXml(String urlXSD, String xmlFile) {
        try {
            String sl = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource ss = new StreamSource(urlXSD);
            Schema schema = factory.newSchema(ss);
            Validator v = schema.newValidator();
            v.validate(new StreamSource(xmlFile));
        }
        catch (IOException ex) {
            return null;
        }
        catch (SAXException ex) {
            return Boolean.FALSE;
        }
        catch (Exception ex) {
            return null;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MensagemSIB parseMensagemSIB(String pathArquivoXML) throws Exception {
        XStream xs = new XStream();
        xs.alias("mensagemSIB", MensagemSIB.class);
        xs.alias("falha", Falha.class);
        xs.alias("inclusao", InclusaoBeneficiario.class);
        xs.alias("retificacao", RetificacaoBeneficiario.class);
        xs.alias("reativacao", ReativacaoBeneficiario.class);
        xs.alias("mudancaContratual", MudancaContratualBeneficiario.class);
        xs.alias("cancelamento", CancelamentoBeneficiario.class);
        xs.alias("naoEnvioBeneficiarios", NaoEnvioBeneficiarios.class);
        xs.registerConverter((SingleValueConverter)new DateConverter("yyyy-MM-dd", new String[0], false));
        File arquivo = new File(pathArquivoXML);
        if (!arquivo.exists()) {
            throw new FileNotFoundException(pathArquivoXML);
        }
        FileReader reader = new FileReader(arquivo);
        ObjectInputStream in = xs.createObjectInputStream((Reader)reader);
        Object item = null;
        Cabecalho cabecalho = null;
        Epilogo epilogo = null;
        Long quantidadeRegistros = 0L;
        try {
            while ((item = in.readObject()) != null) {
                if (item instanceof Cabecalho) {
                    cabecalho = (Cabecalho)item;
                    continue;
                }
                if (item instanceof Epilogo) {
                    epilogo = (Epilogo)item;
                    continue;
                }
                if (!(item instanceof MovimentoBeneficiario)) continue;
                Long l = quantidadeRegistros;
                Long l2 = quantidadeRegistros = Long.valueOf(quantidadeRegistros + 1L);
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    static {
        try {
            logger.setUseParentHandlers(true);
            logger.setLevel(Level.ALL);
            logger.addHandler(new AppletFileHandler());
        }
        catch (Exception ex) {
            logger.addHandler(new ConsoleHandler());
        }
    }
}

