/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.renderer.GlyphRenderer;
import com.jgoodies.animation.renderer.HeightMode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class GlyphLabel
extends JComponent {
    public static final String PROPERTYNAME_HEIGHT_MODE = "heightMode";
    public static final String PROPERTYNAME_TEXT = "text";
    public static final String PROPERTYNAME_TIME = "time";
    private final GlyphRenderer renderer;

    public GlyphLabel(String text, long duration, long glyphDelay) {
        this(text, duration, glyphDelay, Color.DARK_GRAY);
    }

    public GlyphLabel(String text, long duration, long glyphDelay, Color baseColor) {
        this.renderer = new GlyphRenderer(text, GlyphLabel.defaultScaleFunction(duration), AnimationFunctions.ZERO, GlyphLabel.defaultColorFunction(duration, baseColor), glyphDelay);
    }

    public static AnimationFunction defaultScaleFunction(long duration) {
        return AnimationFunctions.linear(duration, new Float[]{new Float(5.0f), new Float(0.8f), new Float(1.0f), new Float(1.0f)}, new float[]{0.0f, 0.1f, 0.12f, 1.0f});
    }

    public static AnimationFunction defaultColorFunction(long duration, Color baseColor) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(duration, new Integer[]{new Integer(0), new Integer(255), new Integer(255)}, new float[]{0.0f, 0.15f, 1.0f}), baseColor);
    }

    public HeightMode getHeightMode() {
        return this.renderer.getHeightMode();
    }

    public String getText() {
        return this.renderer.getText();
    }

    public long getTime() {
        return this.renderer.getTime();
    }

    public void setHeightMode(HeightMode newHeightMode) {
        HeightMode oldHeightMode = this.getHeightMode();
        this.renderer.setHeightMode(newHeightMode);
        this.firePropertyChange(PROPERTYNAME_HEIGHT_MODE, oldHeightMode, newHeightMode);
        this.repaint();
    }

    public void setText(String newText) {
        String oldText = this.getText();
        this.renderer.setText(newText);
        this.firePropertyChange(PROPERTYNAME_TEXT, oldText, newText);
        this.repaint();
    }

    public void setTime(long newTime) {
        long oldTime = this.getTime();
        this.renderer.setTime(newTime);
        this.firePropertyChange(PROPERTYNAME_TIME, oldTime, newTime);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderer.setFont(this.getFont());
        this.renderer.render(g2, this.getWidth(), this.getHeight());
    }
}

