/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.animations;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.components.FanComponent;

public final class FanAnimation
extends AbstractAnimation {
    public static final double DEFAULT_CLOCKWISE_ROTATION = 0.01;
    public static final double DEFAULT_ANTICLOCKWISE_ROTATION = -0.02;
    private final FanComponent fan;
    private final AnimationFunctions.FloatFunction rotationFunction;

    public FanAnimation(FanComponent fan, long duration, AnimationFunction rotationFunction) {
        super(duration);
        this.fan = fan;
        this.rotationFunction = AnimationFunctions.asFloat(rotationFunction != null ? rotationFunction : FanAnimation.defaultRotationFunction(duration));
    }

    public static FanAnimation defaultFan(FanComponent fan, long duration) {
        return new FanAnimation(fan, duration, null);
    }

    public static AnimationFunction defaultRotationFunction(long duration) {
        return AnimationFunctions.fromTo(duration, 0.0f, (float)Math.PI * 2);
    }

    protected void applyEffect(long time) {
        this.fan.setRotation(this.rotationFunction.valueAt(time));
    }
}

