/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.AbstractAnimationFunction;
import com.jgoodies.animation.AnimationFunction;
import java.awt.Color;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public final class AnimationFunctions {
    public static final AnimationFunction ONE = AnimationFunctions.constant(Integer.MAX_VALUE, new Float(1.0f));
    public static final AnimationFunction ZERO = AnimationFunctions.constant(Integer.MAX_VALUE, new Float(0.0f));

    private AnimationFunctions() {
    }

    public static AnimationFunction alphaColor(AnimationFunction f, Color baseColor) {
        return new AlphaColorAnimationFunction(f, baseColor);
    }

    public static FloatFunction asFloat(AnimationFunction f) {
        return new FloatFunction(f);
    }

    public static AnimationFunction concat(AnimationFunction first, AnimationFunction second) {
        LinkedList<AnimationFunction> sequence = new LinkedList<AnimationFunction>();
        sequence.add(first);
        sequence.add(second);
        return new SequencedAnimationFunction(sequence);
    }

    public static AnimationFunction constant(long duration, Object value) {
        return AnimationFunctions.discrete(duration, new Object[]{value});
    }

    public static AnimationFunction discrete(long duration, Object[] values) {
        return AnimationFunctions.discrete(duration, values, null);
    }

    public static AnimationFunction discrete(long duration, Object[] values, float[] keyTimes) {
        return new InterpolatedAnimationFunction(duration, values, keyTimes, 1);
    }

    public static AnimationFunction fromBy(long duration, float from, float by) {
        return AnimationFunctions.fromTo(duration, from, from + by);
    }

    public static AnimationFunction fromTo(long duration, float from, float to) {
        return AnimationFunctions.linear(duration, new Float[]{new Float(from), new Float(to)});
    }

    public static AnimationFunction linear(long duration, Object[] values) {
        return AnimationFunctions.linear(duration, values, null);
    }

    public static AnimationFunction linear(long duration, Object[] values, float[] keyTimes) {
        return new InterpolatedAnimationFunction(duration, values, keyTimes, 2);
    }

    public static AnimationFunction linearColors(long duration, Color[] colors, float[] keyTimes) {
        return new ColorFunction(duration, colors, keyTimes);
    }

    public static AnimationFunction random(int min, int max, float changeProbability) {
        return new RandomAnimationFunction(min, max, changeProbability);
    }

    public static AnimationFunction repeat(AnimationFunction f, long repeatTime) {
        return new RepeatedAnimationFunction(f, repeatTime);
    }

    public static AnimationFunction reverse(AnimationFunction f) {
        return new ReversedAnimationFunction(f);
    }

    private static final class SequencedAnimationFunction
    implements AnimationFunction {
        private final List functions;

        private SequencedAnimationFunction(List functions) {
            this.functions = Collections.unmodifiableList(functions);
            if (this.functions.isEmpty()) {
                throw new IllegalArgumentException("The list of functions must not be empty.");
            }
        }

        public long duration() {
            long cumulatedDuration = 0L;
            Iterator i = this.functions.iterator();
            while (i.hasNext()) {
                AnimationFunction f = (AnimationFunction)i.next();
                cumulatedDuration += f.duration();
            }
            return cumulatedDuration;
        }

        public Object valueAt(long time) {
            if (time < 0L) {
                throw new IllegalArgumentException("The time must be positive.");
            }
            long begin = 0L;
            Iterator i = this.functions.iterator();
            while (i.hasNext()) {
                AnimationFunction f = (AnimationFunction)i.next();
                long end = begin + f.duration();
                if (time < end) {
                    return f.valueAt(time - begin);
                }
                begin = end;
            }
            throw new IllegalArgumentException("The time must be smaller than the total duration.");
        }
    }

    private static final class ReversedAnimationFunction
    extends AbstractAnimationFunction {
        private final AnimationFunction f;

        private ReversedAnimationFunction(AnimationFunction f) {
            super(f.duration());
            this.f = f;
        }

        public Object valueAt(long time) {
            return this.f.valueAt(this.duration() - time);
        }
    }

    private static final class RepeatedAnimationFunction
    extends AbstractAnimationFunction {
        private final AnimationFunction f;
        private final long simpleDuration;

        private RepeatedAnimationFunction(AnimationFunction f, long repeatTime) {
            super(repeatTime);
            this.f = f;
            this.simpleDuration = f.duration();
        }

        public Object valueAt(long time) {
            return this.f.valueAt(time % this.simpleDuration);
        }
    }

    private static final class RandomAnimationFunction
    implements AnimationFunction {
        private final float changeProbability;
        private final int max;
        private final int min;
        private final Random random = new Random();
        private Object value;

        private RandomAnimationFunction(int min, int max, float changeProbability) {
            this.min = min;
            this.max = max;
            this.changeProbability = changeProbability;
        }

        public long duration() {
            return Integer.MAX_VALUE;
        }

        public Object valueAt(long time) {
            if (this.value == null || this.random.nextFloat() < this.changeProbability) {
                this.value = new Integer(this.min + this.random.nextInt(this.max - this.min));
            }
            return this.value;
        }
    }

    private static final class InterpolatedAnimationFunction
    extends AbstractAnimationFunction {
        static final int MODE_DISCRETE = 1;
        static final int MODE_LINEAR = 2;
        private final float[] keyTimes;
        private final int mode;
        private final Object[] values;

        private InterpolatedAnimationFunction(long duration, Object[] values, float[] keyTimes, int mode) {
            super(duration);
            this.values = values;
            this.keyTimes = keyTimes;
            this.mode = mode;
            this.checkValidKeyTimes(values.length, keyTimes);
        }

        private void checkValidKeyTimes(int valuesLength, float[] theKeyTimes) {
            if (theKeyTimes == null) {
                return;
            }
            if (valuesLength < 2 || valuesLength != theKeyTimes.length) {
                throw new IllegalArgumentException("The values and key times arrays must be non-empty and must have equal length.");
            }
            for (int index = 0; index < theKeyTimes.length - 2; ++index) {
                if (!(theKeyTimes[index] >= theKeyTimes[index + 1])) continue;
                throw new IllegalArgumentException("The key times must be increasing.");
            }
        }

        private Object discreteValueAt(long time) {
            return this.values[this.indexAt(time, this.values.length)];
        }

        private int indexAt(long time, int intervalCount) {
            long duration = this.duration();
            if (this.keyTimes == null) {
                return (int)(time * (long)intervalCount / duration);
            }
            for (int index = this.keyTimes.length - 1; index > 0; --index) {
                if (!((float)time >= (float)duration * this.keyTimes[index])) continue;
                return index;
            }
            return 0;
        }

        private Object interpolateLinear(Object value1, Object value2, long time, long duration) {
            float f1 = ((Number)value1).floatValue();
            float f2 = ((Number)value2).floatValue();
            float value = f1 + (f2 - f1) * (float)time / (float)duration;
            return new Float(value);
        }

        private Object linearValueAt(long time) {
            int segments = this.values.length - 1;
            int beginIndex = this.indexAt(time, segments);
            int endIndex = beginIndex + 1;
            long lastTime = this.duration() - 1L;
            long beginTime = this.keyTimes == null ? (long)beginIndex * lastTime / (long)segments : (long)(this.keyTimes[beginIndex] * (float)lastTime);
            long endTime = this.keyTimes == null ? (long)endIndex * lastTime / (long)segments : (long)(this.keyTimes[endIndex] * (float)lastTime);
            return this.interpolateLinear(this.values[beginIndex], this.values[endIndex], time - beginTime, endTime - beginTime);
        }

        public Object valueAt(long time) {
            this.checkTimeRange(time);
            switch (this.mode) {
                case 1: {
                    return this.discreteValueAt(time);
                }
                case 2: {
                    return this.linearValueAt(time);
                }
            }
            throw new IllegalStateException("Unsupported interpolation mode.");
        }
    }

    public static class FloatFunction {
        private final AnimationFunction f;

        FloatFunction(AnimationFunction f) {
            this.f = f;
        }

        public long duration() {
            return this.f.duration();
        }

        public float valueAt(long time) {
            return ((Number)this.f.valueAt(time)).floatValue();
        }
    }

    private static final class ColorFunction
    extends AbstractAnimationFunction {
        private final FloatFunction redFunction;
        private final FloatFunction greenFunction;
        private final FloatFunction blueFunction;
        private final FloatFunction alphaFunction;

        private ColorFunction(long duration, Color[] colors, float[] keyTimes) {
            super(duration);
            Object[] red = new Float[colors.length];
            Object[] green = new Float[colors.length];
            Object[] blue = new Float[colors.length];
            Object[] alpha = new Float[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                red[i] = new Float(colors[i].getRed());
                green[i] = new Float(colors[i].getGreen());
                blue[i] = new Float(colors[i].getBlue());
                alpha[i] = new Float(colors[i].getAlpha());
            }
            this.redFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(duration, red, keyTimes));
            this.greenFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(duration, green, keyTimes));
            this.blueFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(duration, blue, keyTimes));
            this.alphaFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(duration, alpha, keyTimes));
        }

        public Object valueAt(long time) {
            return this.colorValueAt(time);
        }

        private Color colorValueAt(long time) {
            this.checkTimeRange(time);
            return new Color((int)this.redFunction.valueAt(time), (int)this.greenFunction.valueAt(time), (int)this.blueFunction.valueAt(time), (int)this.alphaFunction.valueAt(time));
        }
    }

    private static final class AlphaColorAnimationFunction
    implements AnimationFunction {
        private final Color baseColor;
        private final AnimationFunction fAlpha;

        private AlphaColorAnimationFunction(AnimationFunction fAlpha, Color baseColor) {
            this.fAlpha = fAlpha;
            this.baseColor = baseColor;
        }

        public long duration() {
            return this.fAlpha.duration();
        }

        public Object valueAt(long time) {
            int alpha = ((Float)this.fAlpha.valueAt(time)).intValue();
            return new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), alpha);
        }
    }
}

