/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.AnimationRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Random;

public final class FanRenderer
implements AnimationRenderer {
    private static final Random random = new Random(System.currentTimeMillis());
    private final Triangle[] triangles;
    private Point2D origin;
    private double rotation;

    public FanRenderer(Triangle[] triangles) {
        this.triangles = triangles;
    }

    public FanRenderer(int triangleCount, Color baseColor) {
        this(FanRenderer.createSectors(triangleCount, baseColor));
    }

    public static Triangle[] createSectors(int count, Color baseColor) {
        Triangle[] result = new Triangle[count];
        double sectorAngle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double rotation = (double)i * sectorAngle + ((double)random.nextFloat() - 0.5) * Math.PI / 10.0;
            double angle = sectorAngle * (0.2 + (double)random.nextFloat() * 0.4);
            result[i] = new Triangle(rotation, angle, FanRenderer.nextColor(baseColor));
        }
        return result;
    }

    private static Color nextColor(Color baseColor) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), hsb);
        float brightness = 0.8f + random.nextFloat() * 0.2f;
        return Color.getHSBColor(hsb[0], hsb[1], brightness);
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point2D origin) {
        this.origin = origin;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public void render(Graphics2D g2, int width, int height) {
        double radius = Math.sqrt(width * width + height * height);
        Point2D p = this.getOrigin() != null ? this.getOrigin() : this.getDefaultOrigin(width, height);
        g2.translate(p.getX(), p.getY());
        g2.rotate(this.rotation);
        for (int i = 0; i < this.triangles.length; ++i) {
            this.triangles[i].render(g2, radius);
        }
        g2.rotate(-this.rotation);
        g2.translate(-p.getX(), -p.getY());
    }

    private Point2D getDefaultOrigin(int width, int height) {
        return new Point2D.Double((double)width * 0.75, (double)height * 0.75);
    }

    private static final class Triangle {
        private final double aRotation;
        private final double angle;
        private final Color color;

        private Triangle(double rotation, double angle, Color color) {
            this.aRotation = rotation;
            this.angle = angle;
            this.color = color;
        }

        private static Shape createPolygon(double rotation, double angle, double radius) {
            double startAngle = rotation - angle / 2.0;
            double stopAngle = startAngle + angle;
            double hypothenusis = radius / Math.cos(angle / 2.0);
            float x0 = 0.0f;
            float y0 = 0.0f;
            float x1 = (float)((double)x0 - hypothenusis * Math.cos(startAngle));
            float y1 = (float)((double)y0 - hypothenusis * Math.sin(startAngle));
            float x2 = (float)((double)x0 - hypothenusis * Math.cos(stopAngle));
            float y2 = (float)((double)y0 - hypothenusis * Math.sin(stopAngle));
            GeneralPath polygon = new GeneralPath(0, 3);
            polygon.moveTo(x0, y0);
            polygon.lineTo(x1, y1);
            polygon.lineTo(x2, y2);
            polygon.closePath();
            return polygon;
        }

        void render(Graphics2D g2, double radius) {
            g2.setColor(this.color);
            g2.fill(Triangle.createPolygon(this.aRotation, this.angle, radius));
        }
    }
}

