/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationAdapter;
import com.jgoodies.animation.AnimationEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public final class Animator
implements ActionListener {
    private final Animation animation;
    private final Timer timer;
    private final int framesPerSecond;
    private long startTime;
    private long elapsedTime = 0L;

    public Animator(Animation animation, int framesPerSecond) {
        if (animation == null) {
            throw new NullPointerException("The animation must not be null.");
        }
        if (framesPerSecond <= 0) {
            throw new IllegalArgumentException("The frame rate must be positive.");
        }
        this.animation = animation;
        this.framesPerSecond = framesPerSecond;
        this.timer = this.createTimer(framesPerSecond);
    }

    public Animation animation() {
        return this.animation;
    }

    public int framesPerSecond() {
        return this.framesPerSecond;
    }

    public long elapsedTime() {
        if (!this.timer.isRunning()) {
            return this.elapsedTime;
        }
        long now = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = now;
        }
        return now - this.startTime + this.elapsedTime;
    }

    public void start() {
        if (!this.timer.isRunning()) {
            this.registerStopListener();
            this.startTime = -1L;
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.elapsedTime = this.elapsedTime();
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.animation.animate(this.elapsedTime());
    }

    public String toString() {
        return "elapsedTime=" + this.elapsedTime() + "; fps=" + this.framesPerSecond;
    }

    private Timer createTimer(int fps) {
        int delay = 1000 / fps;
        Timer aTimer = new Timer(delay, this);
        aTimer.setInitialDelay(0);
        aTimer.setCoalesce(true);
        return aTimer;
    }

    private void registerStopListener() {
        this.animation.addAnimationListener(new AnimationAdapter(){

            public void animationStopped(AnimationEvent e) {
                Animator.this.stop();
            }
        });
    }
}

