/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sib.cliente.ui.util.component;

import com.jgoodies.animation.Animator;
import com.jgoodies.animation.animations.FanAnimation;
import com.jgoodies.animation.components.FanComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.Timer;

public class GlassPane
extends JLabel {
    private Animator animator;
    private FanComponent fan = new FanComponent(360, new Color(128, 129, 128, 2));
    private Timer timer;

    public GlassPane() {
        super("Em processamento. Aguarde...", 0);
        this.setVerticalAlignment(0);
        this.setFont(this.getFont().deriveFont(18.0f).deriveFont(1));
        this.setForeground(new Color(128, 128, 128, 128));
        this.setLayout(new BorderLayout());
        this.add(this.fan);
        this.setOpaque(false);
        this.setBackground(new Color(220, 220, 220, 2));
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlassPane.this.criarAnimacao(1000);
                GlassPane.this.animator.start();
            }
        });
        this.timer.setRepeats(true);
    }

    public void start() {
        this.prepararAnimacao();
        this.animator.start();
        this.timer.start();
    }

    private void prepararAnimacao() {
        double x = this.getWidth() / 2;
        double y = this.getHeight() / 2;
        this.fan.setOrigin(new Point2D.Double(x, y));
        this.criarAnimacao(this.timer.getDelay());
    }

    private void criarAnimacao(int duracao) {
        FanAnimation animation = FanAnimation.defaultFan(this.fan, duracao);
        this.animator = new Animator(animation, 300);
    }

    public void stop() {
        this.animator.stop();
        this.timer.stop();
    }
}

