/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sib.cliente.ui.acoes;

import br.gov.ans.sib.cliente.PTALib;
import br.gov.ans.sib.cliente.ui.acoes.ConcurrentAction;
import br.gov.ans.sib.cliente.ui.acoes.ProcessarValidacao;
import br.gov.ans.sib.cliente.ui.componentes.SeletorArquivoSIB;
import br.gov.ans.sib.cliente.ui.eventos.ArquivoListener;
import br.gov.ans.sib.cliente.ui.eventos.EventoArquivo;
import br.gov.ans.sibxml.util.AppletFileHandler;
import br.gov.ans.sibxml.validador.xml.ValidadorXML;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Transmitir
extends ConcurrentAction
implements ArquivoListener {
    private static final Logger logger = Logger.getLogger(ProcessarValidacao.class.getName());
    private SeletorArquivoSIB seletorArquivo;
    private JFormattedTextField componenteOperadora;
    private ValidadorXML validador;
    private JLabel status;
    private boolean transOk = false;

    public Transmitir(ValidadorXML validador) {
        super("");
        this.putValue("ShortDescription", "Transmitir arquivo");
        this.setEnabled(false);
        this.validador = validador;
        this.transOk = false;
    }

    public void run() {
        if (this.seletorArquivo.getArquivoSelecionado() == null) {
            JOptionPane.showMessageDialog(null, "N\u00e3o h\u00e1 arquivo selecionado", "Erro", 0);
            return;
        }
        String operadora = this.componenteOperadora.getText().replaceAll("-", "");
        String pathXML = this.seletorArquivo.getArquivoSelecionado().getAbsolutePath();
        String hash = "";
        String arquivoResposta = this.seletorArquivo.getArquivoSelecionado().getName().toUpperCase();
        String sistema = "SBX";
        String versao = "1.1.0";
        String idEnvio = "Envio de Arquivo SIB-XML";
        String vazio = " ";
        this.transOk = false;
        Integer resp = PTALib.INSTANCE.CallTransmiteXMLPTA(" ", operadora, pathXML, arquivoResposta, hash, "SBX", "1.1.0", "Envio de Arquivo SIB-XML");
        if (resp == 0) {
            JOptionPane.showMessageDialog(null, "Envio Realizado com sucesso");
            this.transOk = true;
            this.LimpaControles();
            this.setEnabled(false);
        } else {
            this.transOk = false;
            this.LimpaControles();
            this.setEnabled(false);
            JOptionPane.showMessageDialog(null, "Ocorreram problemas no envio do arquivo. Checar logs da aplica\u00e7\u00e3o em " + System.getProperty("user.home") + "\\sib.log", "Erro", 0);
            this.classifica_erro(resp);
        }
    }

    public void classifica_erro(int cod) {
        String Descricao_Log = "";
        switch (cod) {
            case 0: {
                Descricao_Log = "Falha inesparada. Erro PTA (0)";
                break;
            }
            case 1: {
                Descricao_Log = "Erro ao abrir arquivo de par\u00e2metro. Erro PTA (1)";
                break;
            }
            case 2: {
                Descricao_Log = "Erro ao abrir arquivo de resposta. Erro PTA (2)";
                break;
            }
            case 3: {
                Descricao_Log = "Erro ao abrir arquivo de dados para envio. Erro PTA (3)";
                break;
            }
            case 4: {
                Descricao_Log = "Erro de transmiss\u00e3o. Erro PTA (4)";
                break;
            }
            case 5: {
                Descricao_Log = "Erro ao ler/transmitir arquivo a ser enviado. Erro PTA (5)";
                break;
            }
            case 997: {
                Descricao_Log = "Time-OUT na conex\u00e3o. Erro 997";
                break;
            }
            case 10060: {
                Descricao_Log = "Time-OUT na conex\u00e3o. Erro 10060 (WSAETIMEDOUT)";
                break;
            }
            case 10064: {
                Descricao_Log = "Time-OUT na conex\u00e3o. Erro 10064 (WSAEHOSTDOWN)";
                break;
            }
            case 64: {
                Descricao_Log = "A rede/m\u00e1quina de destino n\u00e3o est\u00e1 mais dispon\u00edvel. Erro 64 (ERROR_NETNAME_DELETED)";
                break;
            }
            case 10024: {
                Descricao_Log = "Excesso de conex\u00f5es abertas ou Indisponibilidade de Recursos. Erro 10024 (WSAEMFILE)";
                break;
            }
            case 10054: {
                Descricao_Log = "Conex\u00e3o fechada pelo host remoto. Erro 10054 (WSAECONNRESET)";
                break;
            }
            case 10055: {
                Descricao_Log = "Falta de recursos do sistema. Erro 10055 (WSAENOBUFS)";
                break;
            }
            default: {
                Descricao_Log = "Erro no envio do arquivo.";
            }
        }
        if (Descricao_Log.trim() != "") {
            logger.severe(Descricao_Log);
        }
    }

    private void LimpaControles() {
        this.componenteOperadora.setValue(null);
        this.seletorArquivo.getPath().setText("");
        this.seletorArquivo.setArquivoSelecionado(null);
        this.status.setText("");
        this.validador.reset();
    }

    public void arquivoSelecionado(EventoArquivo evento) {
        this.habilitarDesabilitar(evento);
    }

    private void habilitarDesabilitar(EventoArquivo evento) {
        this.setEnabled(evento.getArquivo() != null && this.validador.isArquivoValidado());
    }

    public void setComponenteOperadora(JFormattedTextField componenteOperadora) {
        this.componenteOperadora = componenteOperadora;
    }

    public void setSeletorArquivo(SeletorArquivoSIB seletorArquivo) {
        this.seletorArquivo = seletorArquivo;
    }

    public void arquivoValidado(EventoArquivo evento) {
        this.habilitarDesabilitar(evento);
    }

    public void setStatusComponent(JLabel status) {
        this.status = status;
    }

    public void setTransOk(boolean transOk) {
        this.transOk = transOk;
    }

    public boolean getTransOk() {
        return this.transOk;
    }

    static {
        try {
            logger.setUseParentHandlers(true);
            logger.setLevel(Level.ALL);
            logger.addHandler(new AppletFileHandler());
        }
        catch (Exception ex) {
            logger.addHandler(new ConsoleHandler());
        }
    }
}

