/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sib.cliente;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class Configuracoes {
    private static Configuracoes instance;
    private static String HOST;
    private static String PORTA;
    private static String USER;
    private static String PASSWORD;
    private static String USAR_PROXY;
    private Preferences preferencias = Preferences.userNodeForPackage(Configuracoes.class);

    private Configuracoes() {
        this.init();
    }

    private void init() {
        if (this.getUsarProxy().booleanValue()) {
            this.defineProxy();
        } else {
            this.removeProxy();
        }
    }

    public static Configuracoes getInstance() {
        if (instance == null) {
            instance = new Configuracoes();
        }
        return instance;
    }

    public void setUsarProxy(Boolean ativar) {
        if (ativar != null) {
            this.preferencias.put(USAR_PROXY, ativar.toString());
        }
    }

    public Boolean getUsarProxy() {
        return Boolean.valueOf(this.preferencias.get(USAR_PROXY, "true"));
    }

    public void setProxy(String host, String porta, String user, String password) {
        this.preferencias.put(HOST, host);
        this.preferencias.put(PORTA, porta);
        this.preferencias.put(USER, user);
        this.preferencias.put(PASSWORD, password);
    }

    public String getHost() {
        return this.preferencias.get(HOST, null);
    }

    public String getPorta() {
        return this.preferencias.get(PORTA, null);
    }

    public String getUser() {
        return this.preferencias.get(USER, null);
    }

    public String getPassword() {
        return this.preferencias.get(PASSWORD, null);
    }

    public final void defineProxy() {
        System.setProperty("proxySet", "true");
        if (this.getHost() != null && this.getPorta() != null) {
            System.setProperty("proxyHost", this.getHost());
            System.setProperty("proxyPort", this.getPorta());
        }
        if (this.getUser() != null && this.getPassword() != null) {
            System.setProperty("proxyUser", this.getUser());
            System.setProperty("proxyPassword", this.getPassword());
        }
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(Configuracoes.this.getUser(), Configuracoes.this.getPassword().toCharArray());
            }
        });
    }

    public void removeProxy() {
        System.getProperties().remove("proxySet");
        System.getProperties().remove("proxyHost");
        System.getProperties().remove("proxyPort");
        System.getProperties().remove("proxyUser");
        System.getProperties().remove("proxyPassword");
        Authenticator.setDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testar() throws IOException {
        InputStream in = null;
        try {
            Configuracoes.getInstance().defineProxy();
            URL url = null;
            try {
                String site = "http://www.ans.gov.br/padroes/sib/schemas/sib.xsd";
                url = new URL(site);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Configuracoes.class.getName()).log(Level.SEVERE, null, ex);
                throw ex;
            }
            url.openConnection();
            in = url.openStream();
            byte[] buffer = new byte[1024];
            in.read(buffer);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void main(String[] a) {
        Console console = System.console();
        console.printf("Digite usu\u00e1rio? ", new Object[0]);
        String user = console.readLine();
        console.printf("Digite sua senha: ", new Object[0]);
        String senha = new String(console.readPassword());
        console.printf("Site desejado: ", new Object[0]);
        String site = console.readLine();
        Configuracoes.getInstance().setProxy("cache.ans.gov.br", "3128", user, senha);
        Configuracoes.getInstance().defineProxy();
        try {
            URL url = new URL(site);
            url.openConnection();
            InputStream in = url.openStream();
            byte[] buffer = new byte[4096];
            int lidos = in.read(buffer);
            in.close();
            System.out.printf("Primeiros %d bytes lidos:\n", lidos);
            System.out.println(new String(buffer));
        }
        catch (Exception ex) {
            System.out.printf("Exce\u00e7\u00e3o para Usuario %s e senha %s\n", user, senha);
            System.out.printf("Ao acessar site %s\n", site);
            System.out.println("Propriedades:\n");
            System.out.printf("proxyHost: %s\n", System.getProperty("proxyHost"));
            System.out.printf("proxyPort: %s\n", System.getProperty("proxyPort"));
            System.out.printf("proxyUser: %s\n", System.getProperty("proxyUser"));
            System.out.printf("proxyPassword: %s\n", System.getProperty("proxyPassword"));
            Logger.getLogger(Configuracoes.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        HOST = "HOST";
        PORTA = "PORTA";
        USER = "USER";
        PASSWORD = "SENHA";
        USAR_PROXY = "USAR_PROXY";
    }
}

