/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.framework.xml.schema;

import br.gov.ans.framework.xml.schema.XMLValidatorFatalException;
import br.gov.ans.framework.xml.schema.XMLValidatorInvalidFileException;
import com.sun.org.apache.xerces.internal.impl.io.MalformedByteSequenceException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLValidator {
    public static void validaSchema(String xml, String xsd) throws XMLValidatorInvalidFileException, XMLValidatorFatalException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            SAXParser parser = null;
            try {
                factory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource(xsd)}));
                parser = factory.newSAXParser();
            }
            catch (SAXParseException se) {
                throw new IOException("Erro ao carregar o XSD", se);
            }
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException e) throws SAXException {
                }

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            reader.parse(new InputSource(xml));
        }
        catch (MalformedByteSequenceException me) {
            throw new XMLValidatorInvalidFileException(me);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLValidatorFatalException(pce);
        }
        catch (IOException io) {
            throw new XMLValidatorFatalException(io);
        }
        catch (SAXException se) {
            throw new XMLValidatorInvalidFileException(se);
        }
    }
}

