/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.dom2_builder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DOM2XmlPullBuilder {
    protected Document newDoc() throws XmlPullParserException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            return documentBuilder.newDocument();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new XmlPullParserException("could not configure factory JAXP DocumentBuilderFactory: " + factoryConfigurationError, null, factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XmlPullParserException("could not configure parser JAXP DocumentBuilderFactory: " + parserConfigurationException, null, parserConfigurationException);
        }
    }

    protected XmlPullParser newParser() throws XmlPullParserException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        return xmlPullParserFactory.newPullParser();
    }

    public Element parse(Reader reader) throws XmlPullParserException, IOException {
        Document document = this.newDoc();
        return this.parse(reader, document);
    }

    public Element parse(Reader reader, Document document) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = this.newParser();
        xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        xmlPullParser.setInput(reader);
        xmlPullParser.next();
        return this.parse(xmlPullParser, document);
    }

    public Element parse(XmlPullParser xmlPullParser, Document document) throws XmlPullParserException, IOException {
        Element element = this.parseSubTree(xmlPullParser, document);
        return element;
    }

    public Element parseSubTree(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        Document document = this.newDoc();
        Element element = this.parseSubTree(xmlPullParser, document);
        return element;
    }

    public Element parseSubTree(XmlPullParser xmlPullParser, Document document) throws XmlPullParserException, IOException {
        BuildProcess buildProcess = new BuildProcess();
        return buildProcess.parseSubTree(xmlPullParser, document);
    }

    private static void assertEquals(String string, String string2) {
        if (string != null && !string.equals(string2) || string == null && string2 == null) {
            throw new RuntimeException("expected '" + string + "' but got '" + string2 + "'");
        }
    }

    private static void assertNotNull(Object object) {
        if (object == null) {
            throw new RuntimeException("expected no null value");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Element element;
        DOM2XmlPullBuilder dOM2XmlPullBuilder = new DOM2XmlPullBuilder();
        String string = "<n:foo xmlns:n='uri1'><bar n:attr='test' xmlns='uri2'>baz</bar></n:foo>";
        StringReader stringReader = new StringReader(string);
        Element element2 = dOM2XmlPullBuilder.parse(stringReader);
        StringWriter stringWriter = new StringWriter();
        stringReader = new StringReader(string);
        Element element3 = element = dOM2XmlPullBuilder.parse(stringReader);
        System.out.println("root ns=" + element3.getNamespaceURI() + ", localName=" + element3.getLocalName());
        DOM2XmlPullBuilder.assertEquals("uri1", element3.getNamespaceURI());
        DOM2XmlPullBuilder.assertEquals("foo", element3.getLocalName());
        NodeList nodeList = element3.getElementsByTagNameNS("*", "bar");
        Element element4 = (Element)nodeList.item(0);
        System.out.println("bar ns=" + element4.getNamespaceURI() + ", localName=" + element4.getLocalName());
        DOM2XmlPullBuilder.assertEquals("uri2", element4.getNamespaceURI());
        DOM2XmlPullBuilder.assertEquals("bar", element4.getLocalName());
        String string2 = element4.getAttributeNS("uri1", "attr");
        DOM2XmlPullBuilder.assertEquals("test", string2);
        Attr attr = element4.getAttributeNodeNS("uri1", "attr");
        DOM2XmlPullBuilder.assertNotNull(attr);
        DOM2XmlPullBuilder.assertEquals("uri1", attr.getNamespaceURI());
        DOM2XmlPullBuilder.assertEquals("attr", attr.getLocalName());
        DOM2XmlPullBuilder.assertEquals("test", attr.getValue());
        Text text = (Text)element4.getFirstChild();
        System.out.println("text=" + text.getNodeValue());
        DOM2XmlPullBuilder.assertEquals("baz", text.getNodeValue());
    }

    static class BuildProcess {
        private XmlPullParser pp;
        private Document docFactory;
        private boolean scanNamespaces;

        private /* synthetic */ void finit$() {
            this.scanNamespaces = true;
        }

        private BuildProcess() {
            this.finit$();
        }

        public Element parseSubTree(XmlPullParser xmlPullParser, Document document) throws XmlPullParserException, IOException {
            this.pp = xmlPullParser;
            this.docFactory = document;
            return this.parseSubTree();
        }

        private Element parseSubTree() throws XmlPullParserException, IOException {
            Object object;
            this.pp.require(2, null, null);
            String string = this.pp.getName();
            String string2 = this.pp.getNamespace();
            String string3 = this.pp.getPrefix();
            String string4 = string3 != null ? string3 + ":" + string : string;
            Element element = this.docFactory.createElementNS(string2, string4);
            this.declareNamespaces(this.pp, element);
            for (int i = 0; i < this.pp.getAttributeCount(); ++i) {
                object = this.pp.getAttributeNamespace(i);
                String string5 = this.pp.getAttributeName(i);
                String string6 = this.pp.getAttributeValue(i);
                if (object == null || ((String)object).length() == 0) {
                    element.setAttribute(string5, string6);
                    continue;
                }
                String string7 = this.pp.getAttributePrefix(i);
                String string8 = string7 != null ? string7 + ":" + string5 : string5;
                element.setAttributeNS((String)object, string8, string6);
            }
            while (this.pp.next() != 3) {
                Object object2;
                if (this.pp.getEventType() == 2) {
                    object2 = this.parseSubTree(this.pp, this.docFactory);
                    element.appendChild((Node)object2);
                    continue;
                }
                if (this.pp.getEventType() == 4) {
                    object2 = this.pp.getText();
                    object = this.docFactory.createTextNode((String)object2);
                    element.appendChild((Node)object);
                    continue;
                }
                throw new XmlPullParserException("unexpected event " + XmlPullParser.TYPES[this.pp.getEventType()], this.pp, null);
            }
            this.pp.require(3, string2, string);
            return element;
        }

        private void declareNamespaces(XmlPullParser xmlPullParser, Element element) throws DOMException, XmlPullParserException {
            if (this.scanNamespaces) {
                int n;
                this.scanNamespaces = false;
                block0: for (int i = n = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth()) - 1; i >= xmlPullParser.getNamespaceCount(0); --i) {
                    String string = xmlPullParser.getNamespacePrefix(i);
                    for (int j = n; j > i; --j) {
                        if (string.equals(xmlPullParser.getNamespacePrefix(j))) continue block0;
                    }
                    this.declareOneNamespace(xmlPullParser, i, element);
                }
            } else {
                for (int i = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth() - 1); i < xmlPullParser.getNamespaceCount(xmlPullParser.getDepth()); ++i) {
                    this.declareOneNamespace(xmlPullParser, i, element);
                }
            }
        }

        private void declareOneNamespace(XmlPullParser xmlPullParser, int n, Element element) throws DOMException, XmlPullParserException {
            String string = xmlPullParser.getNamespacePrefix(n);
            String string2 = xmlPullParser.getNamespaceUri(n);
            String string3 = string != null ? "xmlns:" + string : "xmlns";
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
        }
    }
}

