/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sibxml.validador.xml;

import br.gov.ans.sibxml.validador.xml.XMLHashException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLHash {
    private static String hashGerado;
    private static String hashInformado;

    public static boolean isValidHash() throws Exception {
        if (hashInformado == null || hashInformado.trim().equals("")) {
            return false;
        }
        return hashGerado.toUpperCase().equals(hashInformado.toUpperCase());
    }

    public static String getContentHashMD5(File fileXML) throws XMLHashException {
        String[] tags = new String[]{};
        return XMLHash.getContentHashMD5(fileXML, tags, "ISO-8859-1");
    }

    public static String getContentHashMD5(File fileXML, String[] tagsExcluidas) throws XMLHashException {
        return XMLHash.getContentHashMD5(fileXML, tagsExcluidas, "ISO-8859-1");
    }

    public static String getContentHashMD5(File fileXML, String[] tagsExcluidas, String encode) throws XMLHashException {
        try {
            return XMLHash.gerarHash(XMLHash.readNodesPullParse(fileXML, tagsExcluidas, encode));
        }
        catch (Exception e) {
            throw new XMLHashException(e);
        }
    }

    private static String gerarHash(byte[] bytes) throws Exception {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.reset();
        m.update(bytes);
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hashtext = bigInt.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        hashGerado = hashtext.toUpperCase();
        return hashGerado;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] readNodesPullParse(File file, String[] tagsExcluidas, String encode) throws XmlPullParserException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XmlPullParser mParser = factory.newPullParser();
        FileInputStream inputStream = new FileInputStream(file);
        if (mParser != null) {
            mParser.setInput((InputStream)inputStream, encode);
        }
        boolean add = true;
        boolean bHash = false;
        boolean done = false;
        do {
            int event;
            if ((event = mParser.nextToken()) == 2) {
                if (Arrays.binarySearch(tagsExcluidas, mParser.getName()) > -1) {
                    add = false;
                }
                if (add) {
                    for (int i = 0; i < mParser.getAttributeCount(); ++i) {
                        stringBuilder.append(mParser.getAttributeValue(i));
                    }
                    continue;
                } else {
                    if (!mParser.getName().equals("hash")) continue;
                    bHash = true;
                    continue;
                }
            }
            if (event == 4) {
                if (add) {
                    if (mParser.getText().trim().equals("")) continue;
                    stringBuilder.append(mParser.getText());
                    continue;
                }
                if (!bHash || mParser.getText().trim().equals("")) continue;
                hashInformado = mParser.getText().trim();
                continue;
            }
            if (event == 3) {
                if (Arrays.binarySearch(tagsExcluidas, mParser.getName()) <= -1) continue;
                add = true;
                continue;
            }
            if (event != 1) continue;
            done = true;
        } while (!done);
        if (mParser != null) {
            ((InputStream)inputStream).close();
        }
        return stringBuilder.toString().getBytes(encode);
    }
}

