/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sibxml.validador.xml;

import br.gov.ans.sibxml.dominio.common.Beneficiario;
import br.gov.ans.sibxml.dominio.common.SituacaoProcessamentoArquivoRecebido;
import br.gov.ans.sibxml.dominio.xml.CancelamentoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.InclusaoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.MudancaContratualBeneficiario;
import br.gov.ans.sibxml.dominio.xml.NaoEnvioBeneficiarios;
import br.gov.ans.sibxml.dominio.xml.ReativacaoBeneficiario;
import br.gov.ans.sibxml.dominio.xml.RetificacaoBeneficiario;
import br.gov.ans.sibxml.util.AppletFileHandler;
import br.gov.ans.sibxml.validador.xml.Mensagem;
import br.gov.ans.sibxml.validador.xml.ValidadorXML;
import br.gov.ans.sibxml.validador.xml.XMLHash;
import br.gov.ans.sibxml.validador.xml.entrada.Cabecalho;
import br.gov.ans.sibxml.validador.xml.entrada.Epilogo;
import br.gov.ans.sibxml.validador.xml.entrada.Falha;
import br.gov.ans.sibxml.validador.xml.entrada.MensagemSIB;
import br.gov.ans.sibxml.validador.xml.entrada.OperadoraParaANS;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ValidadorXMLSibClienteImpl
implements ValidadorXML {
    private static final Logger logger = Logger.getLogger(ValidadorXMLSibClienteImpl.class.getName());
    private boolean arquivoValido;
    private SituacaoProcessamentoArquivoRecebido situacaoValidador;
    private Long QtdRegistros = 0L;

    @Override
    public Long getQtdRegistros() {
        return this.QtdRegistros;
    }

    public br.gov.ans.sibxml.validador.xml.entrada.Mensagem validaArquivoXml(br.gov.ans.sibxml.validador.xml.entrada.Mensagem mensagem) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SituacaoProcessamentoArquivoRecebido validaArquivoXml(String pathArquivoXml, String registroANS) throws Exception {
        logger.info(String.format("Processo de valida\u00e7\u00e3o iniciado para %s", pathArquivoXml));
        this.arquivoValido = Boolean.FALSE;
        if (!this.validaXsd(pathArquivoXml)) {
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_VALIDACAO_XSD;
            return this.situacaoValidador;
        }
        Cabecalho cabecalho = null;
        Long quantidadeRegistros = 0L;
        File arquivo = new File(pathArquivoXml);
        XStream xs = new XStream();
        if (!arquivo.exists()) {
            logger.severe("ERRO FATAL: Nao foi possivel encontrar o arquivo no caminho especificado (" + pathArquivoXml + ")");
            throw new FileNotFoundException("Nao foi possivel encontrar o arquivo no caminho especificado (" + pathArquivoXml + ")");
        }
        xs.alias("mensagemSIB", MensagemSIB.class);
        xs.alias("cabecalho", Cabecalho.class);
        xs.alias("epilogo", Epilogo.class);
        xs.alias("operadoraParaANS", OperadoraParaANS.class);
        xs.alias("beneficiario", Beneficiario.class);
        xs.alias("inclusao", InclusaoBeneficiario.class);
        xs.alias("retificacao", RetificacaoBeneficiario.class);
        xs.alias("reativacao", ReativacaoBeneficiario.class);
        xs.alias("mudancaContratual", MudancaContratualBeneficiario.class);
        xs.alias("cancelamento", CancelamentoBeneficiario.class);
        xs.alias("naoEnvioBeneficiarios", NaoEnvioBeneficiarios.class);
        xs.alias("falha", Falha.class);
        xs.registerConverter((SingleValueConverter)new DateConverter("yyyy-MM-dd", new String[0], false));
        FileReader reader = new FileReader(arquivo);
        try {
            ObjectInputStream in = xs.createObjectInputStream((Reader)reader);
            Object item = null;
            try {
                item = in.readObject();
                if (item instanceof Cabecalho) {
                    cabecalho = (Cabecalho)item;
                }
            }
            catch (Exception exception) {
                logger.severe("ERRO: ao ler evento xml " + exception.getMessage());
                throw new Exception("Nao foi possivel recuperar as informacoes de cabecalho e epilogo do XML");
            }
        }
        finally {
            this.QtdRegistros = quantidadeRegistros;
            reader.close();
        }
        if (cabecalho == null) {
            logger.severe("ERRO FATAL: Nao foi possivel recuperar as informacoes de cabecalho do XML.");
            throw new Exception("Nao foi possivel recuperar as informacoes de cabecalho do XML");
        }
        if (!this.validaRegistroANSInformado(cabecalho)) {
            logger.severe("ERRO: REGISTRO ANS NAO INFORMADO NO CABECALHO");
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_REGISTRO_ANS_ORIGEM_NAO_INFORMADO;
            return this.situacaoValidador;
        }
        if (!this.validaRegistroANSCoerenteArquivo(registroANS, cabecalho)) {
            logger.severe("ERRO: REGISTRO ANS DO CABECALHO INCOERENTE COM A OPERADORA QUE ENVIOU O ARQUIVO");
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_REGISTRO_ANS_INCOERENTE;
            return this.situacaoValidador;
        }
        if (!this.validaRegistroANSOperadoraAtiva()) {
            logger.severe("ERRO: REGISTRO ANS DA OPERADORA QUE ENVIOU O ARQUIVO ESTA INATIVO");
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_REGISTRO_ANS_OPERADORA_INATIVA;
            return this.situacaoValidador;
        }
        if (!this.validaCnpjANSInformado(cabecalho)) {
            logger.severe("ERRO: CNPJ DA ANS NAO INFORMADO NO CABECALHO");
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_CNPJ_ANS_NAO_INFORMADO;
            return this.situacaoValidador;
        }
        if (!this.validaCnpjANSCorreto(cabecalho)) {
            logger.severe("ERRO: CNPJ DA ANS INFORMADO NO CABECALHO ESTA INCORRETO");
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_CABECALHO_CNPJ_ANS_INCORRETO;
            return this.situacaoValidador;
        }
        if (!this.validaHash(arquivo)) {
            logger.severe("ERRO: HASH DO CONTEUDO DA MENSAGEM ESTA INCORRETO");
            this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.ERRO_EPILOGO_HASH_INVALIDO;
            return this.situacaoValidador;
        }
        this.situacaoValidador = SituacaoProcessamentoArquivoRecebido.AGUARDANDO_PROCESSAMENTO;
        this.arquivoValido = Boolean.TRUE;
        return this.situacaoValidador;
    }

    public boolean validaXsd(final String xml) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        SAXParser parser = null;
        try {
            factory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource("http://www.ans.gov.br/padroes/sib/schemas/sib.xsd")}));
            parser = factory.newSAXParser();
        }
        catch (Exception se) {
            logger.severe("ERRO NO XSD : " + se.getMessage());
            throw se;
        }
        XMLReader reader = parser.getXMLReader();
        reader.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                logger.severe("AVISO: " + e.getMessage());
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                logger.severe("XSD INVALIDO: " + xml + ". ERRO ENCONTRADO: " + e.getMessage());
                throw e;
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                logger.severe("ERRO FATAL : " + e.getMessage());
                throw e;
            }
        });
        reader.parse(new InputSource(xml));
        logger.info("XSD VALIDO: " + xml);
        return true;
    }

    private boolean validaRegistroANSInformado(Cabecalho cabecalho) {
        return cabecalho.getOrigem().getRegistroANS() != null;
    }

    private boolean validaCnpjANSInformado(Cabecalho cabecalho) {
        return cabecalho.getDestino().getCnpj() != null;
    }

    private boolean validaCnpjANSCorreto(Cabecalho cabecalho) {
        return "03589068000146".equals(cabecalho.getDestino().getCnpj());
    }

    private boolean validaVersaoPadrao(Cabecalho cabecalho) {
        return "1.0".equals(cabecalho.getVersaoPadrao());
    }

    private boolean validaRegistroANSCoerenteArquivo(String registroANS, Cabecalho cabecalho) {
        return registroANS != null && registroANS.equals(cabecalho.getOrigem().getRegistroANS());
    }

    private boolean validaRegistroANSOperadoraAtiva() {
        return true;
    }

    @Override
    public void reset() {
        this.arquivoValido = Boolean.FALSE;
        this.QtdRegistros = 0L;
    }

    @Override
    public boolean isArquivoValidado() {
        return this.arquivoValido;
    }

    @Override
    public Mensagem validaArquivoXml(Mensagem mensagem) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MensagemSIB getArquivoValidado() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean validaHash(File arquivo) throws Exception {
        String[] tags = new String[]{"epilogo"};
        XMLHash.getContentHashMD5(arquivo, tags, "ISO-8859-1");
        return XMLHash.isValidHash();
    }

    static {
        try {
            logger.setUseParentHandlers(true);
            logger.setLevel(Level.ALL);
            logger.addHandler(new AppletFileHandler());
        }
        catch (Exception ex) {
            logger.addHandler(new ConsoleHandler());
        }
    }
}

