/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sibxml.validador.xml;

import br.gov.ans.sibxml.constantes.Constantes;
import br.gov.ans.sibxml.dominio.common.SituacaoProcessamentoArquivoRecebido;
import br.gov.ans.sibxml.util.AppletFileHandler;
import br.gov.ans.sibxml.validador.xml.Mensagem;
import br.gov.ans.sibxml.validador.xml.ValidadorXML;
import br.gov.ans.sibxml.validador.xml.XMLParser;
import br.gov.ans.sibxml.validador.xml.XStreamXMLParser;
import br.gov.ans.sibxml.validador.xml.entrada.Cabecalho;
import br.gov.ans.sibxml.validador.xml.entrada.Epilogo;
import br.gov.ans.sibxml.validador.xml.entrada.MensagemSIB;
import java.io.FileNotFoundException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidadorXMLImpl
implements ValidadorXML {
    private static final Logger logger = Logger.getLogger(ValidadorXMLImpl.class.getName());
    private XMLParser xmlParser;
    private MensagemSIB arquivoValidado;

    public ValidadorXMLImpl(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
    }

    public ValidadorXMLImpl() {
        this.xmlParser = new XStreamXMLParser();
    }

    public boolean validaArquivoXml(String mensagem) throws Exception {
        return Boolean.TRUE;
    }

    @Override
    public Mensagem validaArquivoXml(Mensagem mensagem) throws Exception {
        MensagemSIB mensagemSIB;
        logger.info(String.format("Processo de valida\u00e7\u00e3o iniciado para %s", mensagem.getPathArquivoXML()));
        try {
            mensagemSIB = this.getXmlParser().parseMensagemSIB(mensagem.getPathArquivoXML());
        }
        catch (FileNotFoundException fnfe) {
            mensagem.setProcessado(false);
            mensagem.setValido(false);
            logger.severe(String.format("Nao foi possivel encontrar o arquivo no caminho especificado (%s)", mensagem.getPathArquivoXML()));
            return mensagem;
        }
        logger.info("Arquivo encontrado.");
        long registros = 0L;
        if (mensagemSIB.getMensagem() != null && mensagemSIB.getMensagem().getOperadoraParaANS() != null && mensagemSIB.getMensagem().getOperadoraParaANS().getBeneficiarios() != null) {
            registros = mensagemSIB.getMensagem().getOperadoraParaANS().getBeneficiarios().size();
        }
        if (mensagemSIB.getCabecalho() == null || mensagemSIB.getEpilogo() == null || registros < 1L) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Nao foi possivel recuperar as informacoes de cabecalho e epilogo do XML.");
            return mensagem;
        }
        logger.info("Cabe\u00e7alho e ep\u00edlogo presentes.");
        if (!this.validaVersaoPadrao(mensagemSIB.getCabecalho())) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe(String.format("Vers\u00e3o incorreta de cabe\u00e7alho: %", mensagemSIB.getCabecalho().getVersaoPadrao()));
            return mensagem;
        }
        logger.info("Cabe\u00e7alho em vers\u00e3o correta.");
        if (!this.validaRegistroANSInformado(mensagemSIB.getCabecalho())) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Registro ANS n\u00e3o informado");
            return mensagem;
        }
        logger.info("Registro ANS informado.");
        if (!this.validaRegistroANSCoerenteArquivo(mensagem.getNumeroRegistroANS(), mensagemSIB.getCabecalho())) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe(String.format("Registro ANS incoerente com o encontrado no cabe\u00e7alho do arquivo (deveria ser %s, mas %s foi encontrado no arquivo)", mensagem.getNumeroRegistroANS(), mensagemSIB.getCabecalho().getOrigem().getRegistroANS()));
            return mensagem;
        }
        logger.info("Registro ANS correto.");
        if (!this.validaRegistroANSOperadoraAtiva()) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Erro de cabe\u00e7alho: registro da operadora inativo");
            return mensagem;
        }
        logger.info("Registro de operadora ativo.");
        if (!this.validaCnpjANSInformado(mensagemSIB.getCabecalho())) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Erro de cabe\u00e7alho: CNPJ n\u00e3o informado.");
            return mensagem;
        }
        logger.info("CNPJ Informado.");
        if (!this.validaCnpjANSCorreto(mensagemSIB.getCabecalho())) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Erro de cabe\u00e7alho: CNPJ da ANS incorreto.");
            return mensagem;
        }
        logger.info("CNPJ correto.");
        if (!this.validaHash(mensagemSIB.getEpilogo(), mensagem.getNumeroRegistroANS())) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Erro de cabe\u00e7alho: Hash Inv\u00e1lido.");
            return mensagem;
        }
        logger.info("Hash v\u00e1lido.");
        if (!this.validaQuantidadeRegistros(registros)) {
            mensagem.setProcessado(true);
            mensagem.setValido(false);
            logger.severe("Quantidade de registros acima da permitida.");
            return mensagem;
        }
        logger.info("Quantidade de registros dentro do especificado.");
        mensagem.setProcessado(true);
        mensagem.setValido(true);
        this.setArquivoValidado(mensagemSIB);
        return mensagem;
    }

    private boolean validaVersaoPadrao(Cabecalho cabecalho) {
        return "1.0".equals(cabecalho.getVersaoPadrao());
    }

    private boolean validaRegistroANSInformado(Cabecalho cabecalho) {
        return cabecalho.getOrigem().getRegistroANS() != null;
    }

    private boolean validaRegistroANSCoerenteArquivo(String registroANS, Cabecalho cabecalho) {
        return registroANS != null && registroANS.equals(cabecalho.getOrigem().getRegistroANS());
    }

    private boolean validaRegistroANSOperadoraAtiva() {
        return true;
    }

    private boolean validaCnpjANSInformado(Cabecalho cabecalho) {
        return cabecalho.getDestino().getCnpj() != null;
    }

    private boolean validaCnpjANSCorreto(Cabecalho cabecalho) {
        return "03589068000146".equals(cabecalho.getDestino().getCnpj());
    }

    private boolean validaHash(Epilogo epilogo, String numeroRegistroANS) {
        return true;
    }

    private boolean validaQuantidadeRegistros(Long quantidadeRegistros) {
        return quantidadeRegistros <= Constantes.MAX_REGISTROS_BENEFICIARIOS;
    }

    XMLParser getXmlParser() {
        return this.xmlParser;
    }

    void setXmlParser(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
    }

    @Override
    public MensagemSIB getArquivoValidado() {
        return this.arquivoValidado;
    }

    private void setArquivoValidado(MensagemSIB arquivoValidado) {
        this.arquivoValidado = arquivoValidado;
    }

    @Override
    public void reset() {
        this.arquivoValidado = null;
    }

    @Override
    public SituacaoProcessamentoArquivoRecebido validaArquivoXml(String pathArquivoXml, String RegistroANS) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Long getQtdRegistros() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isArquivoValidado() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            logger.setUseParentHandlers(true);
            logger.setLevel(Level.ALL);
            logger.addHandler(new AppletFileHandler());
        }
        catch (Exception ex) {
            logger.addHandler(new ConsoleHandler());
        }
    }
}

