/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.sibxml.converter;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeConverter
implements Converter {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public boolean canConvert(Class clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Date date = (Date)value;
        writer.setValue(this.sdf.format(date));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Date date = null;
        String dateString = reader.getValue().substring(0, 19);
        try {
            date = this.sdf.parse(dateString);
        }
        catch (ParseException e) {
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
        return date;
    }
}

