/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.diops.financeiro.util;

import br.gov.ans.diops.financeiro.resources.Config;
import br.gov.ans.diops.financeiro.util.MessageUtils;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlUtils {
    private static final Logger logger = Logger.getLogger(XmlUtils.class.getName());

    public static String getXmlContent(Source f) throws Exception {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(f, result);
            if (((StreamSource)f).getInputStream() != null) {
                ((StreamSource)f).getInputStream().reset();
            }
            return writer.toString();
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            throw new Exception(MessageUtils.getErro("xml.transform", new Object[0]));
        }
    }

    public static String getXSDAddressByAno(int ano) throws Exception {
        String xsd = Config.getMensagemFromConfig("xsd." + ano);
        if (xsd != null && xsd.trim().length() > 0) {
            return xsd;
        }
        throw new Exception(MessageUtils.getErro("xsd.not.found", new Object[0]));
    }

    public static String getXSDAddressByAnoMensal(int ano) throws Exception {
        String xsd = Config.getMensagemFromConfig("xsd." + ano + ".mensal");
        if (xsd != null && xsd.trim().length() > 0) {
            return xsd;
        }
        throw new Exception(MessageUtils.getErro("xsd.not.found", new Object[0]));
    }
}

