/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.diops.financeiro.wrapper;

import br.gov.ans.diops.financeiro.handler.XsdErrorHandler;
import br.gov.ans.diops.financeiro.util.XmlUtils;
import br.gov.ans.diops.financeiro.wrapper.XmlWrapper;
import br.gov.ans.ws.diops.financeiro.v2016.DiopsException;
import br.gov.ans.ws.diops.financeiro.v2016.WsException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

public class DiopsXmlWrapper
extends XmlWrapper {
    private static final Logger LOGGER = Logger.getLogger(DiopsXmlWrapper.class.getName());

    public DiopsXmlWrapper(Source source) {
        super(source);
    }

    public int getAno() throws Exception {
        if (this.getXml().contains("<ano>2016</ano>")) {
            return 2016;
        }
        if (this.getXml().contains("<ano>2017</ano>")) {
            return 2017;
        }
        if (this.getXml().contains("<ano>2018</ano>")) {
            return 2018;
        }
        if (this.getXml().contains("<ano>2019</ano>")) {
            return 2019;
        }
        if (this.getXml().contains("<ano>2020</ano>")) {
            return 2019;
        }
        if (this.getXml().contains("<ano>2021</ano>")) {
            return 2021;
        }
        if (this.getXml().contains("<ano>2022</ano>")) {
            return 2022;
        }
        if (this.getXml().contains("<ano>2023</ano>")) {
            return 2023;
        }
        if (this.getXml().contains("<ano>2024</ano>")) {
            return 2024;
        }
        if (this.getXml().contains("<ano>2025</ano>")) {
            return 2025;
        }
        return 0;
    }

    public void validarContraXSD() throws DiopsException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            if (this.diopsMensal()) {
                schema = factory.newSchema(new URL(XmlUtils.getXSDAddressByAnoMensal(this.getAno())));
            } else if (!this.diopsMensal()) {
                schema = factory.newSchema(new URL(XmlUtils.getXSDAddressByAno(this.getAno())));
            }
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new XsdErrorHandler(this.getAno()));
            validator.validate(this.source);
        }
        catch (Exception e) {
            throw new DiopsException(e.getMessage(), new WsException());
        }
    }

    public boolean diopsMensal() {
        try {
            if (!this.getXml().contains("<lucrosPrejuizos>")) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
        return false;
    }
}

