/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.diops.financeiro;

import br.gov.ans.diops.financeiro.api.DiopsFinanceiroClient;
import br.gov.ans.diops.financeiro.util.InstanceListener;
import br.gov.ans.diops.financeiro.util.InstanceManager;
import br.gov.ans.diops.financeiro.util.MessageUtils;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;

public class DiopsFinanceiroClientGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DiopsFinanceiroClientGUI.class.getName());
    private JButton btArquivo;
    private JButton btEnviar;
    private JButton btCancelar;
    private JToggleButton tgProxy;
    private JLabel lbUsuario;
    private JLabel lbSenha;
    private JLabel lbArquivo;
    private JLabel lbServidor;
    private JLabel lbPorta;
    private JLabel lbUsuarioP;
    private JLabel lbSenhaP;
    private JPanel pLogin;
    private JPanel pArquivo;
    private JPanel pProxy;
    private JPasswordField tfSenha;
    private JPasswordField tfSenhaP;
    private JTextField tfUsuario;
    private JTextField tfArquivo;
    private JTextField tfServidor;
    private JTextField tfPorta;
    private JTextField tfUsuarioP;
    private File lastpath = null;
    private File diopsFile = null;
    private boolean proxyEnable = false;

    public DiopsFinanceiroClientGUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.pLogin = new JPanel();
        this.tfSenha = new JPasswordField();
        this.lbUsuario = new JLabel();
        this.lbSenha = new JLabel();
        this.tfUsuario = new JTextField();
        this.pArquivo = new JPanel();
        this.tfArquivo = new JTextField();
        this.lbArquivo = new JLabel();
        this.btArquivo = new JButton();
        this.pProxy = new JPanel();
        this.tgProxy = new JToggleButton();
        this.lbServidor = new JLabel();
        this.lbPorta = new JLabel();
        this.lbUsuarioP = new JLabel();
        this.lbSenhaP = new JLabel();
        this.tfServidor = new JTextField();
        this.tfPorta = new JTextField();
        this.tfUsuarioP = new JTextField();
        this.tfSenhaP = new JPasswordField();
        this.btEnviar = new JButton();
        this.btCancelar = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle(MessageUtils.getGui("title.window", new Object[0]));
        this.pLogin.setBorder(BorderFactory.createTitledBorder(MessageUtils.getGui("title.panel.login", new Object[0])));
        this.lbUsuario.setText(MessageUtils.getGui("label.usuario", new Object[0]));
        this.lbSenha.setText(MessageUtils.getGui("label.senha", new Object[0]));
        GroupLayout pLoginLayout = new GroupLayout(this.pLogin);
        this.pLogin.setLayout(pLoginLayout);
        pLoginLayout.setHorizontalGroup(pLoginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pLoginLayout.createSequentialGroup().addContainerGap().addComponent(this.lbUsuario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfUsuario).addGap(18, 18, 18).addComponent(this.lbSenha).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSenha, -2, 100, -2).addContainerGap()));
        pLoginLayout.setVerticalGroup(pLoginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pLoginLayout.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).addGroup(pLoginLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLoginLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbUsuario).addComponent(this.tfUsuario, -2, -1, -2)).addGroup(pLoginLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSenha, -2, -1, -2).addComponent(this.lbSenha))).addContainerGap()));
        this.pArquivo.setBorder(BorderFactory.createTitledBorder(MessageUtils.getGui("title.panel.upload", new Object[0])));
        this.lbArquivo.setText(MessageUtils.getGui("label.arquivo", new Object[0]));
        this.tfArquivo.setEditable(false);
        this.btArquivo.setText(MessageUtils.getGui("buttton.upload", new Object[0]));
        this.btArquivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fileChooser = DiopsFinanceiroClientGUI.this.fileChooserXml();
                int returnValue = fileChooser.showOpenDialog(null);
                if (returnValue == 0) {
                    DiopsFinanceiroClientGUI.this.diopsFile = fileChooser.getSelectedFile();
                    DiopsFinanceiroClientGUI.this.lastpath = new File(DiopsFinanceiroClientGUI.this.diopsFile.getAbsolutePath().substring(0, DiopsFinanceiroClientGUI.this.diopsFile.getAbsolutePath().lastIndexOf(File.separator)));
                    DiopsFinanceiroClientGUI.this.tfArquivo.setText(DiopsFinanceiroClientGUI.this.diopsFile.getAbsolutePath());
                }
            }
        });
        GroupLayout pArquivoLayout = new GroupLayout(this.pArquivo);
        this.pArquivo.setLayout(pArquivoLayout);
        pArquivoLayout.setHorizontalGroup(pArquivoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pArquivoLayout.createSequentialGroup().addContainerGap().addComponent(this.lbArquivo).addGap(13, 13, 13).addComponent(this.tfArquivo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btArquivo).addContainerGap()));
        pArquivoLayout.setVerticalGroup(pArquivoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pArquivoLayout.createSequentialGroup().addContainerGap().addGroup(pArquivoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfArquivo, -2, -1, -2).addComponent(this.lbArquivo).addComponent(this.btArquivo)).addContainerGap(14, Short.MAX_VALUE)));
        this.pProxy.setBorder(BorderFactory.createTitledBorder(MessageUtils.getGui("title.panel.proxy", new Object[0])));
        this.tgProxy.setText(MessageUtils.getGui("toggleButton.off", new Object[0]));
        this.tgProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                DiopsFinanceiroClientGUI.this.proxyEnable = abstractButton.getModel().isSelected();
                DiopsFinanceiroClientGUI.this.tgProxy.setText(DiopsFinanceiroClientGUI.this.proxyEnable ? MessageUtils.getGui("toggleButton.on", new Object[0]) : MessageUtils.getGui("toggleButton.off", new Object[0]));
                DiopsFinanceiroClientGUI.this.tfServidor.setEnabled(DiopsFinanceiroClientGUI.this.proxyEnable);
                DiopsFinanceiroClientGUI.this.tfPorta.setEnabled(DiopsFinanceiroClientGUI.this.proxyEnable);
                DiopsFinanceiroClientGUI.this.tfUsuarioP.setEnabled(DiopsFinanceiroClientGUI.this.proxyEnable);
                DiopsFinanceiroClientGUI.this.tfSenhaP.setEnabled(DiopsFinanceiroClientGUI.this.proxyEnable);
            }
        });
        this.lbServidor.setText(MessageUtils.getGui("label.servidor", new Object[0]));
        this.lbPorta.setText(MessageUtils.getGui("label.porta", new Object[0]));
        this.lbUsuarioP.setText(MessageUtils.getGui("label.usuario", new Object[0]));
        this.lbSenhaP.setText(MessageUtils.getGui("label.senha", new Object[0]));
        this.tfServidor.setEnabled(false);
        this.tfPorta.setEnabled(false);
        this.tfUsuarioP.setEnabled(false);
        this.tfSenhaP.setEnabled(false);
        GroupLayout pProxyLayout = new GroupLayout(this.pProxy);
        this.pProxy.setLayout(pProxyLayout);
        pProxyLayout.setHorizontalGroup(pProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pProxyLayout.createSequentialGroup().addContainerGap().addGroup(pProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pProxyLayout.createSequentialGroup().addGroup(pProxyLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pProxyLayout.createSequentialGroup().addComponent(this.lbUsuarioP).addGap(13, 13, 13).addComponent(this.tfUsuarioP, -1, 138, Short.MAX_VALUE).addGap(15, 15, 15).addComponent(this.lbSenhaP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSenhaP, -2, 100, -2)).addGroup(pProxyLayout.createSequentialGroup().addComponent(this.lbServidor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfServidor).addGap(18, 18, 18).addComponent(this.lbPorta).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfPorta, -2, 40, -2))).addGap(14, 14, 14)).addGroup(pProxyLayout.createSequentialGroup().addComponent(this.tgProxy).addContainerGap(-1, Short.MAX_VALUE)))));
        pProxyLayout.setVerticalGroup(pProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pProxyLayout.createSequentialGroup().addContainerGap().addComponent(this.tgProxy).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbServidor).addComponent(this.lbPorta).addComponent(this.tfServidor, -2, -1, -2).addComponent(this.tfPorta, -2, -1, -2)).addGap(18, 18, 18).addGroup(pProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbUsuarioP).addComponent(this.lbSenhaP).addComponent(this.tfUsuarioP, -2, -1, -2).addComponent(this.tfSenhaP, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btEnviar.setText(MessageUtils.getGui("buttton.enviar", new Object[0]));
        this.btEnviar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiopsFinanceiroClientGUI.this.enviar();
            }
        });
        this.btCancelar.setText(MessageUtils.getGui("buttton.cancelar", new Object[0]));
        this.btCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = JOptionPane.showConfirmDialog(DiopsFinanceiroClientGUI.this.btCancelar.getRootPane(), "Deseja realmente sair?", "Fechar aplica\u00e7\u00e3o", 0);
                if (i == 0) {
                    System.exit(0);
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pLogin, -1, -1, Short.MAX_VALUE).addComponent(this.pArquivo, -1, -1, Short.MAX_VALUE).addComponent(this.pProxy, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btCancelar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btEnviar))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pLogin, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pArquivo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pProxy, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btEnviar).addComponent(this.btCancelar)).addContainerGap()));
        this.pack();
    }

    private JFileChooser fileChooserXml() {
        JFileChooser arquivo = new JFileChooser();
        arquivo.setMultiSelectionEnabled(false);
        arquivo.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".xml") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return MessageUtils.getGui("desc.formato.upload", new Object[0]);
            }
        });
        arquivo.setDialogTitle(MessageUtils.getGui("title.upload", new Object[0]));
        if (this.lastpath != null) {
            arquivo.setCurrentDirectory(this.lastpath);
        }
        return arquivo;
    }

    private void enviar() {
        String err = this.verificarCampos();
        if (err == null) {
            DiopsFinanceiroClient ws = new DiopsFinanceiroClient();
            if (this.proxyEnable) {
                String usuario = this.tfUsuarioP.getText() == null || this.tfUsuarioP.getText().isEmpty() ? null : this.tfUsuarioP.getText();
                String senha = this.tfSenhaP.getPassword() == null || this.tfSenhaP.getPassword().length == 0 ? null : String.valueOf(this.tfSenhaP.getPassword());
                ws.ativarProxy(this.tfServidor.getText(), this.tfPorta.getText(), usuario, senha);
            } else {
                ws.desativarProxy();
            }
            try {
                String r = ws.enviar(this.diopsFile.getAbsolutePath(), this.tfUsuario.getText(), String.valueOf(this.tfSenha.getPassword()));
                JOptionPane.showMessageDialog(this, r, MessageUtils.getGui("title.envio.sucesso", new Object[0]), 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), MessageUtils.getGui("title.envio.erro", new Object[0]), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, err, MessageUtils.getGui("title.envio.erro", new Object[0]), 0);
        }
    }

    private String verificarCampos() {
        if (this.tfUsuario.getText() == null || this.tfUsuario.getText().isEmpty()) {
            return MessageUtils.getErro("campo.usuario", new Object[0]);
        }
        if (this.tfSenha.getPassword() == null) {
            return MessageUtils.getErro("campo.senha", new Object[0]);
        }
        if (this.diopsFile == null) {
            return MessageUtils.getErro("campo.upload", new Object[0]);
        }
        if (this.proxyEnable) {
            if (this.tfServidor.getText() == null || this.tfServidor.getText().isEmpty()) {
                return MessageUtils.getErro("campo.proxy.servidor", new Object[0]);
            }
            if (this.tfPorta.getText() == null || this.tfPorta.getText().isEmpty()) {
                return MessageUtils.getErro("campo.proxy.porta", new Object[0]);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        if (!InstanceManager.registerInstance()) {
            logger.warning(MessageUtils.getErro("app.run", new Object[0]));
            System.exit(0);
        }
        InstanceManager.setListener(new InstanceListener(){

            @Override
            public void newInstanceCreated() {
                JOptionPane.showMessageDialog(null, MessageUtils.getErro("app.run", new Object[0]));
            }
        });
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        catch (InstantiationException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        catch (IllegalAccessException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        catch (UnsupportedLookAndFeelException ex) {
            logger.severe(ex.getLocalizedMessage());
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DiopsFinanceiroClientGUI().setVisible(true);
            }
        });
    }
}

