unit uGerarDadosFinanceiros;

interface

uses SysUtils, WinTypes, WinProcs, Messages, Windows, UUtilXML, Mask, math,
     Variants, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls;

type

  EDadosFinanceiros = class(Exception);

  function GerarDadosF(dir: String): Boolean;

  procedure CriaXML(var xml: TXMLGenerator);
  procedure MontaIdentificacao(var xml: TXMLGenerator);
  procedure MontaBalancete( var xml: TXMLGenerator; var codigoConta : string; var linha: integer; var cont : Integer);
  procedure MontaFluxoCaixa(var xml: TXMLGenerator);
  procedure MontaSaldoProvEventosSinistrosLiq(var xml: TXMLGenerator);
  procedure MontaLucrosPrejuizos(var xml: TXMLGenerator);
  procedure MontaIntercambioEventual(var xml: TXMLGenerator; var regANSInter : string; var linha: integer; var cont : Integer);
  procedure MontaCoberturaAssistencial(var xml: TXMLGenerator);
  procedure MontaContaCorrenteCoop(var xml: TXMLGenerator);
  procedure MontaTributoPassivo(var xml: TXMLGenerator);

  procedure MontaIdadeSaldo2016(var xml: TXMLGenerator);
  procedure MontaMovProvEventos2016(movProvEventos: Variant; var xml: TXMLGenerator);
  procedure MontaContraprestacaoReceber2016(var xml: TXMLGenerator);
  procedure MontaContraprestacoesRepassar2016(var xml: TXMLGenerator);
  procedure MontaContratosEstipulados2016(var xml: TXMLGenerator);
  procedure MontaAtivosGarantidores2016(ativos: Variant; var xml: TXMLGenerator; proprio: string);

  function LeftMask(const Value: string; ALength: Word): string;
  function LeftMaskContaBalancete(const Value: string; ALength: Word): string;
  function ChangeMaskFormat(const Value, OldChar, NewChar: string): string;
  function BuidFormatation(ALength: Word): string;

implementation

uses
  Util, StrUtils, Shellapi, UMyMessageDlg, uCarregarDados;

function GerarDadosF(dir: String): Boolean;
var
  xml           : TXMLGenerator;
  linha, cont   : Integer;
  codigoConta, regANSInter   : string;

begin
  try
    Result := False;
    CriaXML(xml);
    try
      MontaIdentificacao(xml);

      if (uppercase(DadosCadastrais[26, 2]) = 'ADMBN') then
      begin
        xml.AddNodeAttribute('financeiro', false, '', 'xsi:type', 'administradora');
          MontaBalancete( xml, codigoConta, linha, cont);
        xml.LevelUpNode('financeiro');
          MontaAtivosGarantidores2016(AtivosGarantidoresProprios2016, xml, 'S');
        xml.LevelUpNode('financeiro');
          MontaFluxoCaixa(xml);
        xml.LevelUpNode('financeiro');
          MontaIdadeSaldo2016(xml);
        xml.LevelUpNode('financeiro');
          MontaLucrosPrejuizos(xml);
        xml.LevelUpNode('financeiro');
          MontaContratosEstipulados2016(xml);
        xml.LevelUpNode('financeiro');
          MontaContraprestacoesRepassar2016(xml);
        xml.LevelUpNode('financeiro');
      end
      else
      if (uppercase(DadosCadastrais[26, 2]) = 'COOPO') or (uppercase(DadosCadastrais[27, 2]) = 'COOPM') then
      begin
        xml.AddNodeAttribute('financeiro', false, '', 'xsi:type', 'cooperativa');
          MontaBalancete( xml, codigoConta, linha, cont);
        xml.LevelUpNode('financeiro');
          MontaAtivosGarantidores2016(AtivosGarantidoresProprios2016, xml, 'S');
        xml.LevelUpNode('financeiro');
          MontaFluxoCaixa(xml);
        xml.LevelUpNode('financeiro');
          MontaIdadeSaldo2016(xml);
        xml.LevelUpNode('financeiro');
          MontaLucrosPrejuizos(xml);
        xml.LevelUpNode('financeiro');
          MontaSaldoProvEventosSinistrosLiq(xml);
        xml.LevelUpNode('financeiro');
          MontaIntercambioEventual(xml, regANSInter, linha, cont);
        xml.LevelUpNode('financeiro');
          MontaMovProvEventos2016(MovProvEventos2016, xml);
        xml.LevelUpNode('financeiro');
          MontaContraprestacaoReceber2016(xml);
        xml.LevelUpNode('financeiro');
          MontaCoberturaAssistencial(xml);
        xml.LevelUpNode('financeiro');
          MontaContaCorrenteCoop (xml);
        xml.LevelUpNode('financeiro');
          MontaTributoPassivo (xml);
      end
      else
      begin
        xml.AddNodeAttribute('financeiro', false, '', 'xsi:type', 'padrao');
          MontaBalancete( xml, codigoConta, linha, cont);
        xml.LevelUpNode('financeiro');
          MontaAtivosGarantidores2016(AtivosGarantidoresProprios2016, xml, 'S');
        xml.LevelUpNode('financeiro');
          MontaFluxoCaixa(xml);
        xml.LevelUpNode('financeiro');
          MontaIdadeSaldo2016(xml);
        xml.LevelUpNode('financeiro');
          MontaLucrosPrejuizos(xml);
        xml.LevelUpNode('financeiro');
          MontaSaldoProvEventosSinistrosLiq(xml);
        xml.LevelUpNode('financeiro');
          MontaIntercambioEventual(xml, regANSInter, linha, cont);
        xml.LevelUpNode('financeiro');
          MontaMovProvEventos2016(MovProvEventos2016, xml);
        xml.LevelUpNode('financeiro');
          MontaContraprestacaoReceber2016(xml);
        xml.LevelUpNode('financeiro');
          MontaCoberturaAssistencial(xml);    
      end;

      xml.LevelUpNode('financeiro');
      xml.LevelUpNode('diops');

      xml.SaveToFile(dir);
      Result := True;
    except
      on E: Exception do
      begin
        raise EDadosFinanceiros.Create('No foi possvel gerar o arquivo XML do DIOPS Financeiro.' + chr(13) + e.Message);
        Exit;
      end;
    end;
  finally
    xml.Free;
  end;
end;

procedure CriaXML(var xml: TXMLGenerator);
begin

  xml := TXMLGenerator.Create('diops', '', '<diops xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" ' +
                              'xmlns="http://www.ans.gov.br/ws/diops/financeiro/schema/v2016"'                 +
                              ' xsi:schemaLocation="http://www.ans.gov.br/ws/diops/financeiro/schema/v2016 Diops2016.xsd">');

end;

procedure MontaIdentificacao(var xml: TXMLGenerator);
var
  ano, mes: string;

begin
  //N Identificador Inicio -----------------------------------------------

  xml.AddNode('identificacao', false, '');
  xml.AddText('registro', LeftMask(DadosCadastrais[5, 2], 6));
  xml.AddText('cnpj', LeftMask(VarToStr(DadosCadastrais[6, 2]), 14));

  ShortDateFormat := 'yyyy-mm-dd';

  ano := Copy(retornaData(DadosCadastrais[3, 2]), 1, 4);
  mes := Copy(retornaData(DadosCadastrais[3, 2]), 6, 2);

  //Verifica se o campo est vazio.
  if VarToStr(DadosCadastrais[3, 2]) <> '' then
    xml.AddText('ano', ano)
  else
    raise EGenerica.Create('No foi definido o incio do perodo.');

  case StrToInt(mes) of
    1, 2, 3:
      xml.AddText('trimestre', '1');
    4, 5, 6:
      xml.AddText('trimestre', '2');
    7, 8, 9:
      xml.AddText('trimestre', '3');
    10, 11, 12:
      xml.AddText('trimestre', '4');
  end;

  xml.LevelUpNode('diops');
end;

procedure MontaBalancete(var xml: TXMLGenerator; var codigoConta : string; var linha : integer; var cont : Integer);
begin
  //N Balancete Inicio -------------------------------------------------------------------------------------
  xml.AddNode('balancete', false, '');

  linha := 4;
  cont  := 0;

  while (trim(VarToStr(BalanceteAtivo[linha, 1])) <> '') or (trim(VarToStr(BalanceteAtivo[linha + 1, 1])) <> '') do
  begin
    //BALANCETE ATIVO -----------------------------------------------------------------------------------------
    xml.AddNode('ativo', false, '');

    if trim(VarToStr(BalanceteAtivo[linha, 1])) = '' then
      inc(linha);

    codigoConta := VarToStr(BalanceteAtivo[linha, 1]);

    if length(codigoConta) > 20 then
      raise EGenerica.Create('A conta de ativo "' + codigoConta + '" possui mais de 20 caracteres.' + chr(13) + 'O nmero mximo de caracteres para as contas do balancete  20.');

    xml.AddText('conta', codigoConta);

    if VarToStr(BalanceteAtivo[linha, 3]) <> '' then
      xml.AddNumber('saldoInicial', ChangeMaskFormat(VarToStr(BalanceteAtivo[linha, 3]), ',', '.'))
    else
      xml.AddText('saldoInicial', '0.0');

    if VarToStr(BalanceteAtivo[linha, 4]) <> '' then
      xml.AddNumber('debitos', ChangeMaskFormat(VarToStr(BalanceteAtivo[linha, 4]), ',', '.'))
    else
      xml.AddText('debitos', '0.0');

    if VarToStr(BalanceteAtivo[linha, 5]) <> '' then
      xml.AddNumber('creditos', ChangeMaskFormat(VarToStr(BalanceteAtivo[linha, 5]), ',', '.'))
    else
      xml.AddText('creditos', '0.0');

    if VarToStr(BalanceteAtivo[linha, 6]) <> '' then
      xml.AddNumber('saldoFinal', ChangeMaskFormat(VarToStr(BalanceteAtivo[linha, 6]), ',', '.'))
    else
      xml.AddText('saldoFinal', '0.0');

    //Para contas com cdigo maior que nove dgitos a descrio deve ser includa
    if length(codigoConta) > 9 then
      xml.AddText('descricao', VarToStr(BalanceteAtivo[linha, 2]));

    xml.LevelUpNode('balancete');
    inc(cont);
    inc(linha);
  end;

  //Verifica se o balancete do Ativo est vazio, se estiver no deixa continuar.
  if cont <= 0 then
    raise EGenerica.Create('O balancete do Ativo no pode estar vazio.' + chr(13) + 'Deve ser preenchido conforme novo Plano de Contas publicado para vigncia 2016.');

  linha := 4;
  cont := 0;

  while (trim(VarToStr(BalancetePassivo[linha, 1])) <> '') or (trim(VarToStr(BalancetePassivo[linha + 1, 1])) <> '') do
  begin
    //BALANCETE PASSIVO ----------------------------------------------------------------------------------------------
    xml.AddNode('passivo', false, '');

    if trim(VarToStr(BalancetePassivo[linha, 1])) = '' then
      inc(linha);

    codigoConta := VarToStr(BalancetePassivo[linha, 1]);

    if length(codigoConta) > 20 then
      raise EGenerica.Create('A conta de passivo "' + codigoConta + '" possui mais de 20 caracteres.' + chr(13) + 'O nmero mximo de caracteres para as contas do balancete  20.');

    xml.AddText('conta', codigoConta);

    if VarToStr(BalancetePassivo[linha, 3]) <> '' then
      xml.AddNumber('saldoInicial', ChangeMaskFormat(VarToStr(BalancetePassivo[linha, 3]), ',', '.'))
    else
      xml.AddText('saldoInicial', '0.0');

    if VarToStr(BalancetePassivo[linha, 4]) <> '' then
      xml.AddNumber('debitos', ChangeMaskFormat(VarToStr(BalancetePassivo[linha, 4]), ',', '.'))
    else
      xml.AddText('debitos', '0.0');

    if VarToStr(BalancetePassivo[linha, 5]) <> '' then
      xml.AddNumber('creditos', ChangeMaskFormat(VarToStr(BalancetePassivo[linha, 5]), ',', '.'))
    else
      xml.AddText('creditos', '0.0');

    if VarToStr(BalancetePassivo[linha, 6]) <> '' then
      xml.AddNumber('saldoFinal', ChangeMaskFormat(VarToStr(BalancetePassivo[linha, 6]), ',', '.'))
    else
      xml.AddText('saldoFinal', '0.0');

    //Para contas com cdigo maior que nove dgitos a descrio deve ser includa
    if length(codigoConta) > 9 then
      xml.AddText('descricao', VarToStr(BalancetePassivo[linha, 2]));

    xml.LevelUpNode('balancete');
    inc(cont);
    inc(linha);
  end;

  //Verifica se o balancete do Passivo est vazio, se estiver no deixa continuar.
  if cont <= 0 then
    raise EGenerica.Create('O balancete do Passivo no pode estar vazio.');

  linha := 4;
  cont := 0;

  while (trim(VarToStr(BalanceteReceita[linha, 1])) <> '') or (trim(VarToStr(BalanceteReceita[linha + 1, 1])) <> '') do
  begin
    //BALANCETE RECEITA -----------------------------------------------------------------------------------------------
    xml.AddNode('receita', false, '');

    if trim(VarToStr(BalanceteReceita[linha, 1])) = '' then
      inc(linha);

    codigoConta := VarToStr(BalanceteReceita[linha, 1]);

    if length(codigoConta) > 20 then
      raise EGenerica.Create('A conta de receita "' + codigoConta + '" possui mais de 20 caracteres.' + chr(13) + 'O nmero mximo de caracteres para as contas do balancete  20.');

    xml.AddText('conta', codigoConta);

    if VarToStr(BalanceteReceita[linha, 3]) <> '' then
      xml.AddNumber('saldoInicial', ChangeMaskFormat(VarToStr(BalanceteReceita[linha, 3]), ',', '.'))
    else
      xml.AddText('saldoInicial', '0.0');
    if VarToStr(BalanceteReceita[linha, 4]) <> '' then
      xml.AddNumber('debitos', ChangeMaskFormat(VarToStr(BalanceteReceita[linha, 4]), ',', '.'))
    else
      xml.AddText('debitos', '0.0');
    if VarToStr(BalanceteReceita[linha, 5]) <> '' then
      xml.AddNumber('creditos', ChangeMaskFormat(VarToStr(BalanceteReceita[linha, 5]), ',', '.'))
    else
      xml.AddText('creditos', '0.0');
    if VarToStr(BalanceteReceita[linha, 6]) <> '' then
      xml.AddNumber('saldoFinal', ChangeMaskFormat(VarToStr(BalanceteReceita[linha, 6]), ',', '.'))
    else
      xml.AddText('saldoFinal', '0.0');

    //Para contas com cdigo maior que nove dgitos a descrio deve ser includa
    if length(codigoConta) > 9 then
      xml.AddText('descricao', VarToStr(BalanceteReceita[linha, 2]));

    xml.LevelUpNode('balancete');
    inc(cont);
    inc(linha);
  end;

  //Verifica se o balancete da Receita est vazio, se estiver no deixa continuar.
  if cont <= 0 then
    raise EGenerica.Create('O balancete da Receita no pode estar vazio.' + chr(13) + 'Deve ser preenchido conforme novo Plano de Contas publicado para vigncia 2016.');

  linha := 4;
  cont := 0;

  while (trim(VarToStr(BalanceteDespesa[linha, 1])) <> '') or (trim(VarToStr(BalanceteDespesa[linha + 1, 1])) <> '') do
  begin
    //BALANCETE DESPESA ----------------------------------------------------------------------------------------
    xml.AddNode('despesa', false, '');
    if trim(VarToStr(BalanceteDespesa[linha, 1])) = '' then
      inc(linha);

    codigoConta := VarToStr(BalanceteDespesa[linha, 1]);

    if length(codigoConta) > 20 then
      raise EGenerica.Create('A conta de despesa "' + codigoConta + '" possui mais de 20 caracteres.' + chr(13) + 'O nmero mximo de caracteres para as contas do balancete  20.');

    xml.AddText('conta', codigoConta);

    if VarToStr(BalanceteDespesa[linha, 3]) <> '' then
      xml.AddNumber('saldoInicial', ChangeMaskFormat(VarToStr(BalanceteDespesa[linha, 3]), ',', '.'))
    else
      xml.AddText('saldoInicial', '0.0');

    if VarToStr(BalanceteDespesa[linha, 4]) <> '' then
      xml.AddNumber('debitos', ChangeMaskFormat(VarToStr(BalanceteDespesa[linha, 4]), ',', '.'))
    else
      xml.AddText('debitos', '0.0');

    if VarToStr(BalanceteDespesa[linha, 5]) <> '' then
      xml.AddNumber('creditos', ChangeMaskFormat(VarToStr(BalanceteDespesa[linha, 5]), ',', '.'))
    else
      xml.AddText('creditos', '0.0');

    if VarToStr(BalanceteDespesa[linha, 6]) <> '' then
      xml.AddNumber('saldoFinal', ChangeMaskFormat(VarToStr(BalanceteDespesa[linha, 6]), ',', '.'))
    else
      xml.AddText('saldoFinal', '0.0');

    //Para contas com cdigo maior que nove dgitos a descrio deve ser includa
    if length(codigoConta) > 9 then
      xml.AddText('descricao', VarToStr(BalanceteDespesa[linha, 2]));

    xml.LevelUpNode('balancete');
    inc(cont);
    inc(linha);
  end;

  //Verifica se o balancete de Despesa est vazio, se estiver no deixa continuar.
  if cont <= 0 then
    raise EGenerica.Create('O balancete de Despesa no pode estar vazio.' + chr(13) + 'Deve ser preenchido conforme novo Plano de Contas publicado para vigncia 2016.');

  //N Balancete Fim -------------------------------------------------------------------------------------------
end;


procedure MontaAtivosGarantidores2016(ativos: variant; var xml: TXMLGenerator; proprio: string);
var
  linha : Integer;

begin
  linha := 5;

  if ( VarToStr(ativos[linha, 1]) <> '' ) or
     ( VarToStr(ativos[linha, 6]) <> '' ) then
  begin
    xml.AddNode('ativoGarantidor', false, '');

    while VarToStr(ativos[linha, 1]) <> '' do   // Ativos Imobilirios
    begin
      xml.AddNode('ativoImobiliario', false, '');

      xml.AddText('rgi', LeftMask(VarToStr(ativos[linha, 1]), 0));

      if trim(ativos[linha, 2]) <> '' then
      begin
        if (UpperCase(LeftStr(trim(ativos[linha, 2]), 1)) = 'S') then
          xml.AddBoolean('redePropria', 'true')
        else
          xml.AddBoolean('redePropria', 'false');
      end
      else
        raise EGenerica.Create('No foi definido se o ativo imobilirio  rede prpria.');

      if trim(ativos[linha, 3]) <> '' then
      begin
        if (UpperCase(LeftStr(trim(ativos[linha, 3]), 1)) = 'S') then
          xml.AddBoolean('assistencial', 'true')
        else
          xml.AddBoolean('assistencial', 'false');
      end
      else
        raise EGenerica.Create('No foi definido se o ativo imobilirio  assistncial.');

      if VarToStr(ativos[linha, 4]) <> '' then
        xml.AddNumber('valorContabil', StringReplace((VarToStr(ativos[linha, 4])), ',', '.', [rfReplaceAll]))
      else
        xml.AddText('valorContabil', '0.0');

      inc(linha);
      xml.LevelUpNode('ativoGarantidor');
    end;

    xml.LevelUpNode('ativoGarantidor');
    linha := 5;

    while (VarToStr(ativos[linha, 6]) <> '') do // Ativos de Investimento
    begin
      if (VarToStr(ativos[linha, 11]) <> '') then
      begin
        xml.AddNodeAttribute('ativoInvestimento', false, '', 'xsi:type', 'ativoInvestimentoCustodia');

        xml.AddText('codigo', UpperCase(trim(VarToStr(ativos[linha, 7]))));

        if VarToStr(ativos[linha, 8]) <> '' then
          xml.AddText('dataEmissao', retornaData(ativos[linha, 8]))
        else
          xml.AddText('dataEmissao', ativos[linha, 8]);

        if VarToStr(ativos[linha, 9]) <> '' then
          xml.AddText('dataVencimento', retornaData(ativos[linha, 9]))
        else
          xml.AddText('dataVencimento', ativos[linha, 9]);

        xml.AddNumber('quantidade', ChangeMaskFormat(VarToStr(ativos[linha, 13]), ',', '.'));

        if VarToStr(ativos[linha, 12]) <> '' then
          xml.AddNumber('precoUnitario', ChangeMaskFormat(VarToStr(ativos[linha, 12]), ',', '.'))
        else
          xml.AddText('precoUnitario', '0.0');

        if VarToStr(ativos[linha, 14]) <> '' then
          xml.AddNumber('valorContabil', ChangeMaskFormat(VarToStr(ativos[linha, 14]), ',', '.'))
        else
          xml.AddText('valorContabil', '0.0');

        xml.AddText('emissor', ativos[linha, 15]);
        xml.AddText('custodia', UpperCase(trim(ativos[linha, 6])));
        xml.AddText('tipo', ativos[linha, 11]);

       xml.LevelUpNode('ativoGarantidor');
       end
     else // Ativos de Investimento Outros
     begin
       xml.AddNodeAttribute('ativoInvestimento', false, '', 'xsi:type', 'ativoInvestimentoOutros');

       xml.AddText('codigo', UpperCase(trim(VarToStr(ativos[linha, 7]))));

       if VarToStr(ativos[linha, 8]) <> '' then
          xml.AddText('dataEmissao', retornaData(ativos[linha, 8]))
       else
          xml.AddText('dataEmissao', ativos[linha, 8]);

       if VarToStr(ativos[linha, 9]) <> '' then
          xml.AddText('dataVencimento', retornaData(ativos[linha, 9]))
       else
          xml.AddText('dataVencimento', ativos[linha, 9]);

          xml.AddNumber('quantidade', ChangeMaskFormat(VarToStr(ativos[linha, 13]), ',', '.'));

       if VarToStr(ativos[linha, 12]) <> '' then
          xml.AddNumber('precoUnitario', ChangeMaskFormat(VarToStr(ativos[linha, 12]), ',', '.'))
       else
          xml.AddText('precoUnitario', '0.0');

       if VarToStr(ativos[linha, 14]) <> '' then
          xml.AddNumber('valorContabil', ChangeMaskFormat(VarToStr(ativos[linha, 14]), ',', '.'))
       else
          xml.AddText('valorContabil', '0.0');

          xml.AddText('emissor', ativos[linha, 15]);
          xml.AddText('custodia', UpperCase(trim(ativos[linha, 6])));
          xml.AddText('tipo', ativos[linha, 10]);
       end;
      xml.LevelUpNode('ativoGarantidor');
      inc(linha);
    end;
    xml.LevelUpNode('ativoGarantidor');
  end;
end;

procedure MontaMovProvEventos2016(movProvEventos: Variant; var xml: TXMLGenerator);
var
  Linha, Coluna, Lancto : Integer;
  ColunaFim : Boolean;
  ColunaAnoMes : string;

begin
  Linha := 2;
  Coluna := 3;
  Lancto := 28;
  ColunaFim := False;

  ShortDateFormat := 'yyyy-mm';
  ColunaAnoMes := DateTimeToStr(FloatToDateTime(StrToFloat(VarToStr(movProvEventos[Linha, Coluna]))));

  xml.AddNode('movProvEventosSinistrosLiq', False, '');

  while not ColunaFim do
  begin
     Linha := 5;

    if VarToStr(movProvEventos[2, Coluna]) <> 'FIM' then
    begin
      ColunaAnoMes := DateTimeToStr(FloatToDateTime(StrToFloat(VarToStr(movProvEventos[2, Coluna]))));

      xml.AddNode('provEventosSinistrosLiq', False, '');
      xml.AddText('mes', ColunaAnoMes);
      xml.AddNode('prePagamento', False, '');
      xml.AddText('movimentacao', '0');

      if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('provEventosSinistrosLiq');

      // Total pago no ms (-)   cdigos: 29 - 32
      for Linha := 8 to 11 do
      begin
        Inc(Lancto);

        xml.AddNode('prePagamento', False, '');
        xml.AddText('movimentacao', IntToStr(Lancto));

        if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
          xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
        else
          xml.AddText('valor', '0.0');

        xml.LevelUpNode('provEventosSinistrosLiq');
      end;

      //Total dos novos avisos reconhecidos no ms (+)  cdigos: 33 - 46
      for Linha := 14 to 27 do
      begin
        Inc(Lancto);

        xml.AddNode('prePagamento', False, '');
        xml.AddText('movimentacao', IntToStr(Lancto));

        if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
          xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
        else
          xml.AddText('valor', '0.0');

        xml.LevelUpNode('provEventosSinistrosLiq');
      end;

      //Total de baixa por glosa reconhecidas no ms (-)   cdigos:  47 - 60
      for Linha := 30 to 43 do
      begin
        Inc(Lancto);

        xml.AddNode('prePagamento', False, '');
        xml.AddText('movimentacao', IntToStr(Lancto));

        if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
          xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
        else
          xml.AddText('valor', '0.0');

        xml.LevelUpNode('provEventosSinistrosLiq');
      end;

      //Saldo final da PSL relacionados a contratos em ps-pagamento (+)  - cdigo: 61
      Linha := 45;
      Inc(Lancto);

      xml.AddNode('prePagamento', False, '');
      xml.AddText('movimentacao', IntToStr(Lancto));

      if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('provEventosSinistrosLiq');

      //Saldo final da PSL - cdigo: 62
      Linha := 47;
      Inc(Lancto);

      xml.AddNode('prePagamento', False, '');
      xml.AddText('movimentacao', IntToStr(Lancto));

      if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('provEventosSinistrosLiq');

      //Total dos eventos ocorridos, avisados e pagos dentro do ms e que no tenham transitado pela Proviso de Sinistros a Liquidar - cdigo: 63
      Linha := 49;
      Inc(Lancto);

      xml.AddNode('prePagamento', False, '');
      xml.AddText('movimentacao', IntToStr(Lancto));

      if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('provEventosSinistrosLiq');

      //Total das glosas reconhecidas no ms que no tenham transitado pela Proviso de Sinistros a Liquidar  - cdigo: 64
      Linha := 51;
      Inc(Lancto);

      xml.AddNode('prePagamento', False, '');
      xml.AddText('movimentacao', IntToStr(Lancto));

      if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('provEventosSinistrosLiq');

      //Total de outras recuperaes reconhecidas no ms  -  cdigos: 65 - 78
      for linha := 54 to 67 do
      begin
        Inc(Lancto);
        xml.AddNode('prePagamento', False, '');
        xml.AddText('movimentacao', IntToStr(Lancto));

        if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
          xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
        else
          xml.AddText('valor', '0.0');

        xml.LevelUpNode('provEventosSinistrosLiq');
      end;

//    --------  Total de lanamento PEONA  ---------------------  cdigo: 79

      Linha := 70;
      Inc(Lancto);

      xml.AddNode('prePagamento', False, '');
      xml.AddText('movimentacao', IntToStr(Lancto));

      if VarToStr(movProvEventos[Linha, Coluna]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(movProvEventos[Linha, Coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('movProvEventosSinistrosLiq');

      Inc(Coluna);
      Lancto := 28;
    end
    else
        ColunaFim := True;
  end;

  xml.LevelUpNode('movProvEventosSinistrosLiq');

end;

procedure MontaFluxoCaixa(var xml: TXMLGenerator);
var
  linha: integer;
begin
    xml.AddNode('fluxoCaixa', false, '');

    for linha := 5 to 19 do
    begin
      xml.AddNode('lancamento', false, '');
      xml.AddText('conta', UpperCase(FluxoDeCaixa2016[linha, 2]));

      if VarToStr(FluxoDeCaixa2016[linha, 4]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(FluxoDeCaixa2016[linha, 4]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('fluxoCaixa');
    end;

    for linha := 23 to 32 do
    begin
      xml.AddNode('lancamento', false, '');
      xml.AddText('conta', UpperCase(FluxoDeCaixa2016[linha, 2]));

      if VarToStr(FluxoDeCaixa2016[linha, 4]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(FluxoDeCaixa2016[linha, 4]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('fluxoCaixa');
    end;

    for linha := 36 to 43 do
    begin
      xml.AddNode('lancamento', false, '');
      xml.AddText('conta', UpperCase(FluxoDeCaixa2016[linha, 2]));

      if VarToStr(FluxoDeCaixa2016[linha, 4]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(FluxoDeCaixa2016[linha, 4]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('fluxoCaixa');
    end;

    xml.LevelUpNode('fluxoCaixa');
end;

procedure MontaIdadeSaldo2016(var xml: TXMLGenerator);
var
  linha: integer;
begin

    xml.AddNode('idadeSaldo', false, '');

    //Incio Idade de Saldo do Passivo 2016...
    for linha := 6 to 11 do
    begin

      xml.AddNode('passivo', false, '');

      if trim(IdadeDeSaldos2016[linha, 1]) = 'a Vencer' then
        xml.AddText('vencimento', '00');
      if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 1 a 30 dias' then
        xml.AddText('vencimento', '30');
      if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 31 a 60 dias' then
        xml.AddText('vencimento', '60');
      if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 61 a 90 dias' then
        xml.AddText('vencimento', '90');
      if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 91 a 120 dias' then
        xml.AddText('vencimento', '120');
      if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos a mais de 120 dias' then
        xml.AddText('vencimento', '999');


      if VarToStr(IdadeDeSaldos2016[linha, 3]) <> '' then
        xml.AddNumber('eventos', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 3]), ',', '.'))
      else
        xml.AddText('eventos', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 4]) <> '' then
        xml.AddNumber('comercial', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 4]), ',', '.'))
      else
        xml.AddText('comercial', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 5]) <> '' then
        xml.AddNumber('debOper', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 5]), ',', '.'))
      else
        xml.AddText('debOper', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 6]) <> '' then
        xml.AddNumber('outrosDebOper', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 6]), ',', '.'))
      else
        xml.AddText('outrosDebOper', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 8]) <> '' then
        xml.AddNumber('depBenConSegRec', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 8]), ',', '.'))
      else
        xml.AddText('depBenConSegRec', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 9]) <> '' then
        xml.AddNumber('prestServAS', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 9]), ',', '.'))
      else
        xml.AddText('prestServAS', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 10]) <> '' then
        xml.AddNumber('depAquisCarre', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 10]), ',', '.'))
      else
        xml.AddText('depAquisCarre', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 11]) <> '' then
        xml.AddNumber('outrosDebPagar', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 11]), ',', '.'))
      else
        xml.AddText('outrosDebPagar', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 2]) <> '' then
        xml.AddNumber('eventossus', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 2]), ',', '.'))
      else
        xml.AddText('eventossus', '0.0');

      if VarToStr(IdadeDeSaldos2016[linha, 7]) <> '' then
        xml.AddNumber('titulosencargos', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 7]), ',', '.'))
      else
        xml.AddText('titulosencargos', '0.0');

      xml.LevelUpNode('idadeSaldo');
    end;
    //Fim Idade de Saldo do Passivo 2016...

    //Incio Idade de Saldo do Ativo 2016...
    for linha := 20 to 27 do
    begin
      if (linha <> 25) and (linha <> 26) then
      begin
        xml.AddNode('ativo', false, '');

        if trim(IdadeDeSaldos2016[linha, 1]) = 'a Vencer' then
          xml.AddText('vencimento', '00');
        if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 1 a 30 dias' then
          xml.AddText('vencimento', '30');
        if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 31 a 60 dias' then
          xml.AddText('vencimento', '60');
        if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos de 61 a 90 dias' then
          xml.AddText('vencimento', '90');
        if trim(IdadeDeSaldos2016[linha, 1]) = 'Vencidos a mais de 90 dias' then
          xml.AddText('vencimento', '999');
        if trim(IdadeDeSaldos2016[linha, 1]) = 'PPSC' then
          xml.AddText('vencimento', '400');


        if VarToStr(IdadeDeSaldos2016[linha, 2]) <> '' then
          xml.AddNumber('individualPre', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 2]), ',', '.'))
        else
          xml.AddText('individualPre', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 3]) <> '' then
          xml.AddNumber('individualPos', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 3]), ',', '.'))
        else
          xml.AddText('individualPos', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 4]) <> '' then
          xml.AddNumber('coletivoPre', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 4]), ',', '.'))
        else
          xml.AddText('coletivoPre', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 5]) <> '' then
          xml.AddNumber('coletivoPos', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 5]), ',', '.'))
        else
          xml.AddText('coletivoPos', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 6]) <> '' then
          xml.AddNumber('credAdminBenef', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 6]), ',', '.'))
        else
          xml.AddText('credAdminBenef', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 7]) <> '' then
          xml.AddNumber('partBenefES', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 7]), ',', '.'))
        else
          xml.AddText('partBenefES', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 8]) <> '' then
          xml.AddNumber('credOper', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 8]), ',', '.'))
        else
          xml.AddText('credOper', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 9]) <> '' then
          xml.AddNumber('outrosCredComPlano', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 9]), ',', '.'))
        else
          xml.AddText('outrosCredComPlano', '0.0');

        if VarToStr(IdadeDeSaldos2016[linha, 10]) <> '' then
          xml.AddNumber('outrosCredSemPlano', ChangeMaskFormat(VarToStr(IdadeDeSaldos2016[linha, 10]), ',', '.'))
        else
          xml.AddText('outrosCredSemPlano', '0.0');

        xml.LevelUpNode('idadeSaldo');  
      end;
    end;

    xml.LevelUpNode('idadeSaldo');

end;

procedure MontaSaldoProvEventosSinistrosLiq(var xml: TXMLGenerator);
var
   linha : Integer;
begin

  linha := 4; 

      //Operadoras de grande porte (30 dias); pequeno e mdio porte (60 dias)

     if ((VarToStr(PSEL[7, 2]) <> '' ) and
         (VarToStr(PSEL[7, 2]) <> '0')) then
     begin
        xml.AddNodeAttribute('saldoProvEventosSinistrosLiq', false, '', 'grandePorte', 'true');

        if VarToStr(PSEL[linha, 2]) <> '' then
          xml.AddNumber('eventosSinistrosAte', ChangeMaskFormat(VarToStr(PSEL[linha, 2]), ',', '.'))
        else
          xml.AddText('eventosSinistrosAte', '0.0');

        if VarToStr(PSEL[linha+1, 2]) <> '' then
          xml.AddNumber('eventosSinistrosPos', ChangeMaskFormat(VarToStr(PSEL[linha+1, 2]), ',', '.'))
        else
          xml.AddText('eventosSinistrosPos', '0.0');

        xml.LevelUpNode('saldoProvEventosSinistrosLiq');
     end
     else
     begin //Vencimento at 60 dias...
        xml.AddNodeAttribute('saldoProvEventosSinistrosLiq', false, '', 'grandePorte', 'false');

        if VarToStr(PSEL[linha, 4]) <> '' then
          xml.AddNumber('eventosSinistrosAte', ChangeMaskFormat(VarToStr(PSEL[linha, 4]), ',', '.'))
        else
          xml.AddText('eventosSinistrosAte', '0.0');

        if VarToStr(PSEL[linha+1, 4]) <> '' then
          xml.AddNumber('eventosSinistrosPos', ChangeMaskFormat(VarToStr(PSEL[linha+1, 4]), ',', '.'))
        else
          xml.AddText('eventosSinistrosPos', '0.0');
     end;

  xml.LevelUpNode('saldoProvEventosSinistrosLiq');

end;

procedure MontaLucrosPrejuizos(var xml: TXMLGenerator);
var
  linha: integer;
begin
  xml.AddNode('lucrosPrejuizos', false, '');

  for linha := 5 to 11 do
  begin
    xml.AddNode('movimentacao', false, '');
    xml.AddText('conta', UpperCase(LucrosOuPrejuizos[linha, 2]));

    if VarToStr(LucrosOuPrejuizos[linha, 4]) <> '' then
      xml.AddNumber('valor', ChangeMaskFormat(VarToStr(LucrosOuPrejuizos[linha, 4]), ',', '.'))
    else
      xml.AddText('valor', '0.0');

    xml.LevelUpNode('lucrosPrejuizos');
  end;
end;

procedure MontaIntercambioEventual(var xml: TXMLGenerator;
  var regANSInter: string; var linha, cont: Integer);
begin

    xml.AddNode('intercambioEventual', false, '');

    linha := 4;
    cont  := 0;

    while (trim(VarToStr(IntercambioEventual[linha, 1])) <> '') and (linha < 9) do
    begin
      xml.AddNode('aReceber', false, '');
      regANSInter := VarToStr(IntercambioEventual[linha, 1]);

      if VarToStr(IntercambioEventual[linha, 2]) <> '' then
        xml.AddNumber('saldo', ChangeMaskFormat(VarToStr(IntercambioEventual[linha, 2]), ',', '.'))
      else
        xml.AddText('saldo', '0.0');

      xml.AddText('assistencia', 'H');

      if length(regANSInter) <> 6 then
        raise EGenerica.Create('O registro ANS da Operadora deve possuir 6 caracteres nmericos.');

      xml.AddText('operadora', regANSInter);

      xml.AddText('dataVencimento', retornaData(IntercambioEventual[linha, 3]));

      xml.LevelUpNode('aReceber');
      xml.LevelUpNode('intercambioEventual');

      inc(cont);
      inc(linha);
    end;

    linha := 11;
    cont  := 0;

    while (trim(VarToStr(IntercambioEventual[linha, 1])) <> '') and (linha < 16) do
    begin
      xml.AddNode('aReceber', false, '');
      regANSInter := VarToStr(IntercambioEventual[linha, 1]);

      if VarToStr(IntercambioEventual[linha, 2]) <> '' then
        xml.AddNumber('saldo', ChangeMaskFormat(VarToStr(IntercambioEventual[linha, 2]), ',', '.'))
      else
        xml.AddText('saldo', '0.0');

      xml.AddText('assistencia', 'O');

      if length(regANSInter) <> 6 then
        raise EGenerica.Create('O registro ANS da Operadora deve possuir 6 caracteres nmericos.');

      xml.AddText('operadora', regANSInter);

      xml.AddText('dataVencimento', retornaData(IntercambioEventual[linha, 3]));

      xml.LevelUpNode('aReceber');
      xml.LevelUpNode('intercambioEventual');

      inc(cont);
      inc(linha);
    end;

    xml.LevelUpNode('intercambioEventual');

    linha := 4;
    cont := 0;

    while (trim(VarToStr(IntercambioEventual[linha, 4])) <> '') and (linha < 9) do
    begin
      xml.AddNode('aPagar', false, '');
      regANSInter := VarToStr(IntercambioEventual[linha, 4]);

      if VarToStr(IntercambioEventual[linha, 5]) <> '' then
        xml.AddNumber('saldo', ChangeMaskFormat(VarToStr(IntercambioEventual[linha, 5]), ',', '.'))
      else
        xml.AddText('saldo', '0.0');

      xml.AddText('assistencia', 'H');

      if length(regANSInter) <> 6 then
        raise EGenerica.Create('O registro ANS da Operadora deve possuir 6 caracteres nmericos.');

      xml.AddText('operadora', regANSInter);

      xml.AddText('dataVencimento', retornaData(IntercambioEventual[linha, 6]));

      xml.LevelUpNode('aPagar');
      xml.LevelUpNode('intercambioEventual');
      inc(cont);
      inc(linha);
    end;

    linha := 11;
    cont := 0;

    while (trim(VarToStr(IntercambioEventual[linha, 4])) <> '') and (linha < 16) do
    begin
      xml.AddNode('aPagar', false, '');
      regANSInter := VarToStr(IntercambioEventual[linha, 4]);

      if VarToStr(IntercambioEventual[linha, 5]) <> '' then
        xml.AddNumber('saldo', ChangeMaskFormat(VarToStr(IntercambioEventual[linha, 5]), ',', '.'))
      else
        xml.AddText('saldo', '0.0');

      xml.AddText('assistencia', 'O');

      if length(regANSInter) <> 6 then
        raise EGenerica.Create('O registro ANS da Operadora deve possuir 6 caracteres nmericos.');

      xml.AddText('operadora', regANSInter);

      xml.AddText('dataVencimento', retornaData(IntercambioEventual[linha, 6]));
      xml.LevelUpNode('aPagar');
      xml.LevelUpNode('intercambioEventual');
      inc(cont);
      inc(linha);
    end;
    xml.LevelUpNode('intercambioEventual');

    linha := 4;
    cont := 0;

    while (trim(VarToStr(IntercambioEventual[linha, 4])) <> '') and (linha < 9) do
    begin
      xml.AddNode('aFaturar', false, '');

      if VarToStr(IntercambioEventual[linha, 8]) <> '' then
        xml.AddNumber('saldo', ChangeMaskFormat(VarToStr(IntercambioEventual[linha, 8]), ',', '.'))
      else
        xml.AddText('saldo', '0.0');

      xml.AddText('assistencia', 'H');

      xml.LevelUpNode('aFaturar');
      xml.LevelUpNode('intercambioEventual');
      inc(cont);
      inc(linha);
    end;

    linha := 11;
    cont := 0;

    while (trim(VarToStr(IntercambioEventual[linha, 4])) <> '') and (linha < 16) do
    begin
      xml.AddNode('aFaturar', false, '');

      if VarToStr(IntercambioEventual[linha, 8]) <> '' then
        xml.AddNumber('saldo', ChangeMaskFormat(VarToStr(IntercambioEventual[linha, 8]), ',', '.'))
      else
        xml.AddText('saldo', '0.0');

      xml.AddText('assistencia', 'O');

      xml.LevelUpNode('aFaturar');
      xml.LevelUpNode('intercambioEventual');
      inc(cont);
      inc(linha);
    end;
    xml.LevelUpNode('intercambioEventual');

end;

procedure MontaCoberturaAssistencial(var xml: TXMLGenerator);
var
  linha, coluna, proc, origem  : integer;

begin

    xml.AddNode('coberturaAssistencial', false, '');
    linha  := 8;
    coluna := 2;
    proc := 0;
    origem := 0;

    //  IFAL - Planos Individuais/Familiares antes da Lei
      while coluna < 8 do
      begin
         while linha < 14 do
         begin
            if (trim(Eventos2016[linha, 1]) <> 'TOTAL') then
            begin
              xml.AddNode('lancCoberturaAssistencial', false, '');
              xml.AddText('plano', 'IFAL');
              xml.AddText('procedimento', InttoStr(proc));
              xml.AddText('origem', InttoStr(origem));

              if (VarToStr(Eventos2016[linha, coluna]) <> '') then
                xml.AddNumber('valor', ChangeMaskFormat(VarToStr(Eventos2016[linha, coluna]), ',', '.'));

              inc(origem);
              inc(linha);
              xml.LevelUpNode('coberturaAssistencial');
            end
            else
              inc(linha);

         end;
        inc(coluna);
        inc(proc);
        linha := 8;
        origem := 0;
      end;

      // IFPL - Planos Individuais/Familiares ps Lei
      linha:= 18;
      coluna:= 2;
      proc:= 0;
      while coluna < 8 do
      begin
         while linha < 24 do
         begin
            if (trim(Eventos2016[linha, 1]) <> 'TOTAL') then
            begin
              xml.AddNode('lancCoberturaAssistencial', false, '');
              xml.AddText('plano', 'IFPL');
              xml.AddText('procedimento', InttoStr(proc));
              xml.AddText('origem', InttoStr(origem));

              if (VarToStr(Eventos2016[linha, coluna]) <> '') then
                xml.AddNumber('valor', ChangeMaskFormat(VarToStr(Eventos2016[linha, coluna]), ',', '.'));

              inc(origem);
              inc(linha);
              xml.LevelUpNode('coberturaAssistencial');
            end
            else
              inc(linha);

         end;
        inc(coluna);
        inc(proc);
        linha := 18;
        origem := 0;
      end;

      // PLAL - Planos Coletivos por Adeso antes da Lei
      linha:= 28;
      coluna:= 2;
      proc:= 0;
      while coluna < 8 do
      begin
         while linha < 34 do
         begin
            if (trim(Eventos2016[linha, 1]) <> 'TOTAL') then
            begin
              xml.AddNode('lancCoberturaAssistencial', false, '');
              xml.AddText('plano', 'PLAL');
              xml.AddText('procedimento', InttoStr(proc));
              xml.AddText('origem', InttoStr(origem));

              if (VarToStr(Eventos2016[linha, coluna]) <> '') then
                xml.AddNumber('valor', ChangeMaskFormat(VarToStr(Eventos2016[linha, coluna]), ',', '.'));

              inc(origem);
              inc(linha);
              xml.LevelUpNode('coberturaAssistencial');
            end
            else
              inc(linha);

         end;
        inc(coluna);
        inc(proc);
        linha := 28;
        origem := 0;
      end;

      // PLAP - Planos Coletivos por Adeso Ps Lei
      linha:= 38;
      coluna:= 2;
      proc:= 0;
      while coluna < 8 do
      begin
         while linha < 44 do
         begin
            if (trim(Eventos2016[linha, 1]) <> 'TOTAL') then
            begin
              xml.AddNode('lancCoberturaAssistencial', false, '');
              xml.AddText('plano', 'PLAP');
              xml.AddText('procedimento', InttoStr(proc));
              xml.AddText('origem', InttoStr(origem));

              if (VarToStr(Eventos2016[linha, coluna]) <> '') then
                xml.AddNumber('valor', ChangeMaskFormat(VarToStr(Eventos2016[linha, coluna]), ',', '.'));

              inc(origem);
              inc(linha);
              xml.LevelUpNode('coberturaAssistencial');
            end
            else
              inc(linha);

         end;
        inc(coluna);
        inc(proc);
        linha := 38;
        origem := 0;
      end;

      // PCEA - Planos Coletivos Empresariais antes da Lei
      linha:= 48;
      coluna:= 2;
      proc:= 0;
      while coluna < 8 do
      begin
         while linha < 54 do
         begin
            if (trim(Eventos2016[linha, 1]) <> 'TOTAL') then
            begin
              xml.AddNode('lancCoberturaAssistencial', false, '');
              xml.AddText('plano', 'PCEA');
              xml.AddText('procedimento', InttoStr(proc));
              xml.AddText('origem', InttoStr(origem));

              if (VarToStr(Eventos2016[linha, coluna]) <> '') then
                xml.AddNumber('valor', ChangeMaskFormat(VarToStr(Eventos2016[linha, coluna]), ',', '.'));

              inc(origem);
              inc(linha);
              xml.LevelUpNode('coberturaAssistencial');
            end
            else
              inc(linha);

         end;
        inc(coluna);
        inc(proc);
        linha := 48;
        origem := 0;
      end;

      // PCEL - Planos Coletivos Empresariais ps Lei
      linha:= 58;
      coluna:= 2;
      proc:= 0;
      while coluna < 8 do
      begin
         while linha < 64 do
         begin
            if (trim(Eventos2016[linha, 1]) <> 'TOTAL') then
            begin
              xml.AddNode('lancCoberturaAssistencial', false, '');
              xml.AddText('plano', 'PCEL');
              xml.AddText('procedimento', InttoStr(proc));
              xml.AddText('origem', InttoStr(origem));

              if (VarToStr(Eventos2016[linha, coluna]) <> '') then
                xml.AddNumber('valor', ChangeMaskFormat(VarToStr(Eventos2016[linha, coluna]), ',', '.'));

              inc(origem);
              inc(linha);
              xml.LevelUpNode('coberturaAssistencial');
            end
            else
              inc(linha);

         end;
        inc(coluna);
        inc(proc);
        linha := 58;
        origem := 0;
      end;

end;

procedure MontaContraprestacaoReceber2016(var xml: TXMLGenerator);
var
  linha, coluna, Lancto, LanctoP, nLinha, Ultimalinha, colunaIni, colunaFim : integer;
  ColunaAnoMes, PEONA : string;
  NovoLancto, UltimaColuna : Boolean;
begin
  linha         := 2;
  coluna        := 3;
  colunaIni     := 3;
  Lancto        := 0;
  Ultimalinha   := 0;
  NovoLancto    := False;
  UltimaColuna  := False;
  colunaFim     := 0;
  LanctoP       := 0;
  
  PEONA := VarToStr(ContraprestacoesReceber2016[53, 3]);

  if PEONA = 'S' then
    xml.AddNodeAttribute('contraprestacaoReceber', false, '', 'receitaProRata', 'true')
  else
     xml.AddNodeAttribute('contraprestacaoReceber', false, '', 'receitaProRata', 'false');

  ShortDateFormat := 'yyyy-mm';
  ColunaAnoMes := DateTimeToStr(FloatToDateTime(StrToFloat(VarToStr(ContraprestacoesReceber2016[linha, coluna]))));

  coluna := colunaIni;
  linha  := 6;

  xml.AddNode('movContraprestacaoReceber', false, '');
  xml.AddText('mes', ColunaAnoMes);

  while not UltimaColuna do
  begin
    if NovoLancto then
    begin
      coluna := colunaFim + 1;
      linha  := 6;
      Lancto := 0;
      LanctoP := 0;

      ColunaAnoMes := DateTimeToStr(FloatToDateTime(StrToFloat(VarToStr(ContraprestacoesReceber2016[2, coluna]))));
      NovoLancto   := False;

      xml.LevelUpNode('contraprestacaoReceber');
      xml.AddNode('movContraprestacaoReceber', false, '');
      xml.AddText('mes', ColunaAnoMes);
    end;

    //Provisionado para Contraprestaes
    for nLinha := linha to 10 do
    begin
      xml.AddNode('provisionado', false, '');
      xml.AddText('movimentacao',IntToStr(LanctoP));

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna+1]) <> '') then
        xml.AddNumber('planosIndividuais', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+1]), ',', '.'))
      else
        xml.AddText('planosIndividuais', '0.0');

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna+1]) <> '') then
        xml.AddNumber('planosColetivos', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+3]), ',', '.'))
      else
        xml.AddText('planosColetivos', '0.0');

      Inc(LanctoP);

      xml.LevelUpNode('movContraprestacaoReceber');

      Ultimalinha := nLinha;
      colunaFim   := coluna+3;
    end; //Fim Provisionado para Contraprestaes

    // Contraprestaes
    for nLinha := linha to 12 do
    begin
      xml.AddNode('contraprestacao', false, '');
      xml.AddText('movimentacao',IntToStr(Lancto));

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosIndividuais', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna]), ',', '.'))
      else
        xml.AddText('planosIndividuais', '0.0');

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosColetivos', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+2]), ',', '.'))
      else
        xml.AddText('planosColetivos', '0.0');

      Inc(Lancto);

      xml.LevelUpNode('movContraprestacaoReceber');

      Ultimalinha := nLinha;
      colunaFim   := coluna+3;
    end;

    coluna := colunaIni;
    linha  := Ultimalinha + 5;
    Inc(Lancto); // Pular p/ 8

    for nLinha := linha to 24 do
    begin
      xml.AddNode('contraprestacao', false, '');
      xml.AddText('movimentacao',IntToStr(Lancto));

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosIndividuais', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna]), ',', '.'))
      else
        xml.AddText('planosIndividuais', '0.0');

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosColetivos', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+2]), ',', '.'))
      else
        xml.AddText('planosColetivos', '0.0');

      Inc(Lancto);
      xml.LevelUpNode('movContraprestacaoReceber');
      Ultimalinha := nLinha;
    end;

    coluna := colunaIni;
    linha  := Ultimalinha + 5;

    for nLinha := linha to 32 do
    begin
      xml.AddNode('contraprestacao', false, '');
      xml.AddText('movimentacao',IntToStr(Lancto));

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosIndividuais', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna]), ',', '.'))
      else
        xml.AddText('planosIndividuais', '0.0');

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosColetivos', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+2]), ',', '.'))
      else
        xml.AddText('planosColetivos', '0.0');

      Inc(Lancto);
      xml.LevelUpNode('movContraprestacaoReceber');
      Ultimalinha := nLinha;
    end;

    coluna := colunaIni;
    linha  := Ultimalinha + 5;

    for nLinha := linha to 42 do
    begin
      xml.AddNode('contraprestacao', false, '');
      xml.AddText('movimentacao',IntToStr(Lancto));

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosIndividuais', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna]), ',', '.'))
      else
        xml.AddText('planosIndividuais', '0.0');

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosColetivos', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+2]), ',', '.'))
      else
        xml.AddText('planosColetivos', '0.0');

      Inc(Lancto);
      xml.LevelUpNode('movContraprestacaoReceber');
      Ultimalinha := nLinha;
    end;

    coluna := colunaIni;
    linha  := Ultimalinha + 5;

    for nLinha := linha to 49 do
    begin
      xml.AddNode('contraprestacao', false, '');
      xml.AddText('movimentacao',IntToStr(Lancto));

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosIndividuais', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna]), ',', '.'))
      else
        xml.AddText('planosIndividuais', '0.0');

      if (VarToStr(ContraprestacoesReceber2016[nLinha, coluna]) <> '') then
        xml.AddNumber('planosColetivos', ChangeMaskFormat(VarToStr(ContraprestacoesReceber2016[nLinha, coluna+2]), ',', '.'))
      else
        xml.AddText('planosColetivos', '0.0');

      Inc(Lancto);

      Ultimalinha := nLinha;

      if (VarToStr(ContraprestacoesReceber2016[2, colunaFim+1]) = 'FIM') then
        UltimaColuna := True
      else
        UltimaColuna := False;

      xml.LevelUpNode('movContraprestacaoReceber');
    end;

    if Ultimalinha = 49 then
      NovoLancto := True;
  end;
end;

procedure MontaContraprestacoesRepassar2016(var xml: TXMLGenerator);
var
  linha, coluna, cod : integer;
  scod, ColunaAnoMes : String;

begin
  coluna := 3;

  xml.AddNode('contraprestacaoRepassar', false, '');

  while coluna < 6 do
  begin
    ShortDateFormat := 'yyyy-mm';
    ColunaAnoMes := DateTimeToStr(FloatToDateTime(StrToFloat(VarToStr(ContraprestacoesRepassar2016[2, coluna]))));
    linha := 4;
    cod   := 1;

    xml.AddNode('segContraprestacaoRepassar', false, '');
    xml.AddText('mes', ColunaAnoMes);

    while linha < 9 do
    begin
      scod := InttoStr(cod);
      xml.AddNode('lancamento', false, '');

      if (VarToStr(ContraprestacoesRepassar2016[linha, 2]) = 'A Vencer') then
        xml.AddText('movimentacao', '7')
      else
        xml.AddText('movimentacao', scod);

      if (VarToStr(ContraprestacoesRepassar2016[linha, coluna]) <> '') then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(ContraprestacoesRepassar2016[linha, coluna]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

       inc(linha);
       inc(cod);
       xml.LevelUpNode('segContraprestacaoRepassar');
    end;
    inc(coluna);
    xml.LevelUpNode('contraprestacaoRepassar');
  end;

  xml.LevelUpNode('contraprestacaoRepassar');

end;

procedure MontaContratosEstipulados2016(var xml: TXMLGenerator);
var
  linha : Integer;
  regANSInter : String;
begin
  linha := 5;

  xml.AddNode('contratosEstipulados', false, '');

  while linha < 10 do
  begin
    if (trim(VarToStr(ContratosEstipulados[linha, 1])) <> '') then
    begin
      xml.AddNode('contrato', false, '');

      regANSInter := VarToStr(ContratosEstipulados[linha, 1]);

      if length(regANSInter) <> 6 then
        raise EGenerica.Create('O registro ANS da Operadora deve possuir 6 caracteres nmericos.');

      xml.AddText('operadora', regANSInter);

      if VarToStr(ContratosEstipulados[linha, 2]) <> '' then
        xml.AddNumber('valor', ChangeMaskFormat(VarToStr(ContratosEstipulados[linha, 2]), ',', '.'))
      else
        xml.AddText('valor', '0.0');

      xml.LevelUpNode('contratosEstipulados');
      inc(linha);
    end;
  end;
end;

procedure MontaContaCorrenteCoop(var xml: TXMLGenerator);
var
  linha : Integer;
begin
  linha := 4;
  ShortDateFormat := 'yyyy-mm-dd';

  xml.AddNode('contaCorrenteCooperado',false,'');

  while (trim(VarToStr(CCoop[linha,1]))<>'') do
  begin
    xml.AddNode('lancContaCorrenteCooperado', false, '');
    xml.AddText('tipoImposto', UpperCase(trim(CCoop[linha,1])));
    xml.AddText('nomeImposto', UpperCase(trim(VarToStr(CCoop[linha,2]))));

    if VarToStr(CCoop[linha,3]) <>'' then
      xml.AddText('dataCompetencia', retornaData(CCoop[linha,3]))
    else
      xml.AddText('dataCompetencia',CCoop[linha,3]);

    if  VarToStr(CCoop[linha,4]) <>'' then
      xml.AddText('dataAdesaoRefis', retornaData(CCoop[linha,4]));

    if VarToStr(CCoop[linha,5])<>'' then
      xml.AddText('qtdeParcelas', CCoop[linha,5]);

    if VarToStr(CCoop[linha,6])<>'' then
      xml.AddNumber('valorTotalFinanciado', ChangeMaskFormat(VarToStr(CCoop[linha,6]),',','.'))
    else
      xml.AddText('valorTotalFinanciado','0.0');

    if VarToStr(CCoop[linha,7])<>'' then
      xml.AddNumber('valorTotalPago', ChangeMaskFormat(VarToStr(CCoop[linha,7]),',','.'))
    else
      xml.AddText('valorTotalPago','0.0');

    if VarToStr(CCoop[linha,8])<>'' then
      xml.AddNumber('valorSaldoTrim', ChangeMaskFormat(VarToStr(CCoop[linha,8]),',','.'))
    else
      xml.AddText('valorSaldoTrim','0.0');

    if VarToStr(CCoop[linha,9])<>'' then
      xml.AddText('qtdeParcelasDevidas', CCoop[linha,9]);

    if VarToStr(CCoop[linha,10])<>'' then
      xml.AddNumber('valorPagoTrim', ChangeMaskFormat(VarToStr(CCoop[linha,10]),',','.'))
    else
      xml.AddText('valorPagoTrim','0.0');

    if VarToStr(CCoop[linha,11])<>'' then
      xml.AddText('qtdeParcelasPagas', CCoop[linha,11]);

    if VarToStr(CCoop[linha,12])<>'' then
      xml.AddNumber('valorAtualMone', ChangeMaskFormat(VarToStr(CCoop[linha,12]),',','.'))
    else
      xml.AddText('valorAtualMone','0.0');

    if VarToStr(CCoop[linha,13])<>'' then
      xml.AddNumber('valorSaldoFinalTrim', ChangeMaskFormat(VarToStr(CCoop[linha,13]),',','.'))
    else
      xml.AddText('valorSaldoFinalTrim','0.0');

    inc(linha);
    xml.LevelUpNode('contaCorrenteCooperado');
  end;
end;

procedure MontaTributoPassivo(var xml: TXMLGenerator);
var
  linha : Integer;
begin
  linha := 5;
  ShortDateFormat := 'yyyy-mm-dd';

  xml.AddNode('tributoPassivo', false, '');

  while (trim(VarToStr(PassivoCCoop[linha, 1])) <> '') do
    begin
      xml.AddNode('lancTributoPassivo', false, '');
      xml.AddText('codigo', trim(PassivoCCoop[linha, 1]));

      if VarToStr(PassivoCCoop[linha, 2]) <> '' then
        xml.AddText('dataCompetencia', retornaData(PassivoCCoop[linha, 2]))
      else
        xml.AddText('dataCompetencia', PassivoCCoop[linha, 2]);

      if VarToStr(PassivoCCoop[linha, 3]) <> '' then
        xml.AddNumber('valorInicial', ChangeMaskFormat(VarToStr(PassivoCCoop[linha, 3]), ',', '.'))
      else
        xml.AddText('valorInicial', '0.0');

      if VarToStr(PassivoCCoop[linha, 4]) <> '' then
        xml.AddNumber('valorPago', ChangeMaskFormat(VarToStr(PassivoCCoop[linha, 4]), ',', '.'))
      else
        xml.AddText('valorPago', '0.0');

      if VarToStr(PassivoCCoop[linha, 5]) <> '' then
        xml.AddNumber('valorAtualMone', ChangeMaskFormat(VarToStr(PassivoCCoop[linha, 5]), ',', '.'))
      else
        xml.AddText('valorAtualMone', '0.0');

      if VarToStr(PassivoCCoop[linha, 6]) <> '' then
        xml.AddNumber('valorSaldoFinal', ChangeMaskFormat(VarToStr(PassivoCCoop[linha, 6]), ',', '.'))
      else
        xml.AddText('valorSaldoFinal', '0.0');

      inc(linha);
      xml.LevelUpNode('tributoPassivo');
    end;
end;

function LeftMask(const Value: string; ALength: Word): string;
const
  InvalidChar: array[0..4] of Char = ('.', ',', '/', '\', '-');
var
  i: Word;
  SAux: string;
begin
  (* Remove todos os caracteres da mascara  *)
  SAux := Value;
  for i := 0 to 4 do
    SAux := StringReplace(SAux, InvalidChar[i], '', [rfReplaceAll]);

  try
    if (Length(SAux) < ALength) then
      SAux := FormatFloat(BuidFormatation(ALength), StrToFloat(SAux));
  except
    on e: Exception do
      SAux := SAux;
  end;

  Result := SAux;
end;

function ChangeMaskFormat(const Value, OldChar, NewChar: string): string;
var
  x: double;
begin
  try
    if trim(value) <> '' then
    begin
      x := roundto(strtofloat(Value), -2);
      Result := StringReplace(FloatToStr(x), OldChar, NewChar, [rfReplaceAll]);
    end
    else
      Result := '';
  except
    on Exception do
      raise EGenerica.Create('O valor "' + Value + '" no  um nmero vlido, verifique na planilha.');
  end;
end;

function LeftMaskContaBalancete(const Value: string; ALength: Word): string;
const
  InvalidChar: array[0..4] of Char = ('.', ',', '/', '\', '-');
var
  i: Word;
  SAux: string;
begin
  SAux := Value;
  for i := 0 to 4 do
    SAux := StringReplace(SAux, InvalidChar[i], '', [rfReplaceAll]);
  Result := LeftStr(SAux, ALength);
end;

function BuidFormatation(ALength: Word): string;
const
  AZero = '0';
var
  i: Word;
begin
  (* Monta a quantidades de Zeros necessrios para o FormatFloat preencher
    com zeros a esquerda. *)
  Result := '';
  for i := 0 to (ALength - 1) do
    Result := Result + AZero;
end;

end.
