unit uCarregarDados;

interface

uses SysUtils, WinTypes, WinProcs, Messages, Windows,
Variants, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls;

type
EGenerica = class(Exception);

function lerDados(dir: String; version: String): Boolean;
function RetornaData(Data: string): string;
function DeleteFileXML(arq: String): Boolean;
function verificaNumero(valor: string): boolean;
function verificaData(data: string): boolean;
function IsNumeric(S : String) : Boolean;

var
  DadosCadastrais: Variant;
  IntercambioEventual: Variant;
  PSEL: Variant;
  LucrosOuPrejuizos: Variant;
  ContratosEstipulados: Variant;
  CCoop: Variant;
  PassivoCCoop: Variant;
  BalanceteAtivo: Variant;
  BalancetePassivo: Variant;
  BalanceteReceita: Variant;
  BalanceteDespesa: Variant;
  Listas: Variant;
  IdadeDeSaldos2016: Variant;
  AtivosGarantidoresProprios2016: Variant;
  ContraprestacoesRepassar2016: Variant;
  ContraprestacoesReceber2016: Variant;
  FluxoDeCaixa2016: Variant;
  Eventos2016: Variant;
  DadosCadastrais2016: Boolean;
  MovProvEventos2016: Variant;
  ContraPrest2016: Variant;

implementation

uses
  Util, UMyMessageDlg, StrUtils, Shellapi;

function lerDados(dir: String; version: String): Boolean;
var
  Util : TUtil;
  path : string;

begin

  Util   := TUtil.Create;
  Result := True;
  path   := StringReplace(dir, '\', '\', [rfReplaceAll]);
  path   := StringReplace(path, '"', '', [rfReplaceAll]);

  try
    try
      Util.m_CarregarDadosArquivoExcel(DadosCadastrais, path, 'Dados Cadastrais');

      //Verifica se a verso da planilha  a mesma do aplicativo
      if (DadosCadastrais[2, 1] <> version) then
      begin
          MyMessageDlg('Verso incorreta.' + chr(13) + 'Deve ser utilizada a planilha da verso ' + version + '.', mtError, [mbOk], 0);
          Result := false;
          Exit;
      end;

      Util.m_CarregarDadosArquivoExcel(Listas, path, 'Listas');
      Application.ProcessMessages;

      ShortDateFormat := 'yyyy-mm-dd';
      if retornaData(DadosCadastrais[3, 2]) >= '2016-01-01' then
         DadosCadastrais2016 := True
      else
         MyMessageDlg('Os dados devem ser relativos a vigncia do 1 trimestre de 2016 ou posterior.', mtInformation, [mbOk], 0);

      //Montagem dos Quadros comuns para todas as Operadoras - financeiro
      Util.m_CarregarDadosArquivoExcel(BalanceteAtivo, path, 'Balancete Ativo 2016');
      Util.m_CarregarDadosArquivoExcel(BalancetePassivo, path, 'Balancete Passivo 2016');
      Util.m_CarregarDadosArquivoExcel(BalanceteReceita, path, 'Balancete Receita 2016');
      Util.m_CarregarDadosArquivoExcel(BalanceteDespesa, path, 'Balancete Despesa 2016');
      Util.m_CarregarDadosArquivoExcel(AtivosGarantidoresProprios2016, path, 'Ativos Garantidores 2016');
      Util.m_CarregarDadosArquivoExcel(FluxoDeCaixa2016, path, 'Fluxo de Caixa 2016');
      Util.m_CarregarDadosArquivoExcel(IdadeDeSaldos2016, path, 'Distr Idade Saldos 2016');
      Util.m_CarregarDadosArquivoExcel(LucrosOuPrejuizos, path, 'Lucros ou Prejuzos 2016');

      //Montagem dos Quadros para as Cooperativas - cooperativa
      if ((uppercase(DadosCadastrais[26, 2]) = 'COOPM') or (uppercase(DadosCadastrais[26, 2]) = 'COOPO')) then
      begin
        Util.m_CarregarDadosArquivoExcel(PSEL, path, 'Saldo Prov EventosLiquidar 2016');
        Util.m_CarregarDadosArquivoExcel(IntercambioEventual, path, 'Intercambio Eventual 2016');
        Util.m_CarregarDadosArquivoExcel(MovProvEventos2016, path, 'Mov Proviso Eventos 2016');
        Util.m_CarregarDadosArquivoExcel(ContraprestacoesReceber2016, path, 'Mov Contraprestaces 2016');
        Util.m_CarregarDadosArquivoExcel(Eventos2016, path, 'Cobertura Assistencial 2016');
        Util.m_CarregarDadosArquivoExcel(CCoop, path, 'Conta Corrente Cooperados 2016');
        Util.m_CarregarDadosArquivoExcel(PassivoCCoop, path, 'Passivo Tributario Coop 2016');
      end
      //Montagem dos Quadros especficos para as Administradoras de Benefcios - administradora
      else if (uppercase(DadosCadastrais[26, 2]) = 'ADMBN') then
      begin
        Util.m_CarregarDadosArquivoExcel(ContratosEstipulados, path, 'Contratos Estipulados 2016');
        Util.m_CarregarDadosArquivoExcel(ContraprestacoesRepassar2016, path, 'Contraprestaes Repassar 2016');
      end
     //Montagem dos Quadros para as demais modalidades - padro
      else
      begin
        Util.m_CarregarDadosArquivoExcel(PSEL, path, 'Saldo Prov EventosLiquidar 2016');
        Util.m_CarregarDadosArquivoExcel(IntercambioEventual, path, 'Intercambio Eventual 2016');
        Util.m_CarregarDadosArquivoExcel(MovProvEventos2016, path, 'Mov Proviso Eventos 2016');
        Util.m_CarregarDadosArquivoExcel(ContraprestacoesReceber2016, path, 'Mov Contraprestaces 2016');
        Util.m_CarregarDadosArquivoExcel(Eventos2016, path, 'Cobertura Assistencial 2016');
      end;

      Application.ProcessMessages;

    except
    on E: ECarregaArquivo do
    begin
       MyMessageDlg(Format('No foi possvel carregar o arquivo: %s', [E.Message]), mtError, [mbOk], 0);
       DeleteFileXML(dir);
    end;

  end;
  finally
    Screen.Cursor := crDefault;
    FreeAndNil(Util);
  end;

end;

//Formata a data para o padro do XML
function retornaData(data: string): string;
var
  posicao: integer;
  novaData: string;
  dataAux: string;
begin
  dataAux := data;
  novaData := '';

  if verificaNumero(dataAux) then
    novaData := DateToStr(strtofloat(dataAux))
  else
  begin
    if length(dataAux) >= 6 then
    begin
      novaData := rightstr(dataAux, 4);
      dataAux := leftstr(dataAux, length(dataAux) - 5);
      posicao := pos('/', dataAux);
      novaData := novaData + '-' + rightstr(dataAux, length(dataAux) - posicao);
      novaData := novaData + '-' + leftstr(dataAux, posicao - 1);
    end;
  end;

  if not verificaData(novaData) then
  begin
    raise EGenerica.Create('A data "' + data + '" no  vlida.');
    Result := '';
    Exit;
  end
  else
    Result := novaData;
end;

function DeleteFileXML(arq: String): Boolean;
begin
  try
    DeleteFile(PAnsiChar(arq));
  finally
    result := true;
  end;
  result := false;
end;

//Verifica se uma string representa um valor numrico inteiro
function verificaNumero(valor: string): boolean;
var
  i: integer;
  simNumero: boolean;
begin
  simNumero := True;

  if trim(valor) <> '' then
  begin
    for i := 1 to Length(valor) do
    begin
      if not isnumeric(valor[i]) then
      begin
        simNumero := False;
        Break;
      end;
    end;
  end
  else
    simNumero := False;

  Result := simNumero;
end;

//Verifica se uma data possui formatao vlida
function verificaData(data: string): boolean;
var
  ano, mes, dia: string;
begin
  ano := leftstr(data, 4);
  mes := midstr(data, 6, 2);
  dia := rightstr(data, 2);

  if not verificaNumero(ano) or not verificaNumero(mes) or not verificaNumero(dia) then
    result := false
  else
  begin
    try
      //Define o formato da data para no dar erro na strtodate
      ShortDateFormat := 'yyyy-mm-dd';
      //Verifica se a data existe, se der uma exceo  porque no existe
      Result := True;
    except
      on E: Exception do
        result := false;
    end;
  end;
end;

function IsNumeric(S : String) : Boolean; 
begin 
  Result := True; 
  Try 
     StrToInt(S); 
  Except 
    Result := False; 
  end; 
end; 

end.
