unit XSDParseManager;

interface

uses
  SysUtils, Classes, XSDParseManagerData, UUtilXML;

type
  EMaxLengthError = Class(Exception);

  TXSDParseManager = class(TComponent)
  private
    XSDParserManagerDM: TXSDParserManagerDM;

    function getNodeNameValid(const Value: String): String;
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
    function ExecuteParse(const Metadado, Dado: String):String;
  published
    { Published declarations }
  end;


implementation


uses MSXML_TLB, StrUtils;

{ TXSDPareserManager }

constructor TXSDParseManager.Create(AOwner: TComponent);
begin
  inherited;
  XSDParserManagerDM := TXSDParserManagerDM.Create(Self);
end;


function TXSDParseManager.ExecuteParse(const Metadado, Dado: String): String;
var
  Aux: String;
begin
    Result := Dado;

    with XSDParserManagerDM do
    begin
        if cdsComplexTpRef.Locate('Name', getNodeNameValid(Metadado), []) then
        begin
            Aux := cdsComplexTpReftype.AsString;

            if cdsnivel2.Locate('Name', getNodeNameValid(Aux), []) then
            begin
                Aux := cdsNivel2maxLength_value.AsString;

                if (Aux <> '') then
                begin
                    if (Length(Dado) > cdsNivel2maxLength_value.AsInteger) then
                    begin
                        result := '';
                          raise EMaxLengthError.Create('O campo "' + leftstr(Metadado, length(metadado)) + '" pode ter no mximo ' + inttostr(cdsNivel2maxLength_value.AsInteger) + ' caracter(es).' + chr(13) +
                                                       'O valor informado "' + dado + '" excede o limite.' + chr(13) +
                                                       'Para mais detalhes verifique os arquivos XSD fornecidos no site da ANS.');
                    end
                    else
                       Result := IfThen(Length(Dado) > cdsNivel2maxLength_value.AsInteger,Copy(Dado, 1, cdsNivel2maxLength_value.AsInteger), Dado);
                end;
            end;
        end;
    end;
end;

function TXSDParseManager.getNodeNameValid(const Value: String): String;
const
  AsnPref = 'ans:';
var
  AuxString: String;
begin
  AuxString := Value;
  Delete(AuxString, Pos(AsnPref, Value), 4);
  Result := AuxString;
end;

end.
