unit XSDPareserManager;

interface

uses
  SysUtils, Classes, XSDPareserManagerData, UUtilXML;

type
  EMaxLengthError = Class(Exception);
  TXSDPareserManager = class(TComponent)
  private
    XSDPareserManagerDM: TXSDPareserManagerDM;

    function getNodeNameValid(const Value: String): String;
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
    procedure ExecuteParse(AXML: TXMLGenerator);

  published
    { Published declarations }
  end;

procedure Register;

implementation

uses MSXML_TLB;

procedure Register;
begin
  RegisterComponents('Samples', [TXSDPareserManager]);
end;

{ TXSDPareserManager }

constructor TXSDPareserManager.Create(AOwner: TComponent);
begin
  inherited;
  XSDPareserManagerDM := TXSDPareserManagerDM.Create(Self);
end;

procedure TXSDPareserManager.ExecuteParse(AXML: TXMLGenerator);
const
  MsgMaxLengthError = ' O Tamanho do valor no Campo %s ultrapassou o tamanho definido ' +
   ' pelo XDS: %s, tamanho %s.';
var
  AuxNod: IXMLDOMNode;
  lstNodes: IXMLDOMNodeList;
begin

  lstNodes := AXML.Root.childNodes;
  if (lstNodes <> nil) then
    while (true) do
    begin
     AuxNod := lstNodes.nextNode as IXMLDOMElement;
     if AuxNod = nil then break;

      with XSDPareserManagerDM do
      begin
        if cdsComplexTpRef.Locate('Name', getNodeNameValid(AuxNod.nodeName), []) then
          if cdsnivel2.Locate('Name', cdsComplexTpRefname.AsString, []) then
            if not cdsNivel2maxLength_value.IsNull then
              if length(AuxNod.text) > cdsNivel2maxLength_value.AsInteger then
                raise EMaxLengthError.Create(Format(MsgMaxLengthError,
                  [getNodeNameValid(AuxNod.nodeName), cdsNivel2name.AsString, cdsNivel2maxLength_value.AsString]));
      end;
    end;
end;

function TXSDPareserManager.getNodeNameValid(const Value: String): String;
const
  AsnPref = 'ans:';
var
  AuxString: String;
begin
  AuxString := Value;
  Delete(AuxString, Pos(AsnPref, Value), 4);
  Result := AuxString;
end;

end.
