unit Util;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, DB, DBTables, OleServer, Excel2000, Excel97, Grids;

type
  ECarregaArquivo = class (Exception);

  TUtil = class
  public
    procedure m_CarregarDadosArquivoExcel(var RangeMatrix: Variant; strArquivo: string; NomePlanilha:String);
  private
  end;

implementation

uses StrUtils;

{ TUtil }

Procedure TUtil.m_CarregarDadosArquivoExcel(var RangeMatrix: Variant; strArquivo: string; NomePlanilha:String);
var
  WorkBk : _WorkBook;
  WorkSheet : _WorkSheet;
  X, Y : Integer;
  IIndex : OleVariant;
  NomFich : WideString;
  XLApp: TExcelApplication;
begin
  XLApp:= TExcelApplication.Create(nil);
  try
    try
      NomFich:= strArquivo;
      IIndex:= 1;
      XLApp.Connect;
      // Open the Excel File
      XLApp.WorkBooks.Open(NomFich,EmptyParam,EmptyParam,EmptyParam,EmptyParam, EmptyParam,
        EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,EmptyParam,
        0);
      WorkBk := XLApp.WorkBooks.Item[IIndex];
      WorkSheet := WorkBk.WorkSheets.Item[NomePlanilha] as _WorkSheet;
      // In order to know the dimension of the WorkSheet, i.e the number of rows and the
      // number of columns, we activate the last non-empty cell of it
      WorkSheet.Activate(0);
      WorkSheet.Unprotect('ardiopsxmlans',0);
      WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
      // Get the value of the last row
      X := XLApp.ActiveCell.Row;
      // Get the value of the last column
      Y := XLApp.ActiveCell.Column;
      // Define the number of the columns in the TStringGrid
      // Assign the Variant associated with the WorkSheet to the Delphi Variant Matrix
      RangeMatrix := XLApp.Range['A1',XLApp.Cells.Item[X,Y]].Value2;
      WorkBk.Close(false,EmptyParam,EmptyParam,0);

//      XLApp.Quit;
//      XLApp.Disconnect;
    except
      on e: Exception do
      begin
        if PosEx(UpperCase(e.Message), UpperCase('ndice invlido')) > 0 then
          raise ECarregaArquivo.Create('A planilha "' + NomePlanilha + '" no foi encontrada.' +
                                       ' A estrutura do arquivo excel do Aplicativo Referncia no pode ser alterada.' +
                                       ' Desfaa a alterao ou reinstale o aplicativo para obter a planilha correta.' + chr(13) +
                                       'Verifique no manual o processo de reinstalao!')
        else
          raise ECarregaArquivo.Create('Problema de comunicao com o Excel.' + chr(13) + 'Tente Novamente!' + chr(13)
                                    + 'Se persistir o problema verifique o funcionamento do Excel.' + chr(13) + chr(13) + e.Message +
                                    chr(13) + '(' + NomePlanilha + ')');
      end;

     //  raise ECarregaArquivo.Create(e.Message + chr(13) + 'Problema de comunicao com o Excel. Tente Novamente!' + chr(13) + 'Se persistir o problema verifique o funcionamento do Excel.');
    end;
  finally
    // Quit Excel and Disconnect the Server
      XLApp.Quit;
      XLApp.Disconnect;
    FreeAndNil(XLApp);
  end;
end;

end.
