(*
 *
 * Arquivo...........: UfrmDlgProxy.pas
 * Projeto...........: DIOPS-XML
 * Descrio: Tela de obteno das configuraes do Proxy a ser utilizado nas trasmisses.
 * Os dados no so armazenados. Eles ficam somente em memria.
 *
 *)

unit UfrmDlgProxy;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TfrmDlgProxy = class(TForm)
    Label5: TLabel;
    Edit5: TEdit;
    Label6: TLabel;
    Edit6: TEdit;
    Edit7: TEdit;
    Label7: TLabel;
    Edit8: TEdit;
    Label8: TLabel;
    pnlLeft: TPanel;
    pnlBottom: TPanel;
    spbConfirmar: TSpeedButton;
    spbCancelar: TSpeedButton;
    imgDialogo: TImage;
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure spbCancelarClick(Sender: TObject);
    procedure spbConfirmarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDlgProxy: TfrmDlgProxy;

implementation

uses UMyMessageDlg, UfrmDlgGerarXML;

{$R *.dfm}

procedure TfrmDlgProxy.BitBtn2Click(Sender: TObject);
begin
  frmDlgGerarXML.chkUtilizarProxy.Checked := false;
  close;
end;

procedure TfrmDlgProxy.BitBtn3Click(Sender: TObject);
begin
  {Realiza a critica dos preenchimentos obrigatrios.
  Todos os dados devem ser preenchidos.}
  if trim(Edit5.Text) = '' then
  begin
    MyMessageDlg('O campo "Servidor" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  if trim(Edit6.Text) = '' then
  begin
    MyMessageDlg('O campo "Porta" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  if trim(Edit8.Text) = '' then
  begin
    MyMessageDlg('O campo "Usurio" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  if trim(Edit7.Text) = '' then
  begin
    MyMessageDlg('O campo "Senha" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  frmDlgGerarXML.Servidor := Edit5.Text;
  frmDlgGerarXML.Porta := Edit6.Text;
  frmDlgGerarXML.Usuario := Edit8.Text;
  frmDlgGerarXML.Senha := Edit7.Text;
  Self.Close;
end;

procedure TfrmDlgProxy.spbCancelarClick(Sender: TObject);
begin
  frmDlgGerarXML.chkUtilizarProxy.Checked := false;
  close;
end;

procedure TfrmDlgProxy.spbConfirmarClick(Sender: TObject);
begin
  {Realiza a critica dos preenchimentos obrigatrios.
  Todos os dados devem ser preenchidos.}
  if trim(Edit5.Text) = '' then
  begin
    MyMessageDlg('O campo "Servidor" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  if trim(Edit6.Text) = '' then
  begin
    MyMessageDlg('O campo "Porta" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  if trim(Edit8.Text) = '' then
  begin
    MyMessageDlg('O campo "Usurio" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  if trim(Edit7.Text) = '' then
  begin
    MyMessageDlg('O campo "Senha" deve ser definido.',mtError,[mbOK],0);
    exit;
  end;
  frmDlgGerarXML.Servidor := Edit5.Text;
  frmDlgGerarXML.Porta := Edit6.Text;
  frmDlgGerarXML.Usuario := Edit8.Text;
  frmDlgGerarXML.Senha := Edit7.Text;
  Self.Close;
end;

end.
