unit UfrmDlgGerarXML;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, Buttons, ToolEdit, Mask, ActnList, math,
  LbCipher, LbClass, DB, DBClient, JNI, ComCtrls, Registry, RxGIF, UUtilXML,
  IdGlobal, Menus, ToolWin, ActnMan, ActnCtrls, ActnMenus, ColorGrd, XPMan,
  uCarregarDados, uGerarDadosFinanceiros, RpDefine, RpRender, RpRenderPDF,
  RpBase, RpSystem, RpRave;

type
  EDadosFinanceiros = class(Exception);

  EGenerica = class(Exception);

  TMyThread = class(TThread)
  private
    form: TForm;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; frm: TForm);
  end;

  TfrmDlgGerarXML = class(TForm)
    GroupBox1: TGroupBox;
    imgLogo1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    dirFile: TFilenameEdit;
    dirDest: TDirectoryEdit;
    ActionList1: TActionList;
    actGerar: TAction;
    actSair: TAction;
    LbMD51: TLbMD5;
    GroupBox2: TGroupBox;
    chkEnviaXML: TCheckBox;
    chkUtilizarProxy: TCheckBox;
    ClientDataSet1: TClientDataSet;
    AnimeMontarXML: TAnimate;
    imgBotaoImprimir: TImage;
    ChkGeracaoArqXML: TCheckBox;
    rbtDadosCadastrais: TRadioButton;
    rbtDadosFinanceiros: TRadioButton;
    MainMenu1: TMainMenu;
    mnuAjuda: TMenuItem;
    mnuDuvidas: TMenuItem;
    Sobre1: TMenuItem;
    Informaes1: TMenuItem;
    N1: TMenuItem;
    Label3: TLabel;
    fneArquivoXML: TFilenameEdit;
    mnuStatus: TMenuItem;
    mnuPaginaStatus: TMenuItem;
    StatusBarXML: TStatusBar;
    pnlEsquerdo: TPanel;
    pnlBottom: TPanel;
    spbImprimeTela: TSpeedButton;
    spbCancelar: TSpeedButton;
    spbGerar: TSpeedButton;
    XPManifest1: TXPManifest;
    RvProject1: TRvProject;
    RvSystem1: TRvSystem;
    RvRenderPDF1: TRvRenderPDF;
    procedure ActionList1Update(Action: TBasicAction; var Handled: Boolean);
    procedure actSairExecute(Sender: TObject);
    procedure actGerarExecute(Sender: TObject);
    procedure chkUtilizarProxyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mnuDuvidasClick(Sender: TObject);
    procedure Sobre1Click(Sender: TObject);
    procedure Informaes1Click(Sender: TObject);
    procedure ChkGeracaoArqXMLClick(Sender: TObject);
    procedure mnuPaginaStatusClick(Sender: TObject);
    procedure spbCancelarClick(Sender: TObject);
    procedure spbImprimeTelaClick(Sender: TObject);
  private
    FUsuario: string;
    FSenha: string;
    FServidor: string;
    FPorta: string;
    OcorreuErro: Boolean;
    FHashPwd: string;
    FRegistro: string;
    { Private declarations }

    function maxLenght(const dado: string; const max: Integer): string;
    procedure SetPorta(const Value: string);
    procedure SetSenha(const Value: string);
    procedure SetServidor(const Value: string);
    procedure SetUsuario(const Value: string);

    function GetArquivo(tipo: string): string;
    procedure TransmitirXML;
    function getJVMdll(var Versao: string): string;
    function GetHashPwd: string;
    procedure SetHashPwd(const Value: string);

  public
    { Public declarations }
    property Servidor: string read FServidor write SetServidor; //Servidor Proxy
    property Porta: string read FPorta write SetPorta;       //Porta do Servidor Proxy
    property Usuario: string read FUsuario write SetUsuario; //Usurio do Servidor
    property Senha: string read FSenha write SetSenha;       //Senha do Servidor
    property HashPwd: string read GetHashPwd write SetHashPwd;
  end;

var
  frmDlgGerarXML: TfrmDlgGerarXML;
 
  {Thread que atualiza a interface durante a gerao dos XMLs.}
  myThread: TMyThread;

  //Variaveis usadas pelo JNI.
  JavaVM: TJavaVM;
  Options: array[0..4] of JavaVMOption;
  VM_args: JavaVMInitArgs;
  Errcode: Integer;
  JNIEnv: TJNIEnv;

implementation

uses
  Util, UfrmDlgProxy, UMyMessageDlgDiops, StrUtils, Shellapi, UfrmDlgHashPwd,
  uFrmSobre, ModBase;

var
  versaoAplicativo, nomeArquivo, teste: string;

{$R *.dfm}

procedure TfrmDlgGerarXML.ActionList1Update(Action: TBasicAction; var Handled: Boolean);
begin
  chkUtilizarProxy.Enabled := chkEnviaXML.Checked;
end;

procedure TfrmDlgGerarXML.actSairExecute(Sender: TObject);
begin
  if frmDlgProxy <> nil then
    FreeAndNil(frmDlgProxy);
  Application.Terminate;
end;

procedure TfrmDlgGerarXML.actGerarExecute(Sender: TObject);
var
  GerouArquivos: Boolean;
begin
  nomeArquivo := '';

  if (not rbtDadosFinanceiros.Checked) then
  begin
    MyMessageDlg('Selecione o tipo do arquivo a ser gerado.', mtInformation, [mbOk], 0);
    Exit;
  end;

  if (not ChkGeracaoArqXML.Checked) and (not chkEnviaXML.Checked) then
  begin
    MyMessageDlg('Selecione a ao desejada.', mtInformation, [mbOk], 0);
    Exit;
  end;

  if (trim(dirFile.Text) = '') and (ChkGeracaoArqXML.Checked) then
  begin
    MyMessageDlg('Selecione o arquivo Excel com seus dados.', mtInformation, [mbOk], 0);
    Exit;
  end;

  if (not FileExists(StringReplace(dirFile.Text, '"', '', [rfReplaceAll]))) and (ChkGeracaoArqXML.Checked) then
  begin
    MyMessageDlg('Arquivo no encontrado.', mtInformation, [mbOk], 0);
    Exit;
  end;

  if ChkGeracaoArqXML.Checked then
  begin
    if (trim(dirDest.Text) = '') then
    begin
       MyMessageDlg('Selecione a pasta de destino do(s) arquivo(s) XML.', mtInformation, [mbOk], 0);
       Exit;
    end;

    if (not DirectoryExists(dirDest.Text)) then
    begin
       MyMessageDlg('Diretrio de destino invlido.', mtInformation, [mbOk], 0);
       Exit;
    end;
  end;

  if chkEnviaXML.Checked and (not ChkGeracaoArqXML.Checked) and (trim(fneArquivoXML.Text) = '') then
  begin
    MyMessageDlg('Selecione o arquivo XML a ser enviado.', mtInformation, [mbOk], 0);
    Exit;
  end;

  OcorreuErro := false;
  GerouArquivos := false;

  if ChkGeracaoArqXML.Checked then
  begin
     StatusBarXML.Panels[0].Text := 'Gerando o arquivo XML...';
     AnimeMontarXML.Visible := true;
     self.Repaint;
     Screen.Cursor := crHourGlass;
     spbGerar.Enabled := false;

    //Carrega os dados da Planilha
    if not(uCarregarDados.lerDados(dirFile.Text, versaoAplicativo)) then
    begin
        MyMessageDlg('No foi possivel ler os dados da planilha Excel.', mtError, [mbOk], 0);
        OcorreuErro := true;
        Exit;
    end
    else 
       begin
           //Define o nome do arquivo a ser gerado
          nomeArquivo := dirDest.Text + '\' + Format('%s_FINANCEIRO_%s.xml', [StringReplace(DadosCadastrais[5, 2], '-', '', [rfReplaceAll]), FormatDateTime('yyyy-MM-dd_hhnnss', Now)]);

          //Gera o arquivo XML
          if uGerarDadosFinanceiros.GerarDadosF(nomeArquivo)then
          begin
            MyMessageDlg('Arquivo XML gerado com sucesso.', mtConfirmation, [mbOk], 0);
            GerouArquivos := true;
          end;
        end;
    end;

    if (chkEnviaXML.Checked) and (not OcorreuErro) then
    begin

      // se for gerar o arq XML, usurio entra com a senha junto ANS.
      frmDlgHashPwd := TFrmDlgHashPwd.Create(self);
      FrmDlgHashPwd.ShowModal;

      if FrmDlgHashPwd.ModalResult = mrOk then
      begin
        FUsuario := frmDlgHashPwd.edtLogin.Text;
        FSenha :=   frmDlgHashPwd.EdtSenha.Text;
        HashPwd := FSenha;
      end
      else
      begin
        FreeAndNil(FrmDlgHashPwd);
        HashPwd := '';
        exit;
      end;

      FreeAndNil(FrmDlgHashPwd);

      if trim(nomeArquivo) = '' then
        nomeArquivo := StringReplace(fneArquivoXML.Text, '"', '', [rfReplaceAll]);

      StatusBarXML.Panels[0].Text := 'Enviando os dados para ANS...';
      AnimeMontarXML.Visible := true;
      self.Repaint;
      TransmitirXML;
    end;

  StatusBarXML.Panels[0].Text := '';
  AnimeMontarXML.Visible := false;
  Screen.Cursor := crDefault;
  spbGerar.Enabled := true;

end;

//Coloca a inicial de uma palavra em maiscula e o resto em minscula
function InicialMaiuscula(palavra: string): string;
var
  aux: string;
begin
  aux := lowercase(palavra);
  result := StringReplace(aux, leftstr(aux, 1), UpperCase(leftstr(aux, 1)), []);
end;

{ TMyThread }
{*
* Objetivo...: Construtor da Thread.
*}
constructor TMyThread.Create(CreateSuspended: Boolean; frm: TForm);
begin
  inherited Create(CreateSuspended);
  Priority := tpNormal;
  form := frm;
end;

{*
* Objetivo...: Mtodo de execuo principal da Thread.
*}
procedure TMyThread.Execute;
begin
  inherited;
  while true do
  begin
    form.Repaint;
    Sleep(1500);
  end;
end;

procedure TfrmDlgGerarXML.chkUtilizarProxyClick(Sender: TObject);
begin
  if chkUtilizarProxy.Checked then
  begin
    if frmDlgProxy = nil then
      frmDlgProxy := TfrmDlgProxy.Create(self);
    frmDlgProxy.ShowModal;
  end
end;

procedure TfrmDlgGerarXML.SetPorta(const Value: string);
begin
  FPorta := Value;
end;

procedure TfrmDlgGerarXML.SetSenha(const Value: string);
begin
  FSenha := Value;
end;

procedure TfrmDlgGerarXML.SetServidor(const Value: string);
begin
  FServidor := Value;
end;

procedure TfrmDlgGerarXML.SetUsuario(const Value: string);
begin
  FUsuario := Value;
end;
// Retorna um string delimitado pelo max

function TfrmDlgGerarXML.maxLenght(const dado: string; const max: Integer): string;
var
  i: Integer;
  novaStr: string;
begin
  for i := 1 to max do
  begin
    novaStr := novaStr + dado[i];
  end;
  result := novaStr;
end;

procedure TfrmDlgGerarXML.TransmitirXML;
var
  aException: JThrowable;
  cls, clproxy: JClass;
  mid, proxy : JMethodID;
  obj: JObject;
  arquivo, strResult: string;
  result, arq, log: JString;

begin
 try
  arquivo := StringReplace(fneArquivoXML.Text, '\', '\\', [rfReplaceAll]);

  //Envio do arquivo Financeiro
  if (rbtDadosFinanceiros.Checked) and (trim(arquivo) <> '') then
  begin

    Cls := nil;
    Mid := nil;
    Obj := nil;
    clproxy := nil;
    proxy := nil;
    AException := nil;

    //Cria o diretrio do Recibo
    CreateDir(dirDest.Text + '\Recibo');

   //Carrega a classe java principal
    cls := JNIEnv.FindClass(PChar('br/gov/ans/diops/financeiro/api/DiopsFinanceiroClientJNI'));

    if cls = nil then
    begin
      MyMessageDlg('No foi possvel encontrar a classe DiopsFinanceiroClientJNI', mtError, [mbOK], 0);
      Exit;
    end;

    //Configurao do Proxy
    if chkUtilizarProxy.Checked then
    begin

      clproxy := JNIEnv.FindClass(PChar('br/gov/ans/diops/financeiro/api/DiopsFinanceiroClient'));
      proxy := JNIEnv.GetMethodID(clproxy, 'ativarProxy', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V');

      if proxy = nil then
      begin
        MyMessageDlg('No foi possvel encontrar o mtodo "ativarProxy" da classe DiopsFinanceiroClient', mtError, [mbOK], 0);
        Exit;
      end;
      //Chama o metodo ativarProxy
         JNIEnv.CallVoidMethod(Obj, proxy, [JNIEnv.StringToJString(PAnsiChar(FServidor)), JNIEnv.StringToJString(PAnsiChar(FPorta)), JNIEnv.StringToJString(PAnsiChar(FUsuario)), JNIEnv.StringToJString(PAnsiChar(FSenha))]);
    end;

    //Aloca o Objeto java
    obj := JNIEnv.AllocObject(cls);
    Arq := JNIEnv.StringToJString(PAnsichar(UTF8Encode(Arquivo)));
    Log := JNIEnv.StringToJString(PAnsichar(UTF8Encode(FSenha)));

    Mid := JNIEnv.GetMethodID(cls, 'enviar', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;');

    if Mid = nil then
    begin
      MyMessageDlg('No foi possvel encontrar o mtodo "enviar" da classe DiopsFinanceiroClientJNI', mtError, [mbOK], 0);
      Exit;
    end;

    result := JNIEnv.CallObjectMethod(obj, mid, [JNIEnv.StringToJString(PAnsiChar(arquivo)),JNIEnv.StringToJString(PAnsiChar(FUsuario)), JNIEnv.StringToJString(PAnsiChar(FSenha))]);
    strResult := JNIEnv.UnicodeJStringToString(result);

    if JNIEnv.ExceptionCheck = JNI_TRUE then
      MyMessageDlg ('Ocorreu uma exceo ao tentar conexo com o WebService do DIOPS-XML Financeiro.', mtWarning, [mbOK], 0);

    if strResult <> '' then
        MyMessageDlg(strResult, mtInformation, [mbOK], 0);

  end
  except
    on E: Exception do
       MyMessageDlg('Erro: ' + E.Message, mtError, [mbOK], 0);
  end;

end;

function TfrmDlgGerarXML.GetArquivo(tipo: string): string;
var
  Sr: TSearchRec;
  Lista: TStringList;
  i: Integer;
  arq: string;
begin
  Lista := TStringList.Create;
  FindFirst(dirDest.Text + '\*.*', faDirectory, sr);
  repeat
    if (faDirectory and sr.Attr) <= 0 then // arquivo
    begin
      if (AnsiPos('.XML', AnsiUpperCase(sr.Name)) > 0) and (AnsiPos('_' + AnsiUpperCase(Tipo) + '_', AnsiUpperCase(sr.Name)) > 0) and (UpperCase(RightStr(sr.Name, 4)) = '.XML') then
        lista.Add(sr.Name);
    end;
    i := FindNext(sr);
  until i <> 0;
  FindClose(Sr);

  if Lista.Count > 0 then
  begin
    Lista.Sort;

    for i := 0 to lista.Count - 1 do
      arq := Lista.Strings[i];

  end;
  Result := arq;
end;

function obterSistemaOperacional: string;
var
  majorVer, minorVer: Integer;
  osVerInfo: TOSVersionInfo;
begin
  osVerInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);

  if GetVersionEx(osVerInfo) then
  begin
    majorVer := osVerInfo.dwMajorVersion;
    minorVer := osVerInfo.dwMinorVersion;

    case osVerInfo.dwPlatformId of
      VER_PLATFORM_WIN32_NT: { Windows NT/2000 }
        begin
          if majorVer <= 4 then
            Result := 'Windows NT'
          else if (majorVer = 5) and (minorVer = 0) then
            Result := 'Windows 2000'
          else if (majorVer = 5) and (minorVer = 1) then
            Result := 'Windows XP'
          else
            Result := '';
        end;

      VER_PLATFORM_WIN32_WINDOWS:  { Windows 9x/ME }
        begin
          if (majorVer = 4) and (minorVer = 0) then
            Result := 'Windows 95'
          else if (majorVer = 4) and (minorVer = 10) then
          begin
            if osVerInfo.szCSDVersion[1] = 'A' then
              Result := 'Windows 98SE'
            else
              Result := 'Windows 98';
          end
          else if (majorVer = 4) and (minorVer = 90) then
            Result := 'Windows ME'
          else
            Result := '';
        end;
    else
      Result := '';
    end;
  end
  else
    Result := '';
end;

procedure TfrmDlgGerarXML.FormCreate(Sender: TObject);
var
  JVMDll, versao, pastaAtualJava, pastaAtualWindows: string;
begin
  versaoAplicativo := '4.1';
  Application.Title := 'DIOPS-XML - Aplicativo Referncia (2016 - v.' + versaoAplicativo + ') ';
  frmDlgGerarXML.Caption := Application.Title;

  //Obtm a pasta atual
  pastaAtualWindows := ExtractFilePath(application.ExeName);
  //Retira a barra do final
  pastaAtualWindows := leftstr(pastaAtualWindows, length(pastaAtualWindows) - 1);
  //Transforma para o padro Java de Path
  pastaAtualJava := AnsiReplaceStr(pastaAtualWindows, '\', '/');
  //////////////////////////////////////////////
  StatusBarXML.Panels[0].Text := '';
  AnimeMontarXML.Active := true;
  JVMDll := getJVMdll(versao);

  frmDlgGerarXML.Caption := Application.Title + ' {' + obterSistemaOperacional + ' - JRE ' + versao + '}';

  if (trim(JVMDll) = '') or (leftstr(versao, 3) < '1.6') then
  begin
    MyMessageDlg('No foi possvel localizar a instalao do Java 1.6 (Java Runtime Environment) ou superior.' + chr(13) + 'Desta forma o aplicativo no poder transmitir os arquivos para a ANS.' + chr(13) + 'Verifique o manual para maiores detalhes.', mtInformation, [mbOK], 0);
    chkEnviaXML.Enabled := False;
    fneArquivoXML.Enabled := False;
    Exit;
  end;

  try
    chdir(pastaAtualWindows);

    Errcode := -1;
    //Cria uma instancia de uma JVM
    JavaVM := TJavaVM.Create(JNI_VERSION_1_4, JVMDll);

    pastaAtualJava := '-Djava.class.path=' + 'DiopsFinanceiro-cliente.jar;';

    Options[0].optionString := pChar(pastaAtualJava);

    VM_args.version := JNI_VERSION_1_4;
    VM_args.options := @Options;
    VM_args.nOptions := 1;
    VM_args.ignoreUnrecognized := False;

    // Carrega a JVM
    Errcode := JavaVM.LoadVM(VM_args);
  except
    on e: Exception do
      MyMessageDlg('Erro ao tentar utilizar a Mquina Virtual Java:' + chr(13) + e.Message, mtError, [mbOK], 0);
  end;

  if Errcode < 0 then
  begin
    MyMessageDlg('No foi possvel criar uma instncia da Maquina Virtual Java. Desta forma no ser possivel transmitir os arquivos gerados.', mtError, [mbOK], 0);
    Exit;
  end;

  JNIEnv := TJNIEnv.Create(JavaVM.Env);
end;

//Procura uma determinada verso do Java no registro
procedure BuscaVersaoJava(Registro: TRegistry; iniVersao: string; var versaoCompleta: string);
var
  str: TStrings;
  i: integer;
begin
  try
    str := TStringList.Create;
    Registro.GetKeyNames(str);

    for i := 0 to str.Count - 1 do
    begin
      if LeftStr(str.Strings[i], length(iniVersao)) = iniVersao then
      begin
        versaoCompleta := str.Strings[i];
        break;
      end;
    end;
  finally
    str.Free;
  end;
end;

function TfrmDlgGerarXML.getJVMdll(var Versao: string): string;
var
  Registro: TRegistry;
begin
  Registro := TRegistry.Create;
  Registro.RootKey := HKEY_LOCAL_MACHINE;

  if registro.KeyExists('Software\JavaSoft') then
  begin
    if registro.KeyExists('Software\JavaSoft\Java Runtime Environment') then
    begin
      Registro.OpenKeyReadOnly('Software\JavaSoft\Java Runtime Environment');

      //Busca a verso corrente do JRE
      versao := registro.ReadString('CurrentVersion');

      if trim(versao) >= '1.6' then
      begin
        Registro.CloseKey;
        Registro.OpenKeyReadOnly('Software\JavaSoft\Java Runtime Environment\' + Versao);
        Result := registro.ReadString('RuntimeLib');
      end;

      Registro.CloseKey;
    end;

    if trim(versao) = '' then
    begin
      if registro.KeyExists('Software\JavaSoft\Java Development Kit') then
      begin
        Registro.OpenKeyReadOnly('Software\JavaSoft\Java Development Kit');
        //Busca a verso corrente do JDK
        versao := registro.ReadString('CurrentVersion');

        if trim(versao) <> '' then
        begin
          Registro.CloseKey;
          Registro.OpenKeyReadOnly('Software\JavaSoft\Java Development Kit\' + Versao);
          Result := registro.ReadString('JavaHome') + '\jre\bin\client\jvm.dll';
        end;

        Registro.CloseKey;
      end;
    end;
  end
  else
    Result := '';

  FreeAndNil(registro);
end;

function TfrmDlgGerarXML.GetHashPwd: string;
begin
  Result := uppercase(FHashPwd);
end;

procedure TfrmDlgGerarXML.SetHashPwd(const Value: string);
begin
  FHashPwd := Value;
end;

procedure TfrmDlgGerarXML.mnuDuvidasClick(Sender: TObject);
begin
  try
    shellexecute(handle, 'open', 'IEXPLORE.EXE', 'http://www.ans.gov.br/aplicativos-diops/financeiro', nil, sw_shownormal);

  except
    on e: Exception do
      MyMessageDlg('Erro ao tentar abrir o Internet Explorer: ' + chr(13) + e.Message, mtError, [mbOK], 0);
  end;
end;

procedure TfrmDlgGerarXML.Sobre1Click(Sender: TObject);
begin
  frmSobre := TFrmSobre.Create(self);
  frmSobre.ShowModal;
end;

procedure TfrmDlgGerarXML.Informaes1Click(Sender: TObject);
begin
  try
    shellexecute(handle, 'open', 'IEXPLORE.EXE', 'http://www.ans.gov.br/aplicativos-diops/financeiro/diops-xml-a-partir-de-2016', nil, sw_shownormal);
  except
    on e: Exception do
      MyMessageDlg('Erro ao tentar abrir o Internet Explorer: ' + chr(13) + e.Message, mtError, [mbOK], 0);
  end;
end;

procedure TfrmDlgGerarXML.ChkGeracaoArqXMLClick(Sender: TObject);
begin
  if ChkGeracaoArqXML.Checked then
  begin
    fneArquivoXML.Text := '';
    fneArquivoXML.Enabled := false;
  end
  else
    fneArquivoXML.Enabled := true;
end;

procedure TfrmDlgGerarXML.mnuPaginaStatusClick(Sender: TObject);
begin
  try
    shellexecute(handle, 'open', 'IEXPLORE.EXE', 'http://www.ans.gov.br/aplicativos-diops/consulta-de-diops-enviados', nil, sw_shownormal);
  except
    on e: Exception do
      MyMessageDlg('Erro ao tentar abrir o Internet Explorer: ' + chr(13) + e.Message, mtError, [mbOK], 0);
  end;
end;

procedure TfrmDlgGerarXML.spbCancelarClick(Sender: TObject);
begin
  if frmDlgProxy <> nil then
    FreeAndNil(frmDlgProxy);
  Application.Terminate;
end;

procedure TfrmDlgGerarXML.spbImprimeTelaClick(Sender: TObject);
begin
  frmModBase.ImprimeTela;
end;

end.




