(*
 *
 * Arquivo...........: UUtilXML.pas
 * Projeto...........: DIOPS-XML
 * Descrio: Biblioteca para manupulao de XMLs
 *
 *)

 unit UUtilXML;

interface

uses
  SysUtils, Classes, StdCtrls, MSXML_TLB, ComObj, Dialogs,XMLDoc,LbCipher,JclStrings, LbClass;

type
  EGenerica = class (Exception);

  TXMLGenerator = class(TComponent)
  private
    FDocument: IXMLDOMDocument;
    FRoot: IXMLDOMNode;
    FCurrentNode: IXMLDOMNode;
    FdocType:String;
    FSchema:String;
    //Contedo do XML para gerar o Hash
    ConteudoHash:String;
    function GetRootName: string;
    procedure SetDocument(const Value: IXMLDOMDocument);
    procedure SetRoot(const Value: IXMLDOMNode);
    procedure SetCurrentNode(const Value: IXMLDOMNode);
  public
    constructor Create(AOwner: TComponent); overload; override;
    constructor Create(const ARoot: string; const docType:String; const Schema:String); reintroduce; overload;
    destructor Destroy; reintroduce;

    // Retorna um n
    function FindNode(const NodeName: string): IXMLDOMNode;
    // Adiciona um n dentro do NodeRoot
    function AddNode(const NodeName: string; AddingText: Boolean = False; NodeRootName: string = ''): IXMLDOMNode;
    function AddNodeAttribute(const NodeName: string; AddingText: Boolean = False; NodeRootName: string = ''; NodeAttributeName: string = ''; NodeAttributeValue: string = ''): IXMLDOMNode;
    // Adiciona um texto dentro do NodeRoot
    procedure AddText(const NodeName, AText: string; NodeRootName: string = '');
    // Adiciona um nmero real com pelo menos uma casa decimal sempre
    procedure AddNumber(const NodeName, AText: string; NodeRootName: string = '');
    // Atribui ao n corrente o n que estiver acima com o nome passado
    procedure AddBoolean(const NodeName, AText: string; NodeRootName: string = '');
    procedure LevelUpNode(const NodeName: string);
    // Salva o XML
    procedure SaveToFile(const FileName: string);
    // Destri o objeto
    procedure Free;

    function CriaHashXML:String; overload;
    // para o novo campo HashPwd
    function CriaHashXML(const Value: String):String; overload;

    // Documento XML
    property Document: IXMLDOMDocument read FDocument write SetDocument;
    // Raiz do XML
    property Root: IXMLDOMNode read FRoot write SetRoot;
    // Nome da raiz
    property RootName: string read GetRootName;
    // N corrente. A menos q seja alterado, retorna o ltimo n adicionado.
    property CurrentNode: IXMLDOMNode read FCurrentNode write SetCurrentNode;
  end;

  TUtilXML = class
  private
    xml:IXMLDOMDocument;
    completePath:String;
    nodeList : IXMLDOMNodeList;
    subNodeList : IXMLDOMNodeList;
    nodeAuxList : IXMLDOMNodeList;
    nodeAux : IXMLDOMNode;
    currentNode : IXMLDOMNode;
    currentSubNode : IXMLDOMNode;
    currentNodeList : Integer;
    currentSubNodeList : Integer;
    currentNodeAuxList : Integer;

    Resultado : TStringList;
    tempNode : IXMLDOMNode;
    function getSubNodeValue(node : IXMLDOMNodeList):String;overload;
    function getSubNodeValue(node : IXMLDOMNodeList;path:String):String;overload;
    function getSubNodeValueByParent(node : IXMLDOMNodeList;nodeParentName:String):String;
    function getCompletePath(node : IXMLDOMNode):String;
    function searchNode(node : IXMLDOMNode; name:String):IXMLDOMNode;

  public
    //Construtor da classe.
    constructor create;
    destructor destroy();override;
    //Le o xml do disco
    procedure loadFile(fileName:String);
    //Define um conjunto de nos com o mesmo nome a ser usado
    procedure setListNodes(name: string);overload;
    //Define um conjunto de sub nos com o mesmo nome a ser usado a partir do no pai
    procedure setSubListNodes (name: string);
    //Muda o sub no corrente
    procedure nextSubNode;
    //Muda o no pai corrente
    procedure nextNode;
    //Total de nos encontrados
    function getCurrentNodeList:Integer;
    //Total de sub nos encontrados
    function getSubCurrentNodeList:Integer;
    //Retorna o valor de um sub no do no pai
    function getCurrentChildValue (name:string):string;
    //Retorna os valores de todos os sub nos
    function getCurrentChildValues:String;
    //Retorna o valor de um campo do no pais
    function getCurrentNodeValues (name:string):String;
    //Retorna o valor o valor de um sub no da lista de sub nos pai
    function getCurrentChildSubNodeValue(name:string):string;overload;

    //Retorna a referencia para uma lista de nos filhos de um determinado no
    function getSubNodeListRef(name:String): IXMLDOMNodeList;
    //Retorna o valor de um no passado como parametro
    function getCurrentChildSubNodeValue(node : IXMLDOMNode; name:String):string;overload;

    procedure nextNodeAux;
    procedure setAuxListNodes (node:IXMLDOMNodeList);
    function getCurrentChildAuxNodeValue(name:string):string;
    function getCurrentNodeAuxList:Integer;

    function getAllXMLValues(const RootName: string): TStringList;

    procedure SaveToFile(arquivo:String);

    procedure setListNodes(partner,name: string);overload;
    function getCurrentSubNodeValues (name:string):String;
    function getNodeValue(nodeName:String):String;overload;
    function getNodeValue(nodeName:String;path:String):String;overload;
    function getNodeValueByParent(nodeName,nodeParentName:String):String;
end;

implementation

{ TXMLGenerator }

uses XSDParseManager, StrUtils;

function ByteArrayToStr(x: TMD5Digest): string;
var
  s: string;
  h, j: integer;
Const
  HexChars: Array[0..15] of Char = ('0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f');
begin
  h := 0;
  s := '';

  while h <= 15 do
  begin
    j := x[h] and $FF;

    s := s + HexChars[j div 16];
    s := s + HexChars[j mod 16];

    Inc(h) ;
  end;
  Result := s;
end;


function TXMLGenerator.AddNode(const NodeName:string; AddingText: Boolean = False;
  NodeRootName: string = ''): IXMLDOMNode;
var
  Node: IXMLDOMElement;
  NodeRoot: IXMLDOMNode;
begin
  Node := Document.createElement(NodeName);
  if NodeRootName = '' then
    CurrentNode.appendChild(Node)
  else
  begin
    NodeRoot := FindNode(NodeRootName);
    if NodeRoot <> nil then
      NodeRoot.appendChild(Node);
  end;
  if not AddingText then
    CurrentNode := Node;
  Result := Node;
end;

procedure TXMLGenerator.AddText(const NodeName, AText: string; NodeRootName: string = '');
var
  AuxAtext: String;
  XSDParser: TXSDParseManager;
begin
  XSDParser := TXSDParseManager.Create(Self);
  try
    AuxAtext := XSDParser.ExecuteParse(NodeName, trim(AText));
    AddNode(NodeName, True, NodeRootName).Text := trim(AuxAtext);
    
    //Guarda o conteudo pra gerar o hash.
    ConteudoHash := ConteudoHash + trim(AuxAtext);
  finally
    XSDParser.Free;
  end;
end;

//Verifica se um valor  um ponto flutuante vlido
function DecimalValido(valor: string): boolean;
    var fvalor: double;
begin
    try
         fvalor := strtofloat(valor);
         result := true;
    except
        on E: Exception do
        begin
            result := false;
        end;
    end;
end;

//Adiciona um nmero real com pelo menos uma casa decimal sempre.
procedure TXMLGenerator.AddNumber(const NodeName, AText: string; NodeRootName: string = '');
var
  AuxAtext, AuxAtext1: String;
  XSDParser: TXSDParseManager;
begin
  XSDParser := TXSDParseManager.Create(Self);

  try
    AuxAtext := XSDParser.ExecuteParse(NodeName, trim(AText));

    if trim(AuxAtext)='' then
        AuxAtext := '0.0'
    else if (pos('.', AuxAtext)=0) then
    begin
        if DecimalValido(AuxAtext) then
            AuxAtext := AuxAtext + '.0'
        else
            raise EGenerica.Create('O valor "' + AuxAtext + '" no  um nmero vlido, verifique na planilha.');
    end
    //Retira o 0 menos significativo
    else if (pos('.', AuxAtext)<>0) then
    begin
        AuxAtext1 := AuxAtext;
        StrReplace(AuxAtext1,'.',',');

        if DecimalValido(AuxAtext1) then
            AuxAtext := leftstr(AuxAtext, pos('.', AuxAtext) + 2)
        else
            raise EGenerica.Create('O valor "' + AuxAtext + '" no  um nmero vlido, verifique na planilha.');

        if (RightStr(AuxAtext,1)='0') then
            AuxAtext := copy(AuxAtext,0,length(AuxAtext)-1);
    end;

    AddNode(NodeName, True, NodeRootName).Text := trim(AuxAtext);
    //Guarda o conteudo pra gerar o hash.
    ConteudoHash := ConteudoHash + trim(AuxAtext);

  finally
    XSDParser.Free;
  end;
end;

procedure TXMLGenerator.AddBoolean(const NodeName, AText: string; NodeRootName: string = '');
begin
    AddNode(NodeName, True, NodeRootName).Text := trim(AText);

    //Guarda o conteudo pra gerar o hash.
    ConteudoHash := ConteudoHash + trim(AText);
end;

constructor TXMLGenerator.Create(const ARoot: string; const docType:String; const Schema:String);
begin
  FSchema := Schema;
  FDocument := CreateOleObject('Microsoft.XMLDOM') as IXMLDomDocument;
  FRoot := Document.createElement(ARoot);
  FdocType := {'<?xml version="1.0" encoding="UTF-8" standalone="no"?>'+} docType;
  Document.appendChild(FRoot);
  CurrentNode := Root;
  ConteudoHash := '';
end;


constructor TXMLGenerator.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);;
  ConteudoHash := '';
end;

function TXMLGenerator.CriaHashXML: String;
var
  BuiltHash: string;
  bla: TMD5Digest;
  LbMD5: TLbMD5;

  XMLList: TStringList;
  util: TUtilXML;

begin
  LbMD5 := TLbMD5.Create(nil);

  try

    util := TUtilXML.create;
    XMLList := util.getAllXMLValues(FDocument.documentElement.tagName);

    XMLList.Add(ConteudoHash);

    LbMD5.HashString(ConteudoHash);
    LbMD5.GetDigest(bla);
    BuiltHash := ByteArrayToStr(bla);
    Result := BuiltHash;

  finally
    FreeAndNil(LbMD5);
  end;
end;


destructor TXMLGenerator.Destroy;
begin
end;

function TXMLGenerator.FindNode(const NodeName: string): IXMLDOMNode;
begin
  Result := Root.selectSingleNode(NodeName);
end;

procedure TXMLGenerator.Free;
begin
  if Self <> nil then
    Destroy;
end;

function TXMLGenerator.GetRootName: string;
begin
  Result := Root.nodeName;
end;

procedure TXMLGenerator.LevelUpNode(const NodeName: string);
begin
   while not (CurrentNode.nodeName = NodeName) do
    CurrentNode := CurrentNode.parentNode;
end;

procedure TXMLGenerator.SaveToFile(const FileName: string);
var //xml:TXMLDocument;
  arq:TextFile;
  xml:String;
begin
  AssignFile(arq,FileName);
  xml:= Document.xml;

  xml := StringReplace(xml, '><', '>' + chr(13) + '<', [rfReplaceAll, rfIgnoreCase]);

  Rewrite(arq); //abre o arquivo para escrita

  Writeln(arq,'<?xml version="1.0" encoding="ISO-8859-1"?>'); //escreve no arquivo e desce uma linha

  Writeln(arq,FdocType); //escreve no arquivo e desce uma linha

  if trim(FSchema)<>'' then
  begin
    Writeln(arq,FSchema); //escreve no arquivo e desce uma linha
    Writeln(arq,copy(xml,(pos('>',xml)+1),length(xml))); //escreve no arquivo e desce uma linha
  end
  else
    Writeln(arq,xml); //escreve no arquivo e desce uma linha

  Closefile(arq); //fecha o handle de arquivo

end;

procedure TXMLGenerator.SetCurrentNode(const Value: IXMLDOMNode);
begin
  FCurrentNode := Value;
end;

procedure TXMLGenerator.SetDocument(const Value: IXMLDOMDocument);
begin
  FDocument := Value;
end;

procedure TXMLGenerator.SetRoot(const Value: IXMLDOMNode);
begin
  FRoot := Value;
end;

function TXMLGenerator.CriaHashXML(const Value: String): String;
var
  BuiltHash: string;
  bla: TMD5Digest;
  LbMD5: TLbMD5;
begin
 
  LbMD5 := TLbMD5.Create(self);

  try

    LbMD5.HashString(Value);
    LbMD5.GetDigest(bla);
    BuiltHash := ByteArrayToStr(bla);
    Result := BuiltHash;
  finally
    FreeAndNil(LbMD5);
  end;

end;

function TXMLGenerator.AddNodeAttribute(const NodeName: string;
  AddingText: Boolean; NodeRootName, NodeAttributeName: string;
  NodeAttributeValue: string): IXMLDOMNode;
var
  Node: IXMLDOMElement;
  NodeRoot: IXMLDOMNode;
begin
  Node := Document.createElement(NodeName);
  Node.setAttribute(NodeAttributeName, NodeAttributeValue);

  if NodeRootName = '' then
    CurrentNode.appendChild(Node)
  else
  begin
    NodeRoot := FindNode(NodeRootName);
    if NodeRoot <> nil then
      NodeRoot.appendChild(Node);
  end;
  if not AddingText then
    CurrentNode := Node;
  Result := Node;
end;

{ TUtilXML }

constructor TUtilXML.create;
begin
  xml := CreateOleObject('Microsoft.XMLDOM') as IXMLDomDocument;
  currentNodeList:= 0;
  currentSubNodeList := 0;
  tempNode := nil;
  Resultado := TStringList.Create;
end;

destructor TUtilXML.destroy;
begin
  inherited;
end;

function TUtilXML.getNodeValue(nodeName: String): String;
var node : IXMLDOMNodeList;
    j, tot : Integer;
    temp: string;
begin
  node:= xml.getElementsByTagName(nodeName);
  tot := node.Get_length;
  for j:=0 to tot-1 do
  begin
  //node type 1 means an entity and node type 5 means EntityRef
  if((node.Get_item(j).Get_nodeType= 1) or (node.Get_item(j).Get_nodeType=5)) then
    result := getSubNodeValue(node.Get_item(j).Get_childNodes)
    //node Type 3 means a text node,ie you find the data
    else if(node.Get_item(j).Get_nodeType=3)then
    begin
      temp:= trim(node.Get_item(j).Get_nodeValue);
      if result <>'' then
        result:=result+';'+temp
      else
        result:=temp;
    end
  end;
end;

function TUtilXML.getCompletePath(node: IXMLDOMNode): String;
begin
  if node.parentNode.nodeName<>'#document' then
  begin
    if(node.nodeName<>'#text')then
      completePath := node.nodeName+';'+completePath ;
    getCompletePath(node.parentNode);
  end
  else
  begin
    if(node.nodeName<>'#text')then
      completePath := node.nodeName+';'+completePath ;
  end;
  result := completePath;
end;

function TUtilXML.getNodeValue(nodeName, path: String): String;
var node : IXMLDOMNodeList;
    j, tot : Integer;
    temp: string;
begin
  if path[length(path)]=';' then
    path := path + nodeName + ';'
  else
    path := path +';'+ nodeName + ';';
  node:= xml.getElementsByTagName(nodeName);
  tot := node.Get_length;
  for j:=0 to tot-1 do
  begin
  completePath :='';
  //node type 1 means an entity and node type 5 means EntityRef
  if((node.Get_item(j).Get_nodeType= 1) or (node.Get_item(j).Get_nodeType=5)) then
    result := getSubNodeValue(node.Get_item(j).Get_childNodes, path)
    //node Type 3 means a text node,ie you find the data
    else if(node.Get_item(j).Get_nodeType=3) and(path=getCompletePath(node.item[j])) then
    begin
      temp:= trim(node.Get_item(j).Get_nodeValue);
      if result <>'' then
        result:=result+';'+temp
      else
        result:=temp;
    end
  end;
end;

function TUtilXML.getSubNodeValue(node: IXMLDOMNodeList): String;
var j, tot, tipo: Integer;
    temp: string;
begin
  tot := node.Get_length;
  for j:=0 to tot-1 do
  begin
  //node type 1 means an entity and node type 5 means EntityRef
    tipo:= node.Get_item(j).nodeType;
    if((tipo= 1) or (tipo=5)) then
    begin
      Result := getSubNodeValue(node.Get_item(j).Get_childNodes);
      if (node.Get_item(j).Get_childNodes.length = 0)then
      begin
        Resultado.Add('');
        Result := Result+'<>';
      end
    end
    else if(tipo=3) then
    begin
      temp:= node.Get_item(j).Get_nodeValue;
      Resultado.Add(temp);
      if result <>'' then
        result:=result+Format('<%s>', [temp])
      else
        result:=Format('<%s>', [temp]);
    end;

  end;
end;

function TUtilXML.getSubNodeValue(node: IXMLDOMNodeList;
  path: String): String;
var j, tot : Integer;
    temp: string;
begin
  tot := node.Get_length;
  for j:=0 to tot-1 do
  begin
  //node type 1 means an entity and node type 5 means EntityRef
  if((node.Get_item(j).Get_nodeType= 1) or (node.Get_item(j).Get_nodeType=5)) then
    result := getSubNodeValue(node.Get_item(j).Get_childNodes)
    //node Type 3 means a text node,ie you find the data
    else if(node.Get_item(j).Get_nodeType=3) and (path=getCompletePath(node.item[j]))then
    begin
      temp:= trim(node.Get_item(j).Get_nodeValue);
      if result <>'' then
        result:=result+';'+temp
      else
        result:=temp;
    end
  end;
end;

procedure TUtilXML.loadFile(fileName:String);
begin
  xml.load(fileName);
end;

function TUtilXML.getNodeValueByParent(nodeName,
  nodeParentName: String): String;
var node : IXMLDOMNodeList;
    j, tot : Integer;
    temp: string;
begin
  node:= xml.getElementsByTagName(nodeName);
  tot := node.Get_length;
  for j:=0 to tot-1 do
  begin
  //node type 1 means an entity and node type 5 means EntityRef
  if((node.Get_item(j).Get_nodeType= 1) or (node.Get_item(j).Get_nodeType=5)) then
    result := getSubNodeValueByParent(node.Get_item(j).Get_childNodes,nodeParentName)
    //node Type 3 means a text node,ie you find the data
    else if(node.Get_item(j).Get_nodeType=3)and(node.Get_item(j).parentNode.nodeName=nodeParentName)  then
    begin
      temp:= trim(node.Get_item(j).Get_nodeValue);
      if result <>'' then
        result:=result+';'+temp
      else
        result:=temp;
    end
  end;
end;

function TUtilXML.getSubNodeValueByParent(node: IXMLDOMNodeList;
  nodeParentName: String): String;
var j, tot : Integer;
    temp: string;
begin
  tot := node.Get_length;
  for j:=0 to tot-1 do
  begin
  //node type 1 means an entity and node type 5 means EntityRef
  if((node.Get_item(j).Get_nodeType= 1) or (node.Get_item(j).Get_nodeType=5)) then
    result := getSubNodeValue(node.Get_item(j).Get_childNodes)
    //node Type 3 means a text node,ie you find the data
    else if(node.Get_item(j).Get_nodeType=3) and((node.item[j].parentNode).parentNode.nodeName=nodeParentName) then
    begin
      temp:= trim(node.Get_item(j).Get_nodeValue);
      if result <>'' then
        result:=result+';'+temp
      else
        result:=temp;
    end
  end;
end;

procedure TUtilXML.nextNode;
begin
  currentNode:= nodeList.nextNode;
end;

function TUtilXML.getCurrentNodeValues(name: string): String;
  var tempNode : IXMLDOMNode;
  path:string;
begin
  if currentNode <> nil then
  begin
    completePath :='';
    path := getCompletePath(currentNode);
    path := copy(path,0,length(path)-1);
    if name <> '' then
      path := '/'+StringReplace(path,';','/',[rfReplaceAll])+'/'+name
    else
      path := '/'+StringReplace(path,';','/',[rfReplaceAll]);
    tempNode := currentNode.selectSingleNode(path);
    if (tempNode <>nil) then
      result := tempNode.text
    else
      result := '';
  end
  else
    result := '';
end;

procedure TUtilXML.setListNodes(name: string);
begin
  nodeList:= xml.getElementsByTagName(name);
  currentNodeList := nodeList.length;
  if currentNodeList > 0 then
    currentNode := nodeList.item[0];
end;

function TUtilXML.getCurrentNodeList: Integer;
begin
  result := currentNodeList;
end;

procedure TUtilXML.setListNodes(partner, name: string);
  var tempNode : IXMLDOMNode;
    path: string;
begin
  if currentNode <> nil then
  begin
    tempNode := currentNode.selectSingleNode(partner);
    path := getCompletePath(tempNode);
    path := copy(path,0,length(path)-1);
    path := '/'+StringReplace(path,';','/',[rfReplaceAll])+'/'+name;
    nodeList := currentNode.selectNodes(path);
  end
end;

procedure TUtilXML.nextSubNode;
begin
  currentSubNode:= subNodeList.nextNode;
end;

procedure TUtilXML.setSubListNodes(name: string);
  var count : Integer;
begin
  currentSubNodeList := 0;
  if currentNode <> nil then
  begin
    currentSubNode := nil;
    for count := 0 to currentNode.childNodes.length-1 do
    begin
      currentSubNode:= searchNode(currentNode.childNodes.item[count],name);
      if currentSubNode <> nil then
      begin
        subNodeList:=currentSubNode.parentNode.childNodes;
        subNodeList.nextNode;
        currentSubNodeList := subNodeList.length;
        Break;
      end;
    end;
  end
end;

function TUtilXML.getSubCurrentNodeList: Integer;
begin
  result := currentSubNodeList;
end;

function TUtilXML.getCurrentSubNodeValues(name: string): String;
  var tempNode : IXMLDOMNode;
  path:string;
begin
  if currentSubNode <> nil then
  begin
    completePath :='';
    path := getCompletePath(currentSubNode);
    path := copy(path,0,length(path)-1);
    if(name<>'') then
      path := '/'+StringReplace(path,';','/',[rfReplaceAll])+'/'+name
    else
      path := '/'+StringReplace(path,';','/',[rfReplaceAll]);
    tempNode := currentSubNode.selectSingleNode(path);
    if (tempNode <>nil) then
      result := tempNode.text
    else
      result := '';
  end
  else
    result := '';
end;


function TUtilXML.getCurrentChildValues: String;
begin
  result := '';
//  result := currentNode.text;
  if currentSubNode <> nil then
    result := getSubNodeValue(currentSubNode.childNodes);
end;

function TUtilXML.getCurrentChildValue(name: string): string;
  var nodetmp : IXMLDOMNode;
    count : Integer;
begin
  if currentNode <> nil then
  begin
    for count := 0 to currentNode.childNodes.length-1 do
    begin
      nodetmp:= searchNode(currentNode.childNodes.item[count],name);
      if nodetmp <> nil then
        result := nodetmp.text
      else
        Result := '';
      if result <>'' then Break;
    end;
  end
  else
    result:= '';
end;

function TUtilXML.searchNode(node: IXMLDOMNode; name: String): IXMLDOMNode;
var count : Integer;
begin
  //testa se o node atual  o desejado. Caso contrario faz a recursividade
  if (node.nodeName = name) then
    result := node
  else
  begin
    for count := 0 to node.childNodes.length-1 do
    begin
      result := nil;
      result := searchNode(node.childNodes.item[count],name);
      if result <> nil then Break;
    end;
  end;
end;

function TUtilXML.getCurrentChildSubNodeValue(name: string): string;
var count:Integer;
  nodetmp : IXMLDOMNode;
begin
  if currentSubNode <> nil then
  begin
    for count := 0 to currentSubNode.childNodes.length-1 do
    begin
      nodetmp:= searchNode(currentSubNode.childNodes.item[count],name);
      if nodetmp <> nil then
        result := nodetmp.text
      else
        Result := '';
      if result <>'' then Break;
    end;
  end
  else
    result:= '';

end;

function TUtilXML.getSubNodeListRef(name: String): IXMLDOMNodeList;
var count:Integer;
  nodetmp : IXMLDOMNode;
begin
  result := nil;
  if currentSubNode <> nil then
  begin
    for count := 0 to currentSubNode.childNodes.length-1 do
    begin
      nodetmp:= searchNode(currentSubNode.childNodes.item[count],name);
      if nodetmp <> nil then
        result := nodetmp.childNodes
      else
        Result := nil;
      if result <>nil then Break;
    end;
  end
  else
    result := nil;
end;

function TUtilXML.getCurrentChildSubNodeValue(node: IXMLDOMNode;
  name: String): string;
var count:Integer;
  nodetmp : IXMLDOMNode;
begin
  if node <> nil then
  begin
    for count := 0 to node.childNodes.length-1 do
    begin
      nodetmp:= searchNode(node.childNodes.item[count],name);
      if nodetmp <> nil then
        result := nodetmp.text
      else
        Result := '';
      if result <>'' then Break;
    end;
  end
  else
    result:= '';
end;

procedure TUtilXML.nextNodeAux;
begin
  nodeAux:= nodeAuxList.nextNode;
end;

procedure TUtilXML.setAuxListNodes(node:IXMLDOMNodeList);
begin
  nodeAuxList := node;
  currentNodeAuxList := nodeAuxList.length;
  if currentNodeAuxList >=1 then
    nodeAux := nodeAuxList.item[0];
  nodeAuxList.nextNode;
end;

function TUtilXML.getCurrentChildAuxNodeValue(name: string): string;
var count:Integer;
  nodetmp : IXMLDOMNode;
begin
  if nodeAux <> nil then
  begin
    for count := 0 to nodeAux.childNodes.length-1 do
    begin
      nodetmp:= searchNode(nodeAux.childNodes.item[count],name);
      if nodetmp <> nil then
        result := nodetmp.text
      else
        Result := '';
      if result <>'' then Break;
    end;
  end
  else
    result:= '';

end;

function TUtilXML.getCurrentNodeAuxList: Integer;
begin
  result := currentNodeAuxList;
end;

procedure TUtilXML.SaveToFile(arquivo: String);
begin
  xml.save(arquivo);
end;

function TUtilXML.getAllXMLValues(const RootName: string): TStringList;
begin
  Resultado.Clear;
  getSubNodeValue(xml.getElementsByTagName(RootName));
  Result := Resultado;
end;

end.
