/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.diops.financeiro.api;

import br.gov.ans.diops.financeiro.handler.XsdErrorHandler;
import br.gov.ans.ws.diops.financeiro.v2016.DiopsException;
import br.gov.ans.ws.diops.financeiro.v2016.DiopsFinanceiroWS;
import br.gov.ans.ws.diops.financeiro.v2016.DiopsFinanceiroWSService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.BindingProvider;
import org.xml.sax.SAXException;

public class DiopsFinanceiroClient {
    protected static final String XSD = "http://www.ans.gov.br/padroes/diops/2016/schemas/Diops2016.xsd";
    protected Map<String, String> proxy;

    public boolean proxyAtivo() {
        return this.proxy != null;
    }

    public void desativarProxy() {
        this.proxy = null;
    }

    public void ativarProxy(String servidor, String porta, String usuario, String senha) {
        if (this.proxy == null) {
            this.proxy = new HashMap<String, String>();
        }
        this.proxy.put("http.proxySet", "true");
        this.proxy.put("http.proxyHost", servidor);
        this.proxy.put("http.proxyPort", porta);
        if (usuario != null) {
            this.proxy.put("http.proxyUser", usuario);
        }
        if (senha != null) {
            this.proxy.put("http.proxyPassword", senha);
        }
    }

    public String enviar(String diops, String usuario, String senha) throws IOException, NoSuchAlgorithmException, SAXException, DiopsException {
        Path path = Paths.get(diops, new String[0]);
        this.validarContraXSD(path.toFile());
        byte[] data = Files.readAllBytes(path);
        String hash = this.getHash(path.toFile());
        if (this.proxyAtivo()) {
            for (String k : this.proxy.keySet()) {
                System.setProperty(k, this.proxy.get(k));
            }
        }
        DiopsFinanceiroWSService service = new DiopsFinanceiroWSService();
        DiopsFinanceiroWS port = service.getDiopsFinanceiroWSPort();
        BindingProvider provider = (BindingProvider)port;
        Map requestContext = provider.getRequestContext();
        requestContext.put("javax.xml.ws.security.auth.username", usuario);
        requestContext.put("javax.xml.ws.security.auth.password", senha);
        return port.enviar(data, hash);
    }

    protected void validarContraXSD(File f) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new URL(XSD));
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new XsdErrorHandler());
        validator.validate(new StreamSource(f));
    }

    protected String getHash(File f) throws NoSuchAlgorithmException, IOException {
        int length;
        FileInputStream in = new FileInputStream(f);
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        byte[] block = new byte[4096];
        while ((length = ((InputStream)in).read(block)) > 0) {
            digest.update(block, 0, length);
        }
        ((InputStream)in).close();
        return DatatypeConverter.printHexBinary((byte[])digest.digest());
    }
}

