unit UfrmDlgEnviarXML;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, Buttons, ToolEdit, Mask, ActnList,  math,
  LbCipher, LbClass, DB, DBClient, JNI, ComCtrls, Registry, RxGIF, UUtilXML, IdGlobal,
  Menus, ToolWin, ActnMan, ActnCtrls, ActnMenus, ColorGrd;

type
  EDadosFinanceiros = class (Exception);
  EGenerica = class (Exception);

  TMyThread = class(TThread)
  private
    form: TForm;
  protected
     procedure Execute; override;
  public
     constructor Create(CreateSuspended: Boolean;frm:TForm );
  end;

  TfrmDlgEnviarXML = class(TForm)
    GroupBox1: TGroupBox;
    imgLogo1: TImage;
    Label2: TLabel;
    dirDest: TDirectoryEdit;
    ActionList1: TActionList;
    actGerar: TAction;
    actSair: TAction;
    LbMD51: TLbMD5;
    ClientDataSet1: TClientDataSet;
    animeEnviarXML: TAnimate;
    imgBotaoImprimir: TImage;
    rbtDadosCadastrais: TRadioButton;
    rbtDadosFinanceiros: TRadioButton;
    MainMenu1: TMainMenu;
    mnuAjuda: TMenuItem;
    mnuDuvidas: TMenuItem;
    Sobre1: TMenuItem;
    Informaes1: TMenuItem;
    N1: TMenuItem;
    Label3: TLabel;
    dirArquivoXML: TFilenameEdit;
    mnuStatus: TMenuItem;
    mnuPaginaStatus: TMenuItem;
    StatusBarXML: TStatusBar;
    pnlEsquerdo: TPanel;
    chkUtilizarProxy: TCheckBox;
    pnlBottom: TPanel;
    spbGerar: TSpeedButton;
    procedure actGerarExecute(Sender: TObject);
    procedure chkUtilizarProxyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mnuDuvidasClick(Sender: TObject);
    procedure Sobre1Click(Sender: TObject);
    procedure Informaes1Click(Sender: TObject);
    procedure mnuPaginaStatusClick(Sender: TObject);
    procedure spbCancelarClick(Sender: TObject);
    procedure spbImprimeTelaClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FUsuario: String;
    FSenha: String;
    FSevidor: String;
    FPorta: String;
    OcorreuErro:Boolean;
    FHashPwd: String;
    { Private declarations }

    function maxLenght(const dado: String; const max: Integer):String ;
    procedure SetPorta(const Value: String);
    procedure SetSenha(const Value: String);
    procedure SetSevidor(const Value: String);
    procedure SetUsuario(const Value: String);
    function LeftMask(const Value: String; ALength: Word): String;
    function LeftMaskContaBalancete(const Value: String; ALength: Word): String;
    function ChangeMaskFormat(const Value, OldChar, NewChar: String): String;
    function BuidFormatation(ALength: Word): String;
    function GetArquivo(tipo:String):String;
    function getJVMdll(var Versao:String):String;
    function GetHashPwd: String;
    procedure SetHashPwd(const Value: String);
    procedure TransmitirXML;
  public
    { Public declarations }
    property Sevidor:String read FSevidor write SetSevidor; //Servidor Proxy
    property Porta:String read FPorta write SetPorta;       //Porta do Servidor Proxy
    property Usuario:String read FUsuario write SetUsuario; //Usurio do Servidor
    property Senha:String read FSenha write SetSenha;       //Senha do Servidor
    property HashPwd: String read GetHashPwd write SetHashPwd;
  end;

var
  frmDlgEnviarXML: TfrmDlgEnviarXML;
  Listas               :Variant;
  {Thread que atualiza a interface durante a gerao dos XMLs.}
  myThread          :TMyThread;

  //Variaveis usadas pelo JNI.
  JavaVM            :TJavaVM;
  Options           :array [0..4] of JavaVMOption;
  VM_args           :JavaVMInitArgs;
  Errcode           :Integer;
  JNIEnv            :TJNIEnv;


implementation

uses Util, UfrmDlgProxy, UMyMessageDlgDiops, StrUtils,
  uFrmDlgHashPwd, Shellapi, uFrmSobre, ModBase;

var versaoAplicativo, nomeArquivo, teste: string;

{$R *.dfm}

procedure TfrmDlgEnviarXML.actGerarExecute(Sender: TObject);
    var GerouArquivos:Boolean;
begin
  nomeArquivo := '';

  if (trim(dirArquivoXML.Text)='') then
  begin
    MyMessageDlg('Selecione o arquivo XML a ser enviado.',mtInformation,[mbOk],0);
    Exit;
  end;

  if (trim(dirDest.Text)= '')then
  begin
     MyMessageDlg('Selecione o local onde ficar a pasta Recibo.',mtInformation,[mbOk],0);
     Exit;
  end;

  if(not DirectoryExists(dirDest.Text))then
  begin
    MyMessageDlg('Destino da pasta recibo(s) invlido.',mtInformation,[mbOk],0);
    Exit;
  end;

  if (not OcorreuErro) then
  begin
    if trim(nomeArquivo) = '' then
        nomeArquivo := StringReplace(dirArquivoXML.Text, '"', '', [rfReplaceAll]);

    StatusBarXML.Panels[0].Text := 'Enviando os dados para ANS...';
    animeEnviarXML.Visible := true;
    self.Repaint;
    TransmitirXML;
  end;

  StatusBarXML.Panels[0].Text := '';
  animeEnviarXML.Visible := false;
  Screen.Cursor := crDefault;
  spbGerar.Enabled := true;
end;

constructor TMyThread.Create(CreateSuspended: Boolean; frm: TForm);
begin
  inherited Create(CreateSuspended);
  Priority := tpNormal;
  form := frm;
end;

{*
* Objetivo...: Mtodo de execuo principal da Thread.
*}
procedure TMyThread.Execute;
begin
  inherited;
  while true do
  begin
    form.Repaint;
    Sleep(1000);
  end;
end;

procedure TfrmDlgEnviarXML.chkUtilizarProxyClick(Sender: TObject);
begin
  if chkUtilizarProxy.Checked then
  begin
    if frmDlgProxy = nil then
      frmDlgProxy := TfrmDlgProxy.Create(self);
    frmDlgProxy.ShowModal;
  end
end;

procedure TfrmDlgEnviarXML.SetPorta(const Value: String);
begin
  FPorta := Value;
end;

procedure TfrmDlgEnviarXML.SetSenha(const Value: String);
begin
  FSenha := Value;
end;

procedure TfrmDlgEnviarXML.SetSevidor(const Value: String);
begin
  FSevidor := Value;
end;

procedure TfrmDlgEnviarXML.SetUsuario(const Value: String);
begin
  FUsuario := Value;
end;

// Retorna um string delimitado pelo max
function TfrmDlgEnviarXML.maxLenght(const dado: String;
  const max: Integer): String;
  var
  i :Integer;
  novaStr :String;
begin
  for i := 1 to max do
  begin
      novaStr := novaStr + dado[i] ;
  end;
  result := novaStr ;
end;

function TfrmDlgEnviarXML.LeftMask(const Value: String; ALength: Word): String;
const
   InvalidChar: Array[0..4] of Char = ('.', ',', '/', '\','-');
var
  i: Word;
  SAux: String;
begin
  (* Remove todos os caracteres da mascara  *)
  SAux := Value;
  for i := 0 to 4 do
    SAux := StringReplace(SAux, InvalidChar[i], '', [rfReplaceAll]);

  try
    if (Length(SAux) < ALength) then
      SAux := FormatFloat(BuidFormatation(ALength), StrToFloat(SAux));
  except
    on e: Exception do
      SAux := SAux ;
  end;

  Result := SAux;
end;

function TfrmDlgEnviarXML.ChangeMaskFormat(const Value, OldChar,
  NewChar: String): String;
    var x: double;
begin
    try
        if trim(value)<>'' then
        begin
            x := roundto(strtofloat( Value),-2);
            Result := StringReplace( FloatToStr(x), OldChar, NewChar, [rfReplaceAll]);
        end
        else
            Result := '';
    except
        on Exception do
            raise EGenerica.Create('O valor "' + Value + '" no  um nmero vlido, verifique na planilha.');
    end;
end;

function TfrmDlgEnviarXML.BuidFormatation(ALength: Word): String;
const
  AZero = '0';
var
  i: Word;
begin
  (* Monta a quantidades de Zeros necessrios para o FormatFloat preencher
    com zeros a esquerda. *)
  Result := '';
  for i := 0 to (ALength - 1) do
     Result := Result + AZero;

end;

function TfrmDlgEnviarXML.LeftMaskContaBalancete(const Value: String; ALength: Word): String;
const
   InvalidChar: Array[0..4] of Char = ('.', ',', '/', '\','-');
var
  i: Word;
  SAux: String;
begin
  SAux := Value;
  for i := 0 to 4 do
    SAux := StringReplace(SAux, InvalidChar[i], '', [rfReplaceAll]);
  Result := LeftStr(SAux,ALength);

end;

procedure TfrmDlgEnviarXML.TransmitirXML;
var
    AException: JThrowable;
    Cls: JClass;
    Mid: JMethodID;
    Obj: JObject;
    transmitiu: Boolean;
    Arquivo: String;
    resultado: JString;
    strResultado: String;
    xml: TUtilXML;
    empresa, tipoDiops, tipoTransacao:String;
    arq, emp, dir, log : JString;
begin
    try
        Cls := nil;
        Mid:= nil;
        Obj := nil;
        AException := nil;
        transmitiu := false;
        resultado := JNIEnv.StringToJString('');
        xml := TUtilXML.create;
        //Cria o diretrio do Recibo
        dirDest.Text := 'C:\';
        CreateDir(dirDest.Text+'\Recibo');
        //Carrega a classe java principal que faz a transmisso dos dados
        Cls := JNIEnv.FindClass(PChar('JNIMain'));

        if Cls = nil then
        begin
            MyMessageDlg('No foi possvel encontrar a Classe JNIMain',mtError,[mbOK],0);
            Exit;
        end;

        //Aloca o Objeto java
        Obj := JNIEnv.AllocObject(Cls);

        if chkUtilizarProxy.Checked then
        begin
            Mid := JNIEnv.GetMethodID(Cls, 'configProxy', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V');

            if Mid = nil then
            begin
                MyMessageDlg('No foi possvel encontrar o mtodo "configProxy" da Classe JNIMain',mtError,[mbOK],0);
                Exit;
            end;

            JNIEnv.CallVoidMethod(Obj,Mid,[ JNIEnv.StringToJString(PAnsiChar(FSevidor)),
                                      JNIEnv.StringToJString(PAnsiChar(FPorta)),
                                      JNIEnv.StringToJString(PAnsiChar(FUsuario)),
                                      JNIEnv.StringToJString(PAnsiChar(FSenha)),
                                      JNIEnv.StringToJString(PAnsiChar('Empresa'))]);
        end;

        //Localiza o mtodo send na classe JNIMain.
        Mid := JNIEnv.GetMethodID(Cls, 'send', '(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;');

        if Mid = nil then
        begin
            MyMessageDlg('No foi possvel encontrar o mtodo "send" da Classe JNIMain',mtError,[mbOK],0);
            Exit;
        end;

        //Define o nome e caminho do arquivo XML no formato entendido pelo java
        Arquivo := StringReplace(nomeArquivo,'\','\\',[rfReplaceAll]);

        //Envio do arquivo Cadastral
        if (rbtDadosCadastrais.Checked) and (trim(nomeArquivo)<>'')then
        begin
            tipoDiops := 'Diops Cadastral';

            //Invoca o metodo que envia o xml para o webservice
            xml.loadFile(nomeArquivo);
            xml.setListNodes('ans:identificador');
            empresa := xml.getCurrentChildValue('ans:razaoSocial');
            tipoTransacao := xml.getCurrentChildValue('ans:transacao');

            if uppercase(trim(tipoTransacao)) <> 'ENVIO_DIOPS_CADASTRAL' then
                raise EGenerica.Create('O arquivo selecionado no  de informaes Cadastrais.' + chr(13) + 'Corrija o problema e tente novamente!');

            if FHashPwd = '' then
            begin
                frmDlgHashPwd := TFrmDlgHashPwd.Create(self);
                FrmDlgHashPwd.ShowModal;
                FHashPwd := frmDlgHashPwd.EdtSenha.text;
            end;

            Dir := JNIEnv.StringToJString(PAnsiChar(UTF8Encode(StringReplace(dirDest.Text,'\','\\',[rfReplaceAll])+'\\Recibo\\')));
            Arq := JNIEnv.StringToJString(PAnsichar(UTF8Encode(Arquivo)));
            Log := JNIEnv.StringToJString(PAnsiChar(UTF8Encode(FHashPwd)));

            resultado := JNIEnv.CallObjectMethod(Obj,Mid,[Dir,Arq,JNIEnv.StringToJString('Cadastral'),Log]);

            strResultado := JNIEnv.UnicodeJStringToString(resultado);

            if strResultado = '' then
                transmitiu := true;
        end
        else
           if (rbtDadosCadastrais.Checked) then
                MyMessageDlg('No foi encontrado o arquivo XML Cadastral.',mtWarning,[mbOK],0);

        //Envio do arquivo Financeiro
        if (rbtDadosFinanceiros.Checked) and (trim(nomeArquivo)<>'') then
        begin
            tipoDiops := 'Diops Financeiro';

            //Invoca o metodo que envia o xml para o webservice
            xml.loadFile(nomeArquivo);
            xml.setListNodes('ans:identificador');
            empresa := xml.getCurrentChildValue('ans:razaoSocial');
            tipoTransacao := xml.getCurrentChildValue('ans:transacao');

            if uppercase(trim(tipoTransacao)) <> 'ENVIO_DIOPS_FINANCEIRO' then
                raise EGenerica.Create('O arquivo selecionado no  de informaes Financeiras.' + chr(13) + 'Corrija o problema e tente novamente!');

           if FHashPwd = '' then
            begin
                frmDlgHashPwd := TFrmDlgHashPwd.Create(self);
                FrmDlgHashPwd.ShowModal;
                FHashPwd := frmDlgHashPwd.EdtSenha.text;
            end;
       
            Dir := JNIEnv.StringToJString(PAnsiChar(UTF8Encode(StringReplace(dirDest.Text,'\','\\',[rfReplaceAll])+'\\Recibo\\')));
            Arq := JNIEnv.StringToJString(PAnsichar(UTF8Encode(Arquivo)));
            Log := JNIEnv.StringToJString(PAnsichar(UTF8Encode(FHashPwd)));

            resultado := JNIEnv.CallObjectMethod(Obj,Mid,[Dir,Arq,JNIEnv.StringToJString('Financeiro'),Log]);

            strResultado := JNIEnv.UnicodeJStringToString(resultado);

            if strResultado = '' then
                transmitiu := true;

        end
        else
           if (rbtDadosFinanceiros.Checked) then
             MyMessageDlg('No foi encontrado o arquivo XML Financeiro.',mtWarning,[mbOK],0);

        //Verifica se ocorreu algum erro.
        AException := JNIEnv.ExceptionOccurred;

        if (AException <> nil) then
        begin
            MyMessageDlg(tipoDiops + chr(13) + 'Ocorreu um erro na comunicao com o WebService.'
                         + chr(13) + strResultado + chr(13) + chr(13) + 'Possveis causas:'
                         + chr(13) + '- Senha informada incorreta;'
                         + chr(13) + '- CNPJ informado no arquivo XML incorreto;'
                         + chr(13) + '- Falha de comunicao com a Internet.'
                         + chr(13), mtError,[mbOK],0);
            JNIEnv.ExceptionClear;
            transmitiu := false;
        end;

       if transmitiu then
        begin
            CreateDir(dirDest.Text+'\Recibo\Imagens');
            imgBotaoImprimir.Picture.SaveToFile(dirDest.Text+'\Recibo\Imagens\bt_imprimir_consumidor.gif');
            imgLogo1.Picture.SaveToFile(dirDest.Text+'\Recibo\Imagens\Logo1.jpg');
            MyMessageDlg('O recibo foi gerado na pasta: ' + dirDest.Text + '\Recibo' + chr(13) +
                         'Acompanhe o andamento do processamento na Pgina de Status do DIOPS-XML, no site da ANS.' + chr(13) +
                         'Havendo erros, corrija-os e envie as novas informaes.', mtInformation, [mbOK], 0);
        end;

        if strResultado <> '' then
            MyMessageDlg('Erro no envio do ' + tipoDiops + ': ' + chr(13) + chr(13) + strResultado,  mtError,[mbOK],0);
       

    except
        on E : Exception do
            MyMessageDlg('Erro: ' + E.Message, mtError, [mbOK], 0);
  end;
end;

function TfrmDlgEnviarXML.GetArquivo(tipo: String): String;
var
  Sr: TSearchRec;
  Lista: TStringList;
  i: Integer;
  arq: String;
begin
  Lista := TStringList.Create;
  FindFirst(dirDest.Text + '\*.*', faDirectory, sr);
  repeat
    if (faDirectory and sr.Attr) <= 0 then // aquivo
    begin
      if (AnsiPos('.XML', AnsiUpperCase(sr.Name)) > 0) and
      (AnsiPos('_'+AnsiUpperCase(Tipo)+'_', AnsiUpperCase(sr.Name)) > 0) and (UpperCase(RightStr(sr.Name,4))='.XML') then
        lista.Add(sr.Name);
    end;
    i := FindNext(sr);
  until i <> 0;
  FindClose(Sr);

  if Lista.Count > 0 then
  begin
    Lista.Sort;

    for i := 0 to lista.Count-1 do
      arq := Lista.Strings[i] ;

  end;
  Result := arq ;
end;

function obterSistemaOperacional: string;
var majorVer, minorVer: Integer;
    osVerInfo: TOSVersionInfo;
begin
    osVerInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);

    if GetVersionEx(osVerInfo) then
    begin
        majorVer := osVerInfo.dwMajorVersion;
        minorVer := osVerInfo.dwMinorVersion;

        case osVerInfo.dwPlatformId of
            VER_PLATFORM_WIN32_NT: { Windows NT/2000 }
            begin
                if majorVer <= 4 then
                    Result := 'Windows NT'
                else if (majorVer = 5) and (minorVer = 0) then
                    Result := 'Windows 2000'
                else if (majorVer = 5) and (minorVer = 1) then
                    Result := 'Windows XP'
                else
                    Result := '';
            end;

            VER_PLATFORM_WIN32_WINDOWS:  { Windows 9x/ME }
            begin
                if (majorVer = 4) and (minorVer = 0) then
                    Result := 'Windows 95'
                else if (majorVer = 4) and (minorVer = 10) then
                begin
                    if osVerInfo.szCSDVersion[1] = 'A' then
                        Result := 'Windows 98SE'
                    else
                        Result := 'Windows 98';
                end
                else if (majorVer = 4) and (minorVer = 90) then
                    Result := 'Windows ME'
                else
                    Result := '';
            end;
            else
                Result := '';
        end;
    end
    else
        Result := '';
end;

procedure TfrmDlgEnviarXML.FormCreate(Sender: TObject);
    var JVMDll, versao, pastaAtualJava, pastaAtualWindows:String;
begin

    versaoAplicativo := '3.7';
    Application.Title := 'DIOPS-XML - Aplicativo Referncia (v.2012 - ' + versaoAplicativo + ') ';
    frmDlgEnviarXML.Caption := Application.Title;

    //Obtm a pasta atual
    pastaAtualWindows := ExtractFilePath(application.ExeName);
    //Retira a barra do final
    pastaAtualWindows := leftstr(pastaAtualWindows, length(pastaAtualWindows)-1);
    //Transforma para o padro Java de Path
    pastaAtualJava := AnsiReplaceStr(pastaAtualWindows, '\', '/');
    //////////////////////////////////////////////
    StatusBarXML.Panels[0].Text := '';
    animeEnviarXML.Active := true;
    JVMDll := getJVMdll(versao);

    frmDlgEnviarXML.Caption := Application.Title + ' {' +  obterSistemaOperacional + ' - JRE ' + versao + '}';

    if (trim(JVMDll) = '') or (leftstr(versao, 3) < '1.6') then
    begin
        MyMessageDlg('No foi possvel localizar a instalao do Java 1.6 (Java Runtime Environment) ou superior.' + chr(13) + 'Desta forma o aplicativo no poder transmitir os arquivos para a ANS.' + chr(13) + 'Verifique o manual para maiores detalhes.', mtInformation, [mbOK], 0);
        rbtDadosFinanceiros.Enabled := false;
        exit;
    end;

    try
        chdir(pastaAtualWindows);

        Errcode := -1;
        //Cria uma instancia de uma JVM
        JavaVM := TJavaVM.Create(JNI_VERSION_1_4, JVMDll);

        pastaAtualJava := '-Djava.class.path=' + pastaAtualJava  +
                                           ';DIOPSClient.jar;'+
                                           'jaxws-api.jar;'+
                                           'classes12.jar;'+
                                           'FastInfoset.jar;'+
                                           'http.jar;'+
                                           'jaxb-api.jar;'+
                                           'jaxb-impl.jar;'+
                                           'jaxb-xjc.jar;'+
                                           'activation.jar;'+
                                           'jaxws-rt.jar;'+
                                           'jsr173_api.jar;'+
                                           'jjsr181-api.jar;'+
                                           'jsr250-api.jar;'+
                                           'ocrs12.jar;'+
                                           'saaj-api.jar;'+
                                           'saaj-impl.jar;'+
                                           'sjsxp.jar;' +
                                           'JNIMain.class';

        Options[0].optionString := pChar(pastaAtualJava);

        VM_args.version := JNI_VERSION_1_4;
        VM_args.options := @Options;
        VM_args.nOptions := 1;
        VM_args.ignoreUnrecognized := false;

        // Carrega a JVM
        Errcode := JavaVM.LoadVM(VM_args);
    except
        on e: Exception do
            MyMessageDlg('Erro ao tentar utilizar a Mquina Virtual Java:' + chr(13) + e.Message,mtError,[mbOK],0);
    end;

    if Errcode < 0 then
    begin
        MyMessageDlg('No foi possvel criar uma instncia da Maquina Virtual Java. Desta forma no ser possivel transmitir os arquivos gerados.',mtError,[mbOK],0);
        Exit;
    end;

    JNIEnv := TJNIEnv.Create(JavaVM.Env);
end;

//Procura uma determinada verso do Java no registro
procedure BuscaVersaoJava (Registro: TRegistry; iniVersao: string; var versaoCompleta: string);
var str: TStrings;
    i: integer;
begin
    try
        str := TStringList.Create;
        Registro.GetKeyNames(str);

        for i:=0 to str.Count-1 do
        begin
            if LeftStr(str.Strings[i], length(iniVersao)) = iniVersao then
            begin
                versaoCompleta := str.Strings[i];
                break;
            end;
        end;
    finally
        str.Free;
    end;
end;

function TfrmDlgEnviarXML.getJVMdll(var Versao:String): String;
var Registro:TRegistry;
  Raiz:String;
begin
    Registro := TRegistry.Create;
    Registro.RootKey := HKEY_LOCAL_MACHINE;

    if registro.KeyExists('Software\JavaSoft') then
    begin
        if registro.KeyExists('Software\JavaSoft\Java Runtime Environment') then
        begin
            Registro.OpenKeyReadOnly('Software\JavaSoft\Java Runtime Environment');
            //Busca a verso do JRE definida em versaoJavaUtilizada
            versao:=registro.ReadString('CurrentVersion');

            if trim(versao) >= '1.5' then
            begin
                Registro.CloseKey;
                Registro.OpenKeyReadOnly('Software\JavaSoft\Java Runtime Environment\'+Versao);
                Result := registro.ReadString('RuntimeLib');
            end;

            Registro.CloseKey;
        end;

        if trim(versao) = '' then
        begin
            if registro.KeyExists('Software\JavaSoft\Java Development Kit') then
            begin
                Registro.OpenKeyReadOnly('Software\JavaSoft\Java Development Kit');
                //Busca a verso corrente do JDK
                versao:=registro.ReadString('CurrentVersion');

                if trim(versao) <> '' then
                begin
                    Registro.CloseKey;
                    Registro.OpenKeyReadOnly('Software\JavaSoft\Java Development Kit\'+Versao);
                    Result := registro.ReadString('JavaHome')+'\jre\bin\client\jvm.dll';
                end;

                Registro.CloseKey;
            end;
        end;
    end
    else
        Result := '';

  FreeAndNil(registro);
end;

function TfrmDlgEnviarXML.GetHashPwd: String;
begin
  Result := uppercase(FHashPwd);
end;

procedure TfrmDlgEnviarXML.SetHashPwd(const Value: String);
begin
  FHashPwd := Value;
end;

procedure TfrmDlgEnviarXML.mnuDuvidasClick(Sender: TObject);
begin
    try
        shellexecute(handle, 'open', 'IEXPLORE.EXE', 'http://www.ans.gov.br/index.php/planos-de-saude-e-operadoras/espaco-da-operadora/central-de-atendimento-operadoras', nil, sw_shownormal);
    except
        on e: Exception do
            MyMessageDlg('Erro ao tentar abrir o Internet Explorer: ' + chr(13) + e.Message, mtError, [mbOK], 0);
    end;
end;

procedure TfrmDlgEnviarXML.Sobre1Click(Sender: TObject);
begin
    frmSobre := TFrmSobre.Create(self);
    frmSobre.ShowModal;
end;

procedure TfrmDlgEnviarXML.Informaes1Click(Sender: TObject);
begin
    try
        shellexecute(handle, 'open', 'IEXPLORE.EXE', 'http://www.ans.gov.br/index.php/diops/aplicativos-diops', nil, sw_shownormal);
    except
        on e: Exception do
            MyMessageDlg('Erro ao tentar abrir o Internet Explorer: ' + chr(13) + e.Message, mtError, [mbOK], 0);
    end;
end;

procedure TfrmDlgEnviarXML.mnuPaginaStatusClick(Sender: TObject);
begin
    try
        shellexecute(handle, 'open', 'IEXPLORE.EXE', 'http://www.ans.gov.br/index.php/diops/aplicativos-diops/consulta-de-diops-enviados', nil, sw_shownormal);
    except
        on e: Exception do
            MyMessageDlg('Erro ao tentar abrir o Internet Explorer: ' + chr(13) + e.Message, mtError, [mbOK], 0);
    end;
end;

procedure TfrmDlgEnviarXML.spbCancelarClick(Sender: TObject);
begin
  if frmDlgProxy <> nil then
    FreeAndNil(frmDlgProxy);
  Application.Terminate;
end;

procedure TfrmDlgEnviarXML.spbImprimeTelaClick(Sender: TObject);
begin
     frmModBase.ImprimeTela;
end;

procedure TfrmDlgEnviarXML.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin

  if frmDlgProxy <> nil then
    FreeAndNil(frmDlgProxy);
  Application.Terminate;

end;

end.
