unit UMyMessageDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ImgList, ComCtrls, Printers, Clipbrd;

type
  TfrmMyMessageDlg = class(TForm)
    pnlBottom: TPanel;
    pnlLeft: TPanel;
    ImageList32: TImageList;
    ImageList16: TImageList;
    memMessage: TMemo;
    SpbPrint: TSpeedButton;
    imgDialogo: TImage;
    spbCancelar: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure spbImprimeTelaClick(Sender: TObject);
    procedure SpbPrintClick(Sender: TObject);
    procedure spbCancelarClick(Sender: TObject);
  private
    { Private declarations }
    procedure TrataTipoDialogo;
    procedure CriarBotoes;
    procedure CreateButton(Button: TMsgDlgBtn; Left: Integer);
    procedure PrintTelaToda;
  public
    { Public declarations }
    Mensagem: String;
    TipoDialog: TMsgDlgType;
    Botoes: TMsgDlgButtons;
    Ajuda: Longint;
    TituloTela: String;
    ImagemTela: TBitmap;
  end;

function MyMessageDlg(const Msg: string; DlgType: TMsgDlgType;
 Buttons: TMsgDlgButtons; HelpCtx: Longint; WinCaption: String = '';
 WinBitmap: TBitmap = nil): Word;

var
  frmMyMessageDlg: TfrmMyMessageDlg;

implementation

{$R *.DFM}

function MyMessageDlg(const Msg: string; DlgType: TMsgDlgType;
 Buttons: TMsgDlgButtons; HelpCtx: Longint; WinCaption: String = '';
 WinBitmap: TBitmap = nil): Word;
begin
  frmMyMessageDlg := TfrmMyMessageDlg.Create(Application);
  try
    frmMyMessageDlg.Mensagem   := Msg;
    frmMyMessageDlg.TipoDialog := DlgType;
    frmMyMessageDlg.Ajuda      := HelpCtx;
    frmMyMessageDlg.TituloTela := WinCaption;
    frmMyMessageDlg.ImagemTela := WinBitmap;
    Result := frmMyMessageDlg.ShowModal;
  finally
    frmMyMessageDlg.Free;
    Screen.Cursor := crDefault;
  end;
end;

procedure TfrmMyMessageDlg.CreateButton(Button: TMsgDlgBtn;
 Left: Integer);
var Button1: TBitBtn;
begin
  Button1            := TBitBtn.Create(pnlBottom);
  Button1.Parent     := pnlBottom;
  Button1.Cursor     := crHandPoint;
  Button1.Height     := 27;
  Button1.Width      := 75;
  Button1.Top        := 4;
  Button1.Left       := Left;
  Button1.Font.Style := Button1.Font.Style + [fsBold];

  if Button = mbYes then
  begin
    ImageList16.GetBitmap(0, Button1.Glyph);
    Button1.Caption     := '&Sim';
    Button1.ModalResult := mrYes;
  end
  else if (Button = mbNo) or (Button = mbNoToAll) then
  begin
    ImageList16.GetBitmap(2, Button1.Glyph);
    Button1.Caption     := '&No';
    Button1.ModalResult := mrNo;
  end
  else if Button = mbOk then
  begin
    ImageList16.GetBitmap(0, Button1.Glyph);
    Button1.Caption     := '&Ok';
    Button1.ModalResult := mrOk;
  end
  else if Button = mbCancel then
  begin
    ImageList16.GetBitmap(1, Button1.Glyph);
    Button1.Caption     := '&Cancelar';
    Button1.ModalResult := mrCancel;
  end
  else if Button = mbAbort then
  begin
    ImageList16.GetBitmap(1, Button1.Glyph);
    Button1.Caption     := '&Abortar';
    Button1.ModalResult := mrAbort;
  end
  else if Button = mbRetry then
  begin
    ImageList16.GetBitmap(3, Button1.Glyph);
    Button1.Caption     := '&Refazer';
    Button1.ModalResult := mrRetry;
  end
  else if Button = mbIgnore then
  begin
    ImageList16.GetBitmap(4, Button1.Glyph);
    Button1.Caption := '&Ignorar';
    Button1.ModalResult := mrIgnore;
  end
  else if (Button = mbAll) or (Button = mbYesToAll) then
  begin
    ImageList16.GetBitmap(0, Button1.Glyph);
    Button1.Caption := '&Todos';
    Button1.ModalResult := mrAll;
  end
  else if Button = mbHelp then
  begin
    ImageList16.GetBitmap(5, Button1.Glyph);
    Button1.Caption := '&Ajuda';
  end;
  Button1.Refresh;
end;

procedure TfrmMyMessageDlg.CriarBotoes;
var
  I, iQtButtons, iTamanhoButtons, iFirstLeft: Integer;
begin
  iQtButtons := 0;
  for I := 0 to 10 do
    if (TMsgDlgBtn(I) in Botoes) then
      iQtButtons := iQtButtons + 1;

  if iQtButtons > 1 then
    iTamanhoButtons := 75 + ((iQtButtons-1)*85)
  else
    iTamanhoButtons := 75;

  // ajusta a largura da tela de acordo com a quantidade de botes
  if (iTamanhoButtons < 300) then
    frmMyMessageDlg.Width := 400
  else if (iTamanhoButtons >= 300) and (iTamanhoButtons < 400) then
    frmMyMessageDlg.Width := 500
  else if (iTamanhoButtons >= 400) and (iTamanhoButtons < 500) then
    frmMyMessageDlg.Width := 600
  else if (iTamanhoButtons >= 500) then
    frmMyMessageDlg.Width := 790;

  iFirstLeft := Round((pnlBottom.Width - iTamanhoButtons) / 2);

  for I := 0 to 10 do
    if (TMsgDlgBtn(I) in Botoes) then
    begin
      CreateButton(TMsgDlgBtn(I), iFirstLeft);
      iFirstLeft := iFirstLeft + 85;
    end;
end;

procedure TfrmMyMessageDlg.FormShow(Sender: TObject);
begin
  CriarBotoes;
  memMessage.Clear;
  memMessage.Text := AdjustLineBreaks(Mensagem);

  // ajusta a altura da tela de acordo com a quantidade de linhas
  if memMessage.Lines.Count > 8 then
    Self.Height := Self.Height + (17*(memMessage.Lines.Count-8));
  if Self.Height > 500 then
  begin
    Self.Height := 500;
    memMessage.ScrollBars := ssVertical;
  end;

  TrataTipoDialogo;
end;

procedure TfrmMyMessageDlg.spbImprimeTelaClick(Sender: TObject);
begin
  // Imprime a Tela
  try
    Screen.Cursor := crHourglass;
    try
      //Self.Print;
      PrintTelaToda;
    except
      MessageDlg('Indisponvel para impresso', mtError, [mbOk], 0);
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TfrmMyMessageDlg.TrataTipoDialogo;
var iImagem: Integer;
begin
  iImagem := -1;
  memMessage.Font.Color := clBlack;
  if TipoDialog = mtWarning then
  begin
    frmMyMessageDlg.Caption := 'CUIDADO';
    iImagem := 0;
  end
  else if TipoDialog = mtError then
  begin
    frmMyMessageDlg.Caption := 'E R R O';
    iImagem := 1;
    memMessage.Font.Color := clRed;
  end
  else if TipoDialog = mtInformation then
  begin
    frmMyMessageDlg.Caption := 'Informao';
    iImagem := 2;
  end
  else if TipoDialog = mtConfirmation then
  begin
    frmMyMessageDlg.Caption := 'Confirme';
    iImagem := 3;
  end
  else if TipoDialog = mtCustom then
  begin
    frmMyMessageDlg.Caption := '';
    iImagem := 4;
  end;

  // se foi passado um novo titulo para a tela de dialog...
  if TituloTela <> '' then
    frmMyMessageDlg.Caption := TituloTela;

end;

procedure TfrmMyMessageDlg.PrintTelaToda;
var
  FormImage: TBitmap;
  Info: PBitmapInfo;
  InfoSize: DWORD;
  Image: Pointer;
  ImageSize: DWORD;
  Bits: HBITMAP;
  DIBWidth, DIBHeight: Longint;
  PrintWidth, PrintHeight: Longint;
begin
  // Colocar no uses: Printers, Clipbrd

  // Capturando a tela da Aplicao para o Clipboard.
  keybd_event(vk_snapshot, 0, 0, 0);

  // Imprimindo a tela capturada.
  Printer.Orientation := poLandscape;
  Printer.BeginDoc;
  try
    FormImage := TBitMap.Create;
    FormImage.Assign(Clipboard);
    Canvas.Lock;
    try
      { Paint bitmap to the printer }
      with Printer, Canvas do
      begin
        Bits := FormImage.Handle;
        GetDIBSizes(Bits, InfoSize, ImageSize);
        Info := AllocMem(InfoSize);
        try
          Image := AllocMem(ImageSize);
          try
            GetDIB(Bits, 0, Info^, Image^);
            with Info^.bmiHeader do
            begin
              DIBWidth := biWidth;
              DIBHeight := biHeight;
            end;
            case PrintScale of
              poProportional:
                begin
                  PrintWidth := MulDiv(DIBWidth, GetDeviceCaps(Handle,
                    LOGPIXELSX), PixelsPerInch) - 500;  // O (-500)  apenas p/impedir o corte da margem direita da tela capturada.
                  PrintHeight := MulDiv(DIBHeight, GetDeviceCaps(Handle,
                    LOGPIXELSY), PixelsPerInch) - 500;  // O (-500)  apenas p/redimensionar a figura conforme o tamanho acima.
                end;
              poPrintToFit:
                begin
                  PrintWidth := MulDiv(DIBWidth, PageHeight, DIBHeight);
                  if PrintWidth < PageWidth then
                    PrintHeight := PageHeight
                  else
                  begin
                    PrintWidth := PageWidth;
                    PrintHeight := MulDiv(DIBHeight, PageWidth, DIBWidth);
                  end;
                end;
            else
              PrintWidth := DIBWidth;
              PrintHeight := DIBHeight;
            end;
            StretchDIBits(Canvas.Handle, 0, 0, PrintWidth, PrintHeight, 0, 0,
              DIBWidth, DIBHeight, Image, Info^, DIB_RGB_COLORS, SRCCOPY);
          finally
            FreeMem(Image, ImageSize);
          end;
        finally
          FreeMem(Info, InfoSize);
        end;
      end;
    finally
      Canvas.Unlock;
      FormImage.Free;
    end;
  finally
    Printer.EndDoc;
    Clipboard.Clear;
  end;
end;

procedure TfrmMyMessageDlg.SpbPrintClick(Sender: TObject);
begin
  // Imprime a Tela
  try
    Screen.Cursor := crHourglass;
    try
      //Self.Print;
      PrintTelaToda;
    except
      MessageDlg('Indisponvel para impresso', mtError, [mbOk], 0);
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TfrmMyMessageDlg.spbCancelarClick(Sender: TObject);
begin
   Close;
end;

end.
