unit ModBase;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  stdctrls, buttons, comctrls, ShellApi, DB, DBClient;

type
  TfrmModBase = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FBotoesCursorWeb: Boolean;
    FAbreCampoLookupAutomatico: Boolean;
    procedure SetBotoesCursorWeb(const Value: Boolean);
    procedure SetAbreCampoLookupAutomatico(const Value: Boolean);
    { Private declarations }
  public
    { Public declarations }
    property BotoesCursorWeb: Boolean read FBotoesCursorWeb
     write SetBotoesCursorWeb;
    property AbreCampoLookupAutomatico: Boolean read FAbreCampoLookupAutomatico write SetAbreCampoLookupAutomatico;

    procedure ImprimeTela;
    procedure ExibeCalc;

    procedure AbreCamposLookup(DataSet: TDataSet);
  end;

const
  clAnsAzulClaro  = TColor($00F4EAE3);
  clAnsAzulMedio  = TColor($00B7724A);
  clAnsAzulEscuro = TColor($0089503B);

var
  frmModBase: TfrmModBase;

implementation

{$R *.DFM}

procedure TfrmModBase.SetBotoesCursorWeb(const Value: Boolean);
var
  I: Integer;
  CursorType: TCursor;
begin
  // Configura o Cursor dos botes...
  FBotoesCursorWeb := Value;
  if FBotoesCursorWeb then
    CursorType := crHandPoint
  else
    CursorType := crDefault;

  for I := 0 to (ComponentCount-1) do
    if (Components[I].ClassName = 'TButton') or
       (Components[I].ClassName = 'TBitBtn') then
      TButton(Components[I]).Cursor := CursorType
    else if (Components[I].ClassName = 'TSpeedButton') then
      TSpeedButton(Components[I]).Cursor := CursorType
    else if (Components[I].ClassName = 'TToolButton') then
      TToolButton(Components[I]).Cursor := CursorType;
end;

procedure TfrmModBase.FormCreate(Sender: TObject);
begin
  // Como default, inicializa o cursor com HandPoint
  BotoesCursorWeb := True;
  AbreCampoLookupAutomatico := True;
end;

procedure TfrmModBase.ImprimeTela;
begin
  // Imprime a Tela
  try
    Screen.Cursor := crHourglass;
    try
      Self.Print;
    except
      MessageDlg('Indisponvel para impresso', mtError, [mbOk], 0);
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TfrmModBase.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  // Tecla de Atalho para a Calculadora
  if Key = VK_F5 then   // <F5> Calculadora do Windows
    ExibeCalc;
end;

procedure TfrmModBase.ExibeCalc;
begin
  // Exibe a Calculadora do Windows
  ShellExecute(0, 'open', 'calc.exe', '', '', SW_RESTORE);

end;

procedure TfrmModBase.AbreCamposLookup(DataSet: TDataSet);
var I: Integer;
begin
  // Abre de forma "ESPECIAL" todos os Lookups de um DataSet
  // =======================================================
  // Varre todos os fields...
  for I := 0 to (DataSet.Fields.Count-1) do
    // Se for um campo Lookup
    if (DataSet.Fields[I].FieldKind = fkLookup) and
       (DataSet.Fields[I].LookupDataSet.ClassName = 'TClientDataSet') and
       (Trim(TClientDataSet(DataSet.Fields[I].LookupDataSet).ProviderName) <> '') then
    begin
      // Abre arquivos ClientDataSet para serem usados como Lookup...
      // ============================================================
      // Se o Tag for 0, precisa de atualizao (refresh), por ser uma tabela
      //                 com atualizaes constantes.
      // Se o Tag for 1,  uma tabela com poucas atualizaes, portanto, pode ser
      //                 aberta uma unica vez e no precisa mais ser atualizada.
      if (DataSet.Fields[I].LookupDataSet.Tag=0) and
         (DataSet.Fields[I].LookupDataSet.Active) then
        DataSet.Fields[I].LookupDataSet.Close;

      DataSet.Fields[I].LookupDataSet.Open;
    end;
end;

procedure TfrmModBase.SetAbreCampoLookupAutomatico(const Value: Boolean);
begin
  FAbreCampoLookupAutomatico := Value;
end;

end.


