/*
 * Decompiled with CFR 0.152.
 */
package br.gov.ans.diope.diopsclient;

import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import ws.cadastral.CtDiopsCadastral;
import ws.cadastral.CtReciboRecebimento;
import ws.cadastral.DiopsCadastral;
import ws.cadastral.DiopsCadastralPortType;
import ws.financeiro.CtDiopsFinanc;
import ws.financeiro.DiopsFinanc;
import ws.financeiro.DiopsFinancPortType;

public class SendXML {
    private static final String CERTIFICADO_VA = "ANS_CERT";
    private String path = "";
    private String proxyHost = "";
    private String proxyPort = "";
    private String proxyUser = "";
    private String proxyPassword = "";
    private Boolean proxyActive = false;
    private String senha;

    public SendXML() {
    }

    public SendXML(String path, String senha) {
        this.path = path;
        this.senha = senha;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    private String formatNumber(int value) {
        if (value < 10) {
            return "00" + String.valueOf(value);
        }
        if (value >= 10 && value <= 99) {
            return "0" + String.valueOf(value);
        }
        return String.valueOf(value);
    }

    public void ConfigProxy(String proxyHost, String proxyPort, String proxyUser, String proxyPassword) {
        this.proxyActive = true;
        this.proxyHost = proxyHost;
        this.proxyPassword = proxyPassword;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
    }

    public String descricaoTrimestre(Timestamp data) {
        int ano = Integer.valueOf(data.toString().substring(0, 4));
        int mes = Integer.valueOf(data.toString().substring(5, 7));
        if (mes >= 1 && mes <= 3) {
            return "1\u00ba Trimestre de " + ano;
        }
        if (mes >= 4 && mes <= 6) {
            return "2\u00ba Trimestre de " + ano;
        }
        if (mes >= 7 && mes <= 9) {
            return "3\u00ba Trimestre de " + ano;
        }
        return "4\u00ba Trimestre de " + ano;
    }

    public static Timestamp toTimestamp(XMLGregorianCalendar dataXML) {
        Timestamp data = null;
        if (dataXML != null) {
            String sData = dataXML.toString();
            if (sData.length() == 10) {
                sData = sData + " 00:00:00.0";
            }
            data = Timestamp.valueOf(sData);
        }
        return data;
    }

    public String sendObject(Object obj, String tipo) {
        Locale locale = new Locale("pt", "br");
        String erroLeituraArquivo = "Erro na montagem das informa\u00e7\u00f5es.\nIsto ocorre quando o aplicativo nao consegue ler o arquivo XML na pasta especificada.\nTroque de pasta para um caminho mais simples, sem caracteres especiais nos nomes das pastas.\nCaracteres especiais podem ser acentuacoes, letras sub ou sobrescritas e ate mesmo caracteres nao imprimiveis.";
        DateFormat df = DateFormat.getDateInstance(2, locale);
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("user.dir") + File.pathSeparator + "cacerts");
        System.setProperty("javax.net.ssl.trustStore", System.getenv().get(CERTIFICADO_VA));
        if (this.proxyActive.booleanValue()) {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
            System.setProperty("http.proxyUser", this.proxyUser);
            System.setProperty("http.proxyPassword", this.proxyPassword);
        }
        if (tipo.equalsIgnoreCase("Cadastral")) {
            try {
                CtDiopsCadastral diopsCadastral = (CtDiopsCadastral)obj;
                if (diopsCadastral == null) {
                    return "Erro na montagem das informa\u00e7\u00f5es.\nIsto ocorre quando o aplicativo nao consegue ler o arquivo XML na pasta especificada.\nTroque de pasta para um caminho mais simples, sem caracteres especiais nos nomes das pastas.\nCaracteres especiais podem ser acentuacoes, letras sub ou sobrescritas e ate mesmo caracteres nao imprimiveis.";
                }
                String empresa = diopsCadastral.getIdentificador().getRazaoSocial();
                DiopsCadastral service = new DiopsCadastral();
                DiopsCadastralPortType port = service.getDiopsCadastralPort();
                if (diopsCadastral.getIdentificador().getCNPJ() == null || diopsCadastral.getIdentificador().getCNPJ().equals("")) {
                    return "Login incorreto. CNPJ da operadora n\u00e3o informado!";
                }
                if (this.senha == null || this.senha.equals("")) {
                    return "Login incorreto. Senha n\u00e3o informada!";
                }
                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.username", diopsCadastral.getIdentificador().getCNPJ().substring(0, 8));
                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.password", this.senha);
                CtReciboRecebimento result_cadastral = port.diopsCadastralOperation(diopsCadastral);
                if (result_cadastral == null) {
                    return "N\u00e3o foi poss\u00edvel abrir a porta de conex\u00e3o ao servi\u00e7o Diops Cadastral.";
                }
                StringTokenizer horaToken = new StringTokenizer(result_cadastral.getIdentificacaoTransacao().getHoraRegistroTransacao(), ".");
                String hora = horaToken.nextToken();
                GregorianCalendar dataHora = result_cadastral.getIdentificacaoTransacao().getDataRegistroTransacao().toGregorianCalendar();
                String dataFormat = String.format("%1$tY%1$tm%1$td", dataHora.getTime());
                String horaFormat = hora.replace(":", "");
                FileWriter html = new FileWriter(this.path + "RECIBO_ANS_" + tipo.toUpperCase() + "_" + dataFormat.trim() + horaFormat.trim() + ".html");
                String corpo = "<HTML><HEAD><TITLE>Recibo de DIOPS " + tipo + " - ANS</TITLE><META NAME=\"GENERATOR\" CONTENT=\"Sothink HTML Editor\">" + "<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"10\" CELLSPACING=\"5\" WIDTH = \"10\"> <TR><TD><IMG SRC=\"Imagens/Logo1.jpg\" ALT=\"\" ></TD>" + "<TD ALIGN=\"CENTER\"><FONT FACE=\"Verdana\" SIZE=\"5\" COLOR=\"teal\"><B> Recibo de DIOPS " + tipo + " </B></font>" + "</TD></TR></TABLE></HEAD><BODY>";
                html.write(corpo);
                corpo = "<FONT FACE=\"Courier New\" SIZE=\"2\" COLOR=\"#000000\"> <BR> N\u00famero do Recibo: " + result_cadastral.getIdentificacaoTransacao().getSequencialTransacao() + "<BR> Empresa: " + empresa + "<BR> Registro ANS: " + diopsCadastral.getIdentificador().getRegistroANS() + "<BR> Recebimento: " + String.valueOf(df.format(dataHora.getTime())) + " \u00e0s " + String.valueOf(hora) + "<BR> " + "<BR> Status: <B>";
                if (result_cadastral.getErro().isEmpty()) {
                    corpo = corpo + "Informa\u00e7\u00f5es recebidas. Acompanhe a valida\u00e7\u00e3o no site da ANS.</B>";
                    corpo = corpo + "</FONT><P><A HREF=\"javascript:window.print();\"><IMG SRC=\"Imagens/bt_imprimir_consumidor.gif\" ALT=\"Imprimir Recibo\" BORDER =\"none\" >" + "</A></BODY></HTML>";
                } else {
                    corpo = corpo + "Rejeitado</B>";
                    corpo = corpo + "</FONT><BR><BR>Erros a serem corrigidos: <BR><TABLE BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">" + "<FONT FACE=\"Courier New\" SIZE=\"2\" COLOR=\"#000000\">";
                    for (int x = 0; x < result_cadastral.getErro().size(); ++x) {
                        corpo = corpo + "<TR><TD>" + this.formatNumber(x + 1) + "</TD><TD>" + result_cadastral.getErro().get(x) + "</TD></TR>";
                    }
                    corpo = corpo + "</FONT></TABLE><P><A HREF=\"javascript:window.print();\"><IMG SRC=\"Imagens/bt_imprimir_consumidor.gif\" ALT=\"Imprimir Recibo\" BORDER =\"none\" >" + "</A></BODY></HTML>";
                }
                html.write(corpo);
                html.close();
                return "";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
        }
        if (tipo.equalsIgnoreCase("Financeiro")) {
            try {
                CtDiopsFinanc diopsFinanc = (CtDiopsFinanc)obj;
                if (diopsFinanc == null) {
                    return "Erro na montagem das informa\u00e7\u00f5es.\nIsto ocorre quando o aplicativo nao consegue ler o arquivo XML na pasta especificada.\nTroque de pasta para um caminho mais simples, sem caracteres especiais nos nomes das pastas.\nCaracteres especiais podem ser acentuacoes, letras sub ou sobrescritas e ate mesmo caracteres nao imprimiveis.";
                }
                String empresa = diopsFinanc.getIdentificador().getRazaoSocial();
                DiopsFinanc service = new DiopsFinanc();
                DiopsFinancPortType port = service.getDiopsFinancPort();
                if (diopsFinanc.getIdentificador().getCNPJ() == null || diopsFinanc.getIdentificador().getCNPJ().equals("")) {
                    return "Login incorreto. CNPJ da operadora n\u00e3o informado!";
                }
                if (this.senha == null || this.senha.equals("")) {
                    return "Login incorreto. Senha n\u00e3o informada!";
                }
                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.username", diopsFinanc.getIdentificador().getCNPJ().substring(0, 8));
                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.password", this.senha);
                ws.financeiro.CtReciboRecebimento result_financeiro = port.diopsFinancOperation(diopsFinanc);
                if (result_financeiro == null) {
                    return "N\u00e3o foi poss\u00edvel abrir a porta de conex\u00e3o ao servi\u00e7o Diops Financeiro.";
                }
                StringTokenizer horaToken = new StringTokenizer(result_financeiro.getIdentificacaoTransacao().getHoraRegistroTransacao(), ".");
                String hora = horaToken.nextToken();
                GregorianCalendar dataHora = result_financeiro.getIdentificacaoTransacao().getDataRegistroTransacao().toGregorianCalendar();
                String dataFormat = String.format("%1$tY%1$tm%1$td", dataHora.getTime());
                String horaFormat = hora.replace(":", "");
                FileWriter html = new FileWriter(this.path + "RECIBO_ANS_" + tipo.toUpperCase() + "_" + dataFormat.trim() + horaFormat.trim() + ".html");
                String trimestre = this.descricaoTrimestre(SendXML.toTimestamp(diopsFinanc.getIdentificador().getPeriodo()));
                String corpo = "<HTML><HEAD><TITLE>Recibo de DIOPS " + tipo + " - ANS</TITLE><META NAME=\"GENERATOR\" CONTENT=\"Sothink HTML Editor\">" + "<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"10\" CELLSPACING=\"5\" WIDTH = \"10\"> <TR><TD><IMG SRC=\"Imagens/Logo1.jpg\" ALT=\"\" ></TD>" + "<TD ALIGN=\"CENTER\"><FONT FACE=\"Verdana\" SIZE=\"5\" COLOR=\"teal\"><B> Recibo de DIOPS " + tipo + " </B></font>" + "</TD></TR></TABLE></HEAD><BODY>";
                html.write(corpo);
                corpo = "<FONT FACE=\"Courier New\" SIZE=\"2\" COLOR=\"#000000\"> <BR> N\u00famero do Recibo: " + result_financeiro.getIdentificacaoTransacao().getSequencialTransacao() + "<BR> Empresa: " + empresa + "<BR> Registro ANS: " + diopsFinanc.getIdentificador().getRegistroANS() + "<BR> Recebimento: " + String.valueOf(df.format(dataHora.getTime())) + " \u00e0s " + String.valueOf(hora) + "<BR> " + "<BR> Status: <B>";
                if (result_financeiro.getErro().isEmpty()) {
                    corpo = corpo + "Informa\u00e7\u00f5es do " + trimestre + " recebidas e aguardando valida\u00e7\u00e3o. Acompanhe no site da ANS.</B>";
                    corpo = corpo + "</FONT><P><A HREF=\"javascript:window.print();\"><IMG SRC=\"Imagens/bt_imprimir_consumidor.gif\" ALT=\"Imprimir Recibo\" BORDER =\"none\" >" + "</A></BODY></HTML>";
                } else {
                    corpo = corpo + "Rejeitado</B>";
                    corpo = corpo + "</FONT><BR><BR>Erros a serem corrigidos: <BR><TABLE BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">" + "<FONT FACE=\"Courier New\" SIZE=\"2\" COLOR=\"#000000\">";
                    for (int x = 0; x < result_financeiro.getErro().size(); ++x) {
                        corpo = corpo + "<TR><TD>" + this.formatNumber(x + 1) + "</TD><TD>" + result_financeiro.getErro().get(x) + "</TD></TR>";
                    }
                    corpo = corpo + "</FONT></TABLE><P><A HREF=\"javascript:window.print();\"><IMG SRC=\"Imagens/bt_imprimir_consumidor.gif\" ALT=\"Imprimir Recibo\" BORDER =\"none\" >" + "</A></BODY></HTML>";
                }
                html.write(corpo);
                html.close();
                return "";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
        }
        return "";
    }

    public static Object xmlToObjectCadastral(String xmlPath) {
        File fileXML = new File(xmlPath);
        Object w_resp = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"ws.cadastral");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            w_resp = ((JAXBElement)unmarshaller.unmarshal(fileXML)).getValue();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return w_resp;
    }

    public static Object xmlToObjectFinanceiro(String xmlPath) {
        File fileXML = new File(xmlPath);
        Object w_resp = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"ws.financeiro");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            w_resp = ((JAXBElement)unmarshaller.unmarshal(fileXML)).getValue();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return w_resp;
    }
}

