package br.gov.saude.cadsus.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.GregorianCalendar;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import br.gov.saude.cadsus.client.UsuarioSUSType.Enderecos;
import br.gov.saude.cadsus.client.UsuarioSUSType.Telefones;

public class Teste {
	
	private static final String REQUEST_INCLUIR = "{REQUEST.INCLUIR}";
	private static StringBuilder templateEnvelope;
	
	static{
		templateEnvelope = new StringBuilder();
		templateEnvelope.append("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:cad=\"http://servicos.saude.gov.br/cadsus/v5r0/cadsusservice\" xmlns:cnes=\"http://servicos.saude.gov.br/wsdl/mensageria/v5r0/cnesusuario\" xmlns:usu=\"http://servicos.saude.gov.br/schema/cadsus/v5r0/usuariosus\" xmlns:cns=\"http://servicos.saude.gov.br/schema/cadsus/v5r0/cns\" xmlns:cpf=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r2/cpf\" xmlns:nom=\"http://servicos.saude.gov.br/schema/corporativo/pessoafisica/v1r2/nomecompleto\" xmlns:sexo=\"http://servicos.saude.gov.br/schema/corporativo/pessoafisica/v1r1/sexo\" xmlns:rac=\"http://servicos.saude.gov.br/schema/corporativo/pessoafisica/v1r2/racacor\" xmlns:etn=\"http://servicos.saude.gov.br/schema/corporativo/pessoafisica/v1r2/etniaindigena\" xmlns:dad=\"http://servicos.saude.gov.br/schema/corporativo/pessoafisica/v1r1/dadosnacionalidade\" xmlns:pais=\"http://servicos.saude.gov.br/schema/corporativo/v1r2/pais\" xmlns:mun=\"http://servicos.saude.gov.br/schema/corporativo/v1r2/municipio\" xmlns:uf=\"http://servicos.saude.gov.br/schema/corporativo/v1r1/uf\" xmlns:doc=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r2/documentos\" xmlns:iden=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/identidade\" xmlns:org=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r2/orgaoemissor\" xmlns:ctps=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/ctps\" xmlns:cnh=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/cnh\" xmlns:tit=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/tituloeleitor\" xmlns:nis=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/nis\" xmlns:pas=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/passaporte\" xmlns:ric=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/ric\" xmlns:dnv=\"http://servicos.saude.gov.br/schema/corporativo/documento/v1r1/dnv\" xmlns:cer=\"http://servicos.saude.gov.br/schema/corporativo/documento/certidao/v1r1/certidoes\" xmlns:cer1=\"http://servicos.saude.gov.br/schema/corporativo/documento/certidao/v1r2/certidao\" xmlns:cer2=\"http://servicos.saude.gov.br/schema/corporativo/documento/certidao/v1r1/certidaoantiga\" xmlns:end=\"http://servicos.saude.gov.br/schema/corporativo/endereco/v1r2/endereco\" xmlns:tip=\"http://servicos.saude.gov.br/schema/corporativo/endereco/v1r1/tipologradouro\" xmlns:bair=\"http://servicos.saude.gov.br/schema/corporativo/endereco/v1r1/bairro\" xmlns:cep=\"http://servicos.saude.gov.br/schema/corporativo/endereco/v1r1/cep\" xmlns:tel=\"http://servicos.saude.gov.br/schema/corporativo/telefone/v1r2/telefone\" xmlns:tip1=\"http://servicos.saude.gov.br/schema/corporativo/telefone/v1r1/tipotelefone\" xmlns:ema=\"http://servicos.saude.gov.br/schema/corporativo/v5r0/emails\" xmlns:ema1=\"http://servicos.saude.gov.br/schema/corporativo/v1r2/email\" xmlns:fot=\"http://servicos.saude.gov.br/schema/corporativo/v1r1/fotografia\" xmlns:iden1=\"http://servicos.saude.gov.br/schema/cadsus/v5r0/identificadorlocal\" xmlns:iden2=\"http://servicos.saude.gov.br/schema/cadsus/v5r0/identificadorcorporativo\" xmlns:gra=\"http://servicos.saude.gov.br/schema/cadsus/v5r0/grauqualidade\" xmlns:dad1=\"http://servicos.saude.gov.br/schema/cadsus/v1r1/dadosprecadastro\" xmlns:prot=\"http://servicos.saude.gov.br/schema/cadsus/v1r0/protocoloprecadastro\">");
		templateEnvelope.append("<soap:Header/>");
		templateEnvelope.append("<soap:Body>");
		templateEnvelope.append(REQUEST_INCLUIR);      
		templateEnvelope.append("</soap:Body>");
		templateEnvelope.append("</soap:Envelope>");
	}

	public static void main(String[] args)
			throws DatatypeConfigurationException {

		File arquivo = new File("C:\\desenv_java\\file.xml");
		
		RequestIncluir requestIncluir = gerarRequest();

		try {

			JAXBContext jaxbContext = JAXBContext
					.newInstance(RequestIncluir.class);
			Marshaller jaxbMarshaller = jaxbContext.createMarshaller();

			// output pretty printed
			//jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
			jaxbMarshaller.setProperty(Marshaller.JAXB_FRAGMENT, Boolean.TRUE);			
			jaxbMarshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper",new CadsusNamespaceMapper());

			
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			jaxbMarshaller.marshal(requestIncluir, bos);
			
			String strRequestIncluir = new String(bos.toByteArray());
			
			String linha = gerarLinha(strRequestIncluir);
			
			System.out.println(linha);
			
			adicionarLinha(linha, arquivo);
			

		} catch (JAXBException e) {
			e.printStackTrace();
		}

	}

	private static RequestIncluir gerarRequest()
			throws DatatypeConfigurationException {
		RequestIncluir requestIncluir = new RequestIncluir();
		requestIncluir.setCNESUsuario(new CNESUsuarioType());
		requestIncluir.getCNESUsuario().setCNES("123456");
		requestIncluir.getCNESUsuario().setUsuario("bla");
		requestIncluir.getCNESUsuario().setSenha("12345678");
		requestIncluir.setUsuarioSUS(criarUsuario());
		return requestIncluir;
	}

	private static void adicionarLinha(String linha, File arquivo) {
		try {
			if(arquivo.exists()){
				Files.write(arquivo.toPath(), linha.getBytes(), StandardOpenOption.APPEND);
			} else {
				Files.write(arquivo.toPath(), linha.getBytes(), StandardOpenOption.CREATE);
			}
		    
		}catch (IOException e) {
		    //exception handling left as an exercise for the reader
		}
		
	}

	private static String gerarLinha(String strRequestIncluir) {
		return templateEnvelope.toString().replace(REQUEST_INCLUIR, strRequestIncluir)+"\n";
	}

	private static UsuarioSUSType criarUsuario()
			throws DatatypeConfigurationException {
		UsuarioSUSType u = new UsuarioSUSType();
		u.setNomeCompleto(criarNome("PAULO FARIA"));
		u.setMae(criarNome("MARIA LUCIA FARIA"));
		u.setPai(criarNome("JOAO DA SANTOS"));
		u.setDataNascimento(criarDataNascimento());
		u.setSexo(criarTypeSexo("M"));
		u.setRacaCor(criarRacaCorType("02"));
		u.setTipoSanguineo("O+");
		u.setDadosNacionalidade(criarDadosNacionalidade(NacionalidadeType.B,
				"010"));
		u.setMunicipioNascimento(criarMunicipioType());
		u.setEnderecos(criarEnderecoType());
		u.setTelefones(criarTelefones());
		u.setIdentificadorLocal(criarIdentificadorLocal());
		return u;
	}

	private static XMLGregorianCalendar criarDataNascimento()
			throws DatatypeConfigurationException {
		GregorianCalendar gregorianCalendar = new GregorianCalendar(2010, 5, 12);
		return DatatypeFactory.newInstance().newXMLGregorianCalendar(
				gregorianCalendar);
	}

	private static IdentificadorLocalType criarIdentificadorLocal() {
		IdentificadorLocalType type = new IdentificadorLocalType();
		type.setIdentificadorSistema("CADSUS-OFFLINE");
		type.setNumeroIdentificadorLocal("0028360122106107283601221061077102041515551775046727200000");
		return type;
	}

	/**
	 * @return
	 */
	private static Telefones criarTelefones() {
		Telefones telefones = new Telefones();

		TelefoneType t = new TelefoneType();
		TipoTelefoneType tipo = new TipoTelefoneType();
		tipo.setCodigoTipoTelefone("2");
		t.setTipoTelefone(tipo);
		t.setDDD(61);
		t.setNumeroTelefone(35669541);
		telefones.getTelefone().add(t);

		return telefones;
	}

	/**
	 * @return
	 */
	private static Enderecos criarEnderecoType() {
		Enderecos type = new Enderecos();
		EnderecoType e = new EnderecoType();

		e.setTipoEndereco("2");
		TipoLogradouroType logradouro = new TipoLogradouroType();

		logradouro.setCodigoTipoLogradouro("699");
		e.setTipoLogradouro(logradouro);

		e.setNomeLogradouro("QI 25");
		e.setNumero("13");
		e.setComplemento("casa");

		BairroType bairro = new BairroType();
		bairro.setDescricaoBairro("GUARA II");
		e.setBairro(bairro);

		CEPType cep = new CEPType();
		cep.setNumeroCEP("71060250");
		e.setCEP(cep);

		e.setMunicipio(criarMunicipioType());

		e.setPais(criarPais("010"));

		type.setEndereco(e);
		return type;
	}

	private static MunicipioType criarMunicipioType() {
		MunicipioType type = new MunicipioType();
		UFType uf = new UFType();
		uf.setCodigoUF("53");
		uf.setSiglaUF("DF");
		type.setCodigoMunicipio("520870");
		type.setUF(uf);
		return type;
	}

	private static DadosNacionalidadeType criarDadosNacionalidade(
			NacionalidadeType nacionalidade, String p) {
		DadosNacionalidadeType type = new DadosNacionalidadeType();
		PaisType pais = criarPais(p);
		type.setNacionalidade(nacionalidade);
		type.setPaisNascimento(pais);
		return type;
	}

	private static PaisType criarPais(String p) {
		PaisType pais = new PaisType();
		pais.setCodigoPais(p);
		return pais;
	}

	private static RacaCorType criarRacaCorType(String string) {
		RacaCorType type = new RacaCorType();
		type.setCodigoRacaCor(string);
		return type;
	}

	private static SexoType criarTypeSexo(String string) {
		SexoType sexoType = new SexoType();
		sexoType.setCodigoSexo(string);
		return sexoType;
	}

	private static NomeCompletoType criarNome(String string) {
		NomeCompletoType type = new NomeCompletoType();
		type.setNome(string);
		return type;
	}

}
